/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.common.exception;

import estonlabs.cxtl.common.exception.ErrorCode;

public class CxtlApiException
extends RuntimeException {
    private final String errorMessage;
    private final String exchangeErrorCode;
    private final ErrorCode errorCode;

    public CxtlApiException(String errorMessage, String exchangeErrorCode, ErrorCode errorCode) {
        super(CxtlApiException.msg(errorMessage, exchangeErrorCode));
        this.errorMessage = errorMessage;
        this.exchangeErrorCode = exchangeErrorCode;
        this.errorCode = errorCode;
    }

    public CxtlApiException(String errorMessage, String exchangeErrorCode, ErrorCode errorCode, Throwable cause) {
        super(CxtlApiException.msg(errorMessage, exchangeErrorCode), cause);
        this.errorMessage = errorMessage;
        this.exchangeErrorCode = exchangeErrorCode;
        this.errorCode = errorCode;
    }

    public CxtlApiException(String errorMessage, Throwable cause) {
        this(errorMessage, null, ErrorCode.UNKNOWN_ERROR, cause);
    }

    private static String msg(String errorMessage, String errorCode) {
        return errorCode == null ? errorMessage : "[" + errorCode + "] " + errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getExchangeErrorCode() {
        return this.exchangeErrorCode;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }
}

