/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.common.http;

import estonlabs.cxtl.common.codec.Codec;
import estonlabs.cxtl.common.codec.JacksonCodec;
import estonlabs.cxtl.common.exception.CxtlEventException;
import estonlabs.cxtl.common.http.Event;
import estonlabs.cxtl.common.http.HeaderBuilder;
import estonlabs.cxtl.common.http.Method;
import estonlabs.cxtl.common.http.RestClient;
import java.io.IOException;
import java.net.Proxy;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import lombok.NonNull;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class JsonRestClient
implements RestClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonRestClient.class);
    private static final MediaType MEDIA_TYPE = MediaType.parse("application/json; charset=utf-8");
    private final String urlPrefix;
    private final OkHttpClient client;
    private final Codec<Object> codec;

    public JsonRestClient(URI uri, Codec<Object> codec, Proxy proxy) {
        this.urlPrefix = uri.toString();
        this.codec = codec;
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient().newBuilder();
        this.client = (proxy == null ? httpClientBuilder : httpClientBuilder.proxy(proxy)).build();
    }

    @Override
    public Proxy getProxy() {
        return this.client.proxy();
    }

    @Override
    public <IN, OUT> Mono<Event<OUT>> deleteAsForm(HeaderBuilder header, String path, IN message, Class<OUT> responseType) {
        Map<String, ?> map = this.codec.toMap(message);
        String strMessage = JacksonCodec.mapToStringBuilder(map, new StringBuilder()).toString();
        RequestBody body = JsonRestClient.formBody(map);
        LOGGER.info("DELETE: {}{} [{}]", this.urlPrefix, path, strMessage);
        return this.delete(header, path, responseType, strMessage, body);
    }

    @NonNull
    private <OUT> Mono<Event<OUT>> delete(HeaderBuilder header, String path, Class<OUT> responseType, String strMessage, RequestBody body) {
        Request.Builder requestBuilder = this.buildRequest(header, path, strMessage);
        return Mono.fromSupplier(() -> requestBuilder.delete(body).build()).flatMap(r -> Mono.create(sink2 -> this.client.newCall((Request)r).enqueue(new FnCallback<Object>((MonoSink<Event<Object>>)sink2, new Event(path + "(" + strMessage + ")" + JsonRestClient.headers(r)), res -> this.codec.fromJson((String)res, responseType)))));
    }

    @Override
    public <IN, OUT> Mono<Event<OUT>> deleteAsParams(HeaderBuilder header, String path, IN message, Class<OUT> responseType) {
        Map<String, ?> map = this.codec.toMap(message);
        StringBuilder strMessage = JacksonCodec.mapToStringBuilder(map, new StringBuilder());
        return this.parameterisedRequest(Method.DELETE, header, path, (IN)strMessage, (Function<String, OUT>)((Function<String, Object>)json -> this.codec.fromJson((String)json, responseType)));
    }

    @Override
    public <OUT> Mono<Event<OUT>> putEmpty(HeaderBuilder header, String path, Class<OUT> responseType) {
        return this.parameterisedRequest(Method.PUT, header, path, (Object)null, (Function<String, OUT>)((Function<String, Object>)json -> this.codec.fromJson((String)json, responseType)));
    }

    @Override
    public <OUT> Mono<Event<OUT>> postEmpty(HeaderBuilder header, String path, Class<OUT> responseType) {
        return this.parameterisedRequest(Method.POST, header, path, (Object)null, (Function<String, OUT>)((Function<String, Object>)json -> this.codec.fromJson((String)json, responseType)));
    }

    @Override
    public <IN, OUT> Mono<Event<OUT>> postAsJson(HeaderBuilder header, String path, IN message, Class<OUT> responseType) {
        String json = this.codec.toJson(message);
        RequestBody body = RequestBody.create(json, MEDIA_TYPE);
        return this.post(header, path, responseType, json, body);
    }

    @Override
    public <IN, OUT> Mono<Event<OUT>> postAsForm(HeaderBuilder header, String path, IN message, Class<OUT> responseType) {
        Map<String, ?> map = this.codec.toMap(message);
        String strMessage = JacksonCodec.mapToStringBuilder(map, new StringBuilder()).toString();
        RequestBody body = JsonRestClient.formBody(map);
        return this.post(header, path, responseType, strMessage, body);
    }

    @Override
    public <IN, OUT> Mono<Event<OUT>> postAsParams(HeaderBuilder header, String path, IN message, Class<OUT> responseType) {
        Map<String, ?> map = this.codec.toMap(message);
        StringBuilder strMessage = JacksonCodec.mapToStringBuilder(map, new StringBuilder());
        return this.parameterisedRequest(Method.POST, header, path, (IN)strMessage, (Function<String, OUT>)((Function<String, Object>)json -> this.codec.fromJson((String)json, responseType)));
    }

    @Override
    public <OUT> Mono<Event<OUT>> get(HeaderBuilder header, String path, Class<OUT> responseType) {
        return this.parameterisedRequest(Method.GET, header, path, (Object)null, (Function<String, OUT>)((Function<String, Object>)json -> this.codec.fromJson((String)json, responseType)));
    }

    @Override
    public <IN, OUT> Mono<Event<OUT>> get(HeaderBuilder header, String path, IN message, Class<OUT> responseType) {
        return this.parameterisedRequest(Method.GET, header, path, message, (String json) -> this.codec.fromJson((String)json, responseType));
    }

    @Override
    public <IN, OUT> Mono<Event<List<OUT>>> getMany(HeaderBuilder header, String path, IN message, Class<OUT> responseType) {
        return this.parameterisedRequest(Method.GET, header, path, message, (String json) -> this.codec.fromJsonArray((String)json, responseType));
    }

    @Override
    public <IN, OUT> Mono<Event<OUT>> postAsJson(String path, IN message, Class<OUT> responseType) {
        return this.postAsJson(null, path, message, responseType);
    }

    @Override
    public <IN, OUT> Mono<Event<OUT>> get(String path, IN message, Class<OUT> responseType) {
        return this.get(null, path, message, responseType);
    }

    @Override
    public <OUT> Mono<Event<OUT>> get(String path, Class<OUT> responseType) {
        return this.get(null, path, null, responseType);
    }

    @Override
    public <IN, OUT> Mono<Event<List<OUT>>> getMany(String path, IN message, Class<OUT> responseType) {
        return this.getMany(null, path, message, responseType);
    }

    @Override
    public <OUT> Mono<Event<List<OUT>>> getMany(HeaderBuilder header, String path, Class<OUT> responseType) {
        return this.getMany(header, path, null, responseType);
    }

    @Override
    public <OUT> Mono<Event<List<OUT>>> getMany(String path, Class<OUT> responseType) {
        return this.getMany(null, path, null, responseType);
    }

    @Override
    public Codec<Object> getCodec() {
        return this.codec;
    }

    @Override
    public <OUT, IN> Mono<Event<OUT>> put(HeaderBuilder header, String path, IN message, Class<OUT> responseType) {
        RequestBody body = RequestBody.create(this.codec.toJson(message), MEDIA_TYPE);
        return this.parameterisedRequest(Method.PUT, header, path, body, (String json) -> this.codec.fromJson((String)json, responseType));
    }

    @NonNull
    private <OUT> Mono<Event<OUT>> post(HeaderBuilder header, String path, Class<OUT> responseType, String message, RequestBody body) {
        LOGGER.info("POST: {}{} [{}]", this.urlPrefix, path, message);
        Request.Builder requestBuilder = this.buildRequest(header, path, message);
        return Mono.fromSupplier(() -> requestBuilder.post(body).build()).flatMap(r -> Mono.create(sink2 -> this.client.newCall((Request)r).enqueue(new FnCallback<Object>((MonoSink<Event<Object>>)sink2, new Event(path + "(" + message + ")" + JsonRestClient.headers(r)), res -> this.codec.fromJson((String)res, responseType)))));
    }

    private <OUT> Mono<Event<OUT>> doParameterisedRequest(Method method, Map<String, String> headers2, String path, String queryString, RequestBody body, Function<String, OUT> postProcessor) {
        HttpUrl url = Objects.requireNonNull(HttpUrl.parse(this.urlPrefix + path)).newBuilder().encodedQuery(queryString).build();
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        if (headers2 != null) {
            headers2.forEach(builder::addHeader);
        }
        builder.method(method.name(), body);
        LOGGER.debug("{}: {}", (Object)method, (Object)url);
        return Mono.fromSupplier(builder::build).flatMap(r -> Mono.create(sink2 -> this.client.newCall((Request)r).enqueue(new FnCallback(sink2, new Event(method + ": " + url), postProcessor))));
    }

    @Override
    public <OUT> Mono<Event<OUT>> parameterisedRequest(Method method, Map<String, String> headers2, String path, String queryString, RequestBody payload, Class<OUT> responseType) {
        return this.doParameterisedRequest(method, headers2, path, queryString, payload, json -> this.codec.fromJson((String)json, responseType));
    }

    @Override
    public <OUT> Mono<Event<List<OUT>>> parameterisedRequestMany(Method method, Map<String, String> headers2, String path, String queryString, RequestBody payload, Class<OUT> responseType) {
        return this.doParameterisedRequest(method, headers2, path, queryString, payload, json -> this.codec.fromJsonArray((String)json, responseType));
    }

    private <OUT> Mono<Event<OUT>> parameterisedRequest(Method method, HeaderBuilder header, String path, StringBuilder queryString, Function<String, OUT> fn) {
        String params = queryString == null ? null : queryString.toString();
        String url = queryString == null ? path : queryString.insert(0, "?").insert(0, path).toString();
        LOGGER.debug("{}/{}: {}", this.urlPrefix, method.name(), url);
        return Mono.fromSupplier(() -> JsonRestClient.addMethod(method, this.buildRequest(header, url, params)).build()).flatMap(r -> Mono.create(sink2 -> this.client.newCall((Request)r).enqueue(new FnCallback(sink2, new Event(url), fn))));
    }

    @NonNull
    private <IN, OUT> Mono<Event<OUT>> parameterisedRequest(Method method, HeaderBuilder header, String path, IN message, Function<String, OUT> fn) {
        return this.parameterisedRequest(method, header, path, (IN)this.codec.toQueryString(message), fn);
    }

    private Request.Builder buildRequest(HeaderBuilder header, String path, String message) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.urlPrefix + path);
        if (header != null) {
            return header.addHeaders(builder, message);
        }
        return builder;
    }

    @NonNull
    private static Request.Builder addMethod(Method method, Request.Builder builder) {
        builder = method == Method.GET ? builder.get() : (method == Method.POST ? builder.post(RequestBody.create("", MEDIA_TYPE)) : (method == Method.PUT ? builder.put(RequestBody.create("", MEDIA_TYPE)) : builder.delete(RequestBody.create("", MEDIA_TYPE))));
        return builder;
    }

    @NonNull
    private static RequestBody formBody(Map<String, ?> map) {
        FormBody.Builder builder = new FormBody.Builder();
        for (Map.Entry<String, ?> e : map.entrySet()) {
            builder.add(e.getKey(), e.getValue().toString());
        }
        return builder.build();
    }

    @NonNull
    private static String headers(Request request) {
        StringBuilder b = new StringBuilder("[");
        Headers headers2 = request.headers();
        headers2.names().forEach(n -> b.append((String)n).append("=").append(headers2.values((String)n)).append(","));
        b.append("]");
        return b.toString();
    }

    private static class FnCallback<O>
    implements Callback {
        private final MonoSink<Event<O>> sink;
        private final Event<O> event;
        private final Function<String, O> fn;

        @Override
        public void onFailure(@NotNull Call call, @NotNull IOException e) {
            this.sink.error(e);
        }

        @Override
        public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
            try (Response response2 = response;
                 ResponseBody responseBody = response.body();){
                String json = responseBody.string();
                try {
                    O value = this.fn.apply(json);
                    this.event.response(json, value);
                    this.sink.success(this.event);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to process {} response: {}", this.event.getRequestInfo(), json, e);
                    this.event.response(json, null);
                    this.sink.error(new CxtlEventException(e, this.event));
                }
            }
        }

        public FnCallback(MonoSink<Event<O>> sink2, Event<O> event, Function<String, O> fn) {
            this.sink = sink2;
            this.event = event;
            this.fn = fn;
        }
    }
}

