/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.common.http;

import estonlabs.cxtl.common.http.Event;
import estonlabs.cxtl.common.http.MetricsLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFileMetricsLogger
implements MetricsLogger {
    public static final LogFileMetricsLogger INSTANCE = new LogFileMetricsLogger();
    private static final Logger LOGGER = LoggerFactory.getLogger(LogFileMetricsLogger.class);

    @Override
    public void finishedSuccess(Event<?> event) {
        LogFileMetricsLogger.log(event, "SUCCESS");
    }

    @Override
    public void finishedError(Event<?> event) {
        LogFileMetricsLogger.log(event, "FAIL");
    }

    private static void log(Event<?> event, String info) {
        long now = System.nanoTime();
        LOGGER.info("[{}] OUT=[{}],IN=[{}],TRIP={}, PROCESS={}", info, event.getRequestInfo(), event.getResponseJson(), LogFileMetricsLogger.mics(event.getRequestNanos(), event.getResponseNanos()), LogFileMetricsLogger.mics(event.getResponseNanos(), now));
    }

    private static long mics(long startNano, long endNano) {
        return (endNano - startNano) / 1000L;
    }
}

