/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.common.security;

import estonlabs.cxtl.common.auth.Credentials;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;
import org.bouncycastle.util.encoders.Base64;

public class HmacUtils {
    public static final String ALGORITHM = "HmacSHA256";

    @NonNull
    public static Mac getMac(Credentials credentials) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac hmacSha256 = Mac.getInstance(ALGORITHM);
        SecretKeySpec secretKeySpec = new SecretKeySpec(credentials.getSecretKey().getBytes(StandardCharsets.UTF_8), ALGORITHM);
        hmacSha256.init(secretKeySpec);
        return hmacSha256;
    }

    @NonNull
    public static String sign(Credentials credentials, String sb) {
        byte[] bytes = sb.getBytes(StandardCharsets.UTF_8);
        return HmacUtils.sign(credentials, bytes);
    }

    @NonNull
    public static String sign(Credentials credentials, byte[] bytes) {
        try {
            Mac hmacSha256 = HmacUtils.getMac(credentials);
            byte[] hash = hmacSha256.doFinal(bytes);
            return HmacUtils.bytesToHex(hash);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    public static String bytesToHex(byte[] hash) {
        StringBuilder sb = new StringBuilder();
        for (byte b : hash) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static String bytesToBase64(byte[] hash) {
        return new String(Base64.encode(hash));
    }
}

