/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.common.stream.core;

import com.fasterxml.jackson.databind.JsonMappingException;
import estonlabs.cxtl.common.stream.core.HeaderCreator;
import estonlabs.cxtl.common.stream.core.UnzipDecoder;
import estonlabs.cxtl.common.stream.core.WebsocketConnection;
import estonlabs.cxtl.common.stream.core.WebsocketListener;
import estonlabs.cxtl.common.stream.core.WsSession;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.CloseReason;
import jakarta.websocket.DecodeException;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glassfish.tyrus.client.ClientManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TyrusWebsocketConnection
implements WebsocketConnection<String, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TyrusWebsocketConnection.class);
    private final ClientEndpointConfig cec;
    private final ClientManager client;
    private final URI uri;

    public TyrusWebsocketConnection(URI uri) {
        this(uri, null, null);
    }

    public TyrusWebsocketConnection(URI uri, final HeaderCreator headerCreator, Proxy proxy) {
        this.uri = uri;
        ClientEndpointConfig.Builder builder = ClientEndpointConfig.Builder.create();
        if (headerCreator != null) {
            builder.configurator(new ClientEndpointConfig.Configurator(){

                @Override
                public void beforeRequest(Map<String, List<String>> headers2) {
                    headerCreator.add(headers2);
                }
            });
        }
        this.cec = builder.decoders(List.of(UnzipDecoder.class)).build();
        this.client = ClientManager.createClient();
        if (proxy != null) {
            this.client.getProperties().put("org.glassfish.tyrus.client.proxy", "http:/" + proxy.address());
        }
    }

    @Override
    public WsSession<String> connect(WebsocketListener<String> listener) {
        return new MySession(this.uri, listener);
    }

    private class MySession
    extends Endpoint
    implements WsSession<String> {
        private final AtomicBoolean expectClose = new AtomicBoolean(false);
        private final AtomicBoolean isDisposed = new AtomicBoolean(false);
        private volatile Session session;
        private final WebsocketListener<String> listener;
        private final UnzipDecoder decoder = new UnzipDecoder();
        private final URI uri;

        private MySession(URI uri, WebsocketListener<String> listener) {
            this.uri = uri;
            this.listener = listener;
        }

        @Override
        public void connect() {
            if (this.isDisposed.get()) {
                LOGGER.error("{} Cannot reopen {}, the session is disposed.", (Object)this.listener.id(), (Object)this.uri);
                return;
            }
            if (this.session == null || !this.session.isOpen()) {
                int tries = 3;
                for (int i = 0; i <= tries; ++i) {
                    try {
                        this.connectToSession();
                        return;
                    }
                    catch (Exception e) {
                        if (tries == i) {
                            this.onError(this.session, e);
                            continue;
                        }
                        MySession.sleep();
                        continue;
                    }
                }
            }
        }

        private static void sleep() {
            Thread.sleep(5000L);
        }

        private void connectToSession() throws DeploymentException, IOException {
            LOGGER.info("{} Connecting to {}", (Object)this.listener.id(), (Object)this.uri);
            this.session = TyrusWebsocketConnection.this.client.connectToServer(this, TyrusWebsocketConnection.this.cec, this.uri);
            this.listenForRawText(this.session);
            this.listenForZippedData(this.session);
        }

        @Override
        public void dispose() {
            if (!this.isDisposed.getAndSet(true)) {
                this.close();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.isDisposed.get();
        }

        @Override
        public boolean isOpen() {
            return this.session != null && this.session.isOpen();
        }

        @Override
        public void close() {
            if (this.session != null) {
                try {
                    LOGGER.info("{} Will close session", (Object)this.listener.id());
                    this.expectClose.set(true);
                    this.session.close();
                }
                catch (Exception e) {
                    this.onError(this.session, e);
                }
            }
        }

        @Override
        public void send(String text) {
            try {
                LOGGER.debug("{} Sending: {}", (Object)this.listener.id(), (Object)text);
                this.session.getBasicRemote().sendText(text);
            }
            catch (Exception e) {
                this.onError(this.session, e);
            }
        }

        @Override
        public void onClose(Session session, CloseReason closeReason) {
            if (!this.expectClose.getAndSet(false)) {
                LOGGER.error("{} Session closed: {}", (Object)this.listener.id(), (Object)closeReason.toString());
            } else {
                LOGGER.info("{} Session closed: {}", (Object)this.listener.id(), (Object)closeReason.toString());
            }
            this.listener.processClosed();
        }

        @Override
        public void onError(Session session, Throwable thr) {
            LOGGER.error("{} Error on session: {}", this.listener.id(), session == null ? "NULL SESSION" : session.getBasicRemote(), thr);
            this.listener.processError(thr);
        }

        @Override
        public void onOpen(Session session, EndpointConfig config) {
            LOGGER.info("{} Connected to endpoint: {}", (Object)this.listener.id(), (Object)session.getBasicRemote());
            this.session = session;
            this.listener.processOpened();
        }

        private void listenForZippedData(Session session) {
            session.addMessageHandler(new MessageHandler.Whole<InputStream>(){

                @Override
                public void onMessage(InputStream is) {
                    try {
                        String message = MySession.this.decoder.decode(is);
                        MySession.this.listener.processMessage(message);
                    }
                    catch (DecodeException | IOException e) {
                        LOGGER.error("{} Error decoding payload", (Object)MySession.this.listener.id(), (Object)e);
                    }
                }
            });
        }

        private void listenForRawText(Session session) {
            session.addMessageHandler(new MessageHandler.Whole<String>(){

                @Override
                public void onMessage(String message) {
                    try {
                        MySession.this.listener.processMessage(message);
                    }
                    catch (JsonMappingException e) {
                        LOGGER.warn("error decoding message {}", (Object)message);
                    }
                }
            });
        }
    }
}

