/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.common.stream.managed;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import estonlabs.cxtl.common.stream.managed.InboundMessage;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import net.minidev.json.JSONArray;

public abstract class AbstractInboundDeserializer<T extends InboundMessage>
extends JsonDeserializer<Object> {
    private final List<Target> targets;

    protected AbstractInboundDeserializer(List<Target> targets) {
        this.targets = targets;
    }

    @Override
    public final T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectNode node = (ObjectNode)jp.getCodec().readTree(jp);
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        return this.wrap(mapper.treeToValue((TreeNode)node, this.determineTargetClass(node, mapper)));
    }

    protected abstract T wrap(InboundMessage var1);

    private Class<? extends InboundMessage> determineTargetClass(JsonNode node, ObjectMapper mapper) throws IOException {
        for (Target t : this.targets) {
            if (!t.matches(node, mapper)) continue;
            return t.getType(node, mapper);
        }
        throw new IOException("Type identifier not found");
    }

    protected static interface Target {
        public boolean matches(JsonNode var1, ObjectMapper var2);

        @NonNull
        public Class<? extends InboundMessage> getType(JsonNode var1, ObjectMapper var2) throws IOException;
    }

    protected static final class ContainsTarget
    extends SingleNodeTarget {
        final String id;
        final Map<String, Class<? extends InboundMessage>> mappings;

        @Override
        public Class<? extends InboundMessage> get(String s) {
            for (Map.Entry<String, Class<? extends InboundMessage>> e : this.mappings.entrySet()) {
                if (!s.contains(e.getKey())) continue;
                return e.getValue();
            }
            return null;
        }

        public ContainsTarget(String id, Map<String, Class<? extends InboundMessage>> mappings) {
            this.id = id;
            this.mappings = mappings;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public Map<String, Class<? extends InboundMessage>> getMappings() {
            return this.mappings;
        }
    }

    protected static final class StaticMapping
    extends SingleNodeTarget {
        final String id;
        final Class<? extends InboundMessage> type;

        @Override
        public Class<? extends InboundMessage> get(String s) {
            return this.type;
        }

        public StaticMapping(String id, Class<? extends InboundMessage> type) {
            this.id = id;
            this.type = type;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public Class<? extends InboundMessage> getType() {
            return this.type;
        }
    }

    protected static final class MapTarget
    extends SingleNodeTarget {
        final String id;
        final Map<String, Class<? extends InboundMessage>> mappings;

        @Override
        public Class<? extends InboundMessage> get(String s) {
            return this.mappings.get(s);
        }

        public MapTarget(String id, Map<String, Class<? extends InboundMessage>> mappings) {
            this.id = id;
            this.mappings = mappings;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public Map<String, Class<? extends InboundMessage>> getMappings() {
            return this.mappings;
        }
    }

    protected static class JsonPathTarget
    implements Target {
        final String path;
        final Map<String, Class<? extends InboundMessage>> mappings;

        @Override
        public boolean matches(JsonNode root, ObjectMapper mapper) {
            try {
                String json = mapper.writeValueAsString(root);
                if (this.getPath().startsWith("$")) {
                    JSONArray array = (JSONArray)JsonPath.read(json, this.getPath(), new Predicate[0]);
                    return array.size() == 1;
                }
                return JsonPath.read(json, this.getPath(), new Predicate[0]).toString() != null;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        @NonNull
        public Class<? extends InboundMessage> getType(JsonNode root, ObjectMapper mapper) throws IOException {
            String key = null;
            String json = null;
            try {
                json = mapper.writeValueAsString(root);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            if (this.getPath().startsWith("$")) {
                JSONArray array = (JSONArray)JsonPath.read(json, this.getPath(), new Predicate[0]);
                key = array.get(0).toString();
            } else {
                key = JsonPath.read(json, this.getPath(), new Predicate[0]).toString();
            }
            if (key != null && this.mappings.containsKey(key)) {
                return this.mappings.get(key);
            }
            throw new IOException("Unknown type identifier: " + key);
        }

        public JsonPathTarget(String path, Map<String, Class<? extends InboundMessage>> mappings) {
            this.path = path;
            this.mappings = mappings;
        }

        public String getPath() {
            return this.path;
        }

        public Map<String, Class<? extends InboundMessage>> getMappings() {
            return this.mappings;
        }
    }

    protected static abstract class SingleNodeTarget
    implements Target {
        protected SingleNodeTarget() {
        }

        abstract String getId();

        abstract Class<? extends InboundMessage> get(String var1);

        @Override
        public boolean matches(JsonNode root, ObjectMapper mapper) {
            return root.get(this.getId()) != null;
        }

        @Override
        @NonNull
        public Class<? extends InboundMessage> getType(JsonNode root, ObjectMapper mapper) {
            JsonNode jsonNode = root.get(this.getId());
            String type = jsonNode.asText();
            return this.get(type);
        }
    }
}

