/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.common.stream.managed;

import estonlabs.cxtl.common.stream.core.WebsocketConnection;
import estonlabs.cxtl.common.stream.core.WebsocketListener;
import estonlabs.cxtl.common.stream.core.WsSession;
import estonlabs.cxtl.common.stream.managed.InboundContainer;
import estonlabs.cxtl.common.stream.managed.InboundMessage;
import estonlabs.cxtl.common.stream.managed.OutboundMessage;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFeed<OUT extends OutboundMessage, CONTAINER extends InboundContainer, IN extends InboundMessage>
implements WebsocketListener<CONTAINER> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataFeed.class);
    private final WebsocketConnection<OUT, CONTAINER> websocket;
    private WsSession<OUT> feed;
    private final String id;
    private final OUT request;
    private final Class<IN> type;
    private final Consumer<IN> handler;
    private final Runnable onRestart;

    public DataFeed(WebsocketConnection<OUT, CONTAINER> websocket, String id, OUT request, Class<IN> type, Consumer<IN> handler, Runnable onRestart) {
        this.websocket = websocket;
        this.id = id;
        this.request = request;
        this.type = type;
        this.handler = handler;
        this.onRestart = onRestart;
    }

    public void startFeed() {
        try {
            this.feed = this.websocket.connect(this);
            this.feed.send(this.request);
        }
        catch (Exception e) {
            LOGGER.error(this.id + " Error starting the feed: " + e.getMessage(), e);
        }
    }

    public void closeFeed() {
        this.feed.close();
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void processMessage(InboundContainer message) {
        if (message.getMessageType() == InboundMessage.MessageType.DATA) {
            this.handler.accept(message.getData(this.type));
        }
    }

    @Override
    public void processError(Throwable t) {
        LOGGER.error(this.id + " Error from the feed, will restart and recover.", t);
        this.closeFeed();
        Thread.sleep(1000L);
        this.startFeed();
        this.onRestart.run();
    }
}

