/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.common.stream.managed;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;

public final class PeriodicTimer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeriodicTimer.class);
    public static PeriodicTimer INSTANCE = new PeriodicTimer();
    private final Map<Long, Holder> holders = new ConcurrentHashMap<Long, Holder>();

    private PeriodicTimer() {
    }

    public synchronized Disposable register(long period, Runnable runnable2) {
        Holder holder = this.holders.computeIfAbsent(period, Holder::new);
        holder.runnable.add(runnable2);
        return () -> holder.runnable.remove(runnable2);
    }

    private static class Holder {
        private static final Timer timer = new Timer();
        protected final Set<Runnable> runnable = Collections.newSetFromMap(new ConcurrentHashMap());

        Holder(long period) {
            timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    for (Runnable r : runnable) {
                        try {
                            r.run();
                        }
                        catch (Exception e) {
                            LOGGER.error("Error running timer", e);
                        }
                    }
                }
            }, 0L, period);
        }
    }
}

