/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.common.stream.pojo;

import com.fasterxml.jackson.databind.JsonMappingException;
import estonlabs.cxtl.common.codec.Codec;
import estonlabs.cxtl.common.stream.core.WebsocketListener;
import estonlabs.cxtl.common.stream.core.WsSession;
import jakarta.websocket.DeploymentException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoWsSession<SEND, RECEIVE>
implements WsSession<SEND>,
WebsocketListener<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PojoWsSession.class);
    protected WsSession<String> underlyingSession;
    protected WebsocketListener<RECEIVE> underlyingListener;
    private final Codec<Object> codec;
    private final Class<RECEIVE> inboundType;

    public PojoWsSession(Codec<Object> codec, Class<RECEIVE> inboundType) {
        this.codec = codec;
        this.inboundType = inboundType;
    }

    public void initialize(WsSession<String> underlying, WebsocketListener<RECEIVE> underlyingListener) throws DeploymentException, IOException {
        this.underlyingSession = underlying;
        this.underlyingListener = underlyingListener;
        this.connect();
    }

    @Override
    public String id() {
        return this.underlyingListener.id();
    }

    @Override
    public void processClosed() {
        this.underlyingListener.processClosed();
    }

    @Override
    public void processOpened() {
        this.underlyingListener.processOpened();
    }

    @Override
    public void processError(Throwable t) {
        this.underlyingListener.processError(t);
    }

    @Override
    public void processMessage(String message) throws JsonMappingException {
        try {
            LOGGER.debug("Received: {}", (Object)message);
            RECEIVE received = this.codec.fromJson(message, this.inboundType);
            if (this.processReceived(received)) {
                this.underlyingListener.processMessage(received);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error decoding message: {}", (Object)message, (Object)e);
        }
    }

    @Override
    public void connect() {
        this.underlyingSession.connect();
    }

    @Override
    public boolean isOpen() {
        return this.underlyingSession.isOpen();
    }

    @Override
    public void close() {
        this.underlyingSession.close();
    }

    @Override
    public void send(SEND message) {
        this.processToSend(message);
        this.sendDirectly(message);
    }

    @Override
    public void dispose() {
        this.underlyingSession.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.underlyingSession.isDisposed();
    }

    protected void sendDirectly(SEND message) {
        this.underlyingSession.send(this.codec.toJson(message));
    }

    protected void processToSend(SEND sent) {
    }

    protected boolean processReceived(RECEIVE received) {
        return true;
    }
}

