/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.b2c2.v1.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.common.stream.managed.InboundMessage;
import estonlabs.cxtl.common.stream.managed.MarketDataWithSymbol;
import estonlabs.cxtl.exchanges.b2c2.v1.domain.B2C2InboundContainer;
import java.util.List;

public class B2C2OrderBookSnapshot
implements B2C2InboundContainer,
MarketDataWithSymbol {
    private String event;
    private boolean success;
    private String instrument;
    private Long timestamp;
    private String currency;
    private Levels levels;

    @Override
    public InboundMessage getData() {
        return this;
    }

    @Override
    public InboundMessage.MessageType getMessageType() {
        return InboundMessage.MessageType.DATA;
    }

    @Override
    public boolean isSnapshot() {
        return true;
    }

    @Override
    public String getTopic() {
        return this.instrument;
    }

    @Override
    public Long getSeqNo() {
        return this.timestamp;
    }

    @Override
    public boolean hasData() {
        return this.success;
    }

    @Override
    public String getSymbol() {
        return this.instrument;
    }

    public String getEvent() {
        return this.event;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getInstrument() {
        return this.instrument;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getCurrency() {
        return this.currency;
    }

    public Levels getLevels() {
        return this.levels;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setInstrument(String instrument) {
        this.instrument = instrument;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setLevels(Levels levels) {
        this.levels = levels;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof B2C2OrderBookSnapshot)) {
            return false;
        }
        B2C2OrderBookSnapshot other = (B2C2OrderBookSnapshot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$event = this.getEvent();
        String other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        String this$instrument = this.getInstrument();
        String other$instrument = other.getInstrument();
        if (this$instrument == null ? other$instrument != null : !this$instrument.equals(other$instrument)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        Levels this$levels = this.getLevels();
        Levels other$levels = other.getLevels();
        return !(this$levels == null ? other$levels != null : !((Object)this$levels).equals(other$levels));
    }

    protected boolean canEqual(Object other) {
        return other instanceof B2C2OrderBookSnapshot;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        String $instrument = this.getInstrument();
        result = result * 59 + ($instrument == null ? 43 : $instrument.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        Levels $levels = this.getLevels();
        result = result * 59 + ($levels == null ? 43 : ((Object)$levels).hashCode());
        return result;
    }

    public String toString() {
        return "B2C2OrderBookSnapshot(event=" + this.getEvent() + ", success=" + this.isSuccess() + ", instrument=" + this.getInstrument() + ", timestamp=" + this.getTimestamp() + ", currency=" + this.getCurrency() + ", levels=" + this.getLevels() + ")";
    }

    public static class Levels {
        @JsonProperty(value="buy")
        private List<Order> bids;
        @JsonProperty(value="sell")
        private List<Order> asks;

        public List<Order> getBids() {
            return this.bids;
        }

        public List<Order> getAsks() {
            return this.asks;
        }

        @JsonProperty(value="buy")
        public void setBids(List<Order> bids) {
            this.bids = bids;
        }

        @JsonProperty(value="sell")
        public void setAsks(List<Order> asks) {
            this.asks = asks;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Levels)) {
                return false;
            }
            Levels other = (Levels)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Order> this$bids = this.getBids();
            List<Order> other$bids = other.getBids();
            if (this$bids == null ? other$bids != null : !((Object)this$bids).equals(other$bids)) {
                return false;
            }
            List<Order> this$asks = this.getAsks();
            List<Order> other$asks = other.getAsks();
            return !(this$asks == null ? other$asks != null : !((Object)this$asks).equals(other$asks));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Levels;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Order> $bids = this.getBids();
            result = result * 59 + ($bids == null ? 43 : ((Object)$bids).hashCode());
            List<Order> $asks = this.getAsks();
            result = result * 59 + ($asks == null ? 43 : ((Object)$asks).hashCode());
            return result;
        }

        public String toString() {
            return "B2C2OrderBookSnapshot.Levels(bids=" + this.getBids() + ", asks=" + this.getAsks() + ")";
        }
    }

    public static class Order {
        private double quantity;
        private double price;

        public double getQuantity() {
            return this.quantity;
        }

        public double getPrice() {
            return this.price;
        }

        public void setQuantity(double quantity) {
            this.quantity = quantity;
        }

        public void setPrice(double price) {
            this.price = price;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Order)) {
                return false;
            }
            Order other = (Order)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getQuantity(), other.getQuantity()) != 0) {
                return false;
            }
            return Double.compare(this.getPrice(), other.getPrice()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof Order;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $quantity = Double.doubleToLongBits(this.getQuantity());
            result = result * 59 + (int)($quantity >>> 32 ^ $quantity);
            long $price = Double.doubleToLongBits(this.getPrice());
            result = result * 59 + (int)($price >>> 32 ^ $price);
            return result;
        }

        public String toString() {
            return "B2C2OrderBookSnapshot.Order(quantity=" + this.getQuantity() + ", price=" + this.getPrice() + ")";
        }
    }
}

