/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.b2c2.v1.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import estonlabs.cxtl.common.stream.managed.OutboundMessage;
import java.util.List;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class B2C2OutboundMessage
implements OutboundMessage {
    @JsonIgnore
    @NonNull
    private OutboundMessage.MessageType messageType;
    @NonNull
    private String event;
    @NonNull
    private String instrument;
    private List<Double> levels;
    private String tag;

    private B2C2OutboundMessage(@NonNull OutboundMessage.MessageType messageType) {
        if (messageType == null) {
            throw new NullPointerException("messageType is marked non-null but is null");
        }
        this.messageType = messageType;
        switch (messageType) {
            case SUBSCRIPTION: {
                this.event = "subscribe";
                break;
            }
            case UNSUBSCRIBE: {
                this.event = "unsubscribe";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported messageType: " + messageType);
            }
        }
    }

    public static B2C2OutboundMessage subscribe(String instrument, List<Double> levels) {
        B2C2OutboundMessage message = new B2C2OutboundMessage(OutboundMessage.MessageType.SUBSCRIPTION);
        message.setInstrument(instrument);
        message.setLevels(levels);
        return message;
    }

    public static B2C2OutboundMessage unsubscribe(String instrument) {
        B2C2OutboundMessage message = new B2C2OutboundMessage(OutboundMessage.MessageType.UNSUBSCRIBE);
        message.setInstrument(instrument);
        return message;
    }

    @JsonIgnore
    public void setMessageType(@NonNull OutboundMessage.MessageType messageType) {
        if (messageType == null) {
            throw new NullPointerException("messageType is marked non-null but is null");
        }
        this.messageType = messageType;
    }

    public void setEvent(@NonNull String event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof B2C2OutboundMessage)) {
            return false;
        }
        B2C2OutboundMessage other = (B2C2OutboundMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OutboundMessage.MessageType this$messageType = this.getMessageType();
        OutboundMessage.MessageType other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !((Object)((Object)this$messageType)).equals((Object)other$messageType)) {
            return false;
        }
        String this$event = this.getEvent();
        String other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        String this$instrument = this.getInstrument();
        String other$instrument = other.getInstrument();
        if (this$instrument == null ? other$instrument != null : !this$instrument.equals(other$instrument)) {
            return false;
        }
        List<Double> this$levels = this.getLevels();
        List<Double> other$levels = other.getLevels();
        if (this$levels == null ? other$levels != null : !((Object)this$levels).equals(other$levels)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        return !(this$tag == null ? other$tag != null : !this$tag.equals(other$tag));
    }

    protected boolean canEqual(Object other) {
        return other instanceof B2C2OutboundMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OutboundMessage.MessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : ((Object)((Object)$messageType)).hashCode());
        String $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        String $instrument = this.getInstrument();
        result = result * 59 + ($instrument == null ? 43 : $instrument.hashCode());
        List<Double> $levels = this.getLevels();
        result = result * 59 + ($levels == null ? 43 : ((Object)$levels).hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        return result;
    }

    public String toString() {
        return "B2C2OutboundMessage(super=" + super.toString() + ", messageType=" + this.getMessageType() + ", event=" + this.getEvent() + ", instrument=" + this.getInstrument() + ", levels=" + this.getLevels() + ", tag=" + this.getTag() + ")";
    }

    @Override
    @NonNull
    public OutboundMessage.MessageType getMessageType() {
        return this.messageType;
    }

    @NonNull
    public String getEvent() {
        return this.event;
    }

    @NonNull
    public String getInstrument() {
        return this.instrument;
    }

    public void setInstrument(@NonNull String instrument) {
        if (instrument == null) {
            throw new NullPointerException("instrument is marked non-null but is null");
        }
        this.instrument = instrument;
    }

    public List<Double> getLevels() {
        return this.levels;
    }

    public void setLevels(List<Double> levels) {
        this.levels = levels;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }
}

