/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.b2c2.v1.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.exchanges.a.specification.domain.AssetClass;
import estonlabs.cxtl.exchanges.a.specification.domain.Ticker;
import java.util.Arrays;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Instrument
implements Ticker {
    protected static final String[] NULL_COMPONENTS = new String[]{null, null};
    @JsonProperty(value="name")
    private String symbol;
    @JsonProperty(value="underlier")
    private String underlier;
    @JsonProperty(value="type")
    private AssetClass type;
    @JsonProperty(value="is_tradable")
    private boolean isTradable;
    @JsonProperty(value="quantity_precision")
    private double quantityPrecision;
    @JsonProperty(value="max_quantity_per_trade")
    private double maxQuantityPerTrade;
    @JsonProperty(value="min_quantity_per_trade")
    private double minQuantityPerTrade;
    @JsonProperty(value="price_significant_digits")
    private int priceSignificantDigits;
    private String[] components = null;

    public String[] getComponents() {
        if (this.components == null) {
            String suffix;
            if (this.underlier == null) {
                return NULL_COMPONENTS;
            }
            String string = this.underlier.endsWith("USD") ? "USD" : (suffix = this.underlier.endsWith("UST") ? "UST" : null);
            if (suffix == null) {
                return NULL_COMPONENTS;
            }
            int lastIndex = this.underlier.lastIndexOf(suffix);
            String prefix = this.underlier.substring(0, lastIndex);
            this.components = new String[]{prefix, suffix};
        }
        return this.components;
    }

    @Override
    public String getBaseAsset() {
        return this.getComponents()[0];
    }

    @Override
    public String getQuoteAsset() {
        return this.getComponents()[1];
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public String getUnderlier() {
        return this.underlier;
    }

    public AssetClass getType() {
        return this.type;
    }

    public boolean isTradable() {
        return this.isTradable;
    }

    public double getQuantityPrecision() {
        return this.quantityPrecision;
    }

    public double getMaxQuantityPerTrade() {
        return this.maxQuantityPerTrade;
    }

    public double getMinQuantityPerTrade() {
        return this.minQuantityPerTrade;
    }

    public int getPriceSignificantDigits() {
        return this.priceSignificantDigits;
    }

    @JsonProperty(value="name")
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    @JsonProperty(value="underlier")
    public void setUnderlier(String underlier) {
        this.underlier = underlier;
    }

    @JsonProperty(value="type")
    public void setType(AssetClass type) {
        this.type = type;
    }

    @JsonProperty(value="is_tradable")
    public void setTradable(boolean isTradable) {
        this.isTradable = isTradable;
    }

    @JsonProperty(value="quantity_precision")
    public void setQuantityPrecision(double quantityPrecision) {
        this.quantityPrecision = quantityPrecision;
    }

    @JsonProperty(value="max_quantity_per_trade")
    public void setMaxQuantityPerTrade(double maxQuantityPerTrade) {
        this.maxQuantityPerTrade = maxQuantityPerTrade;
    }

    @JsonProperty(value="min_quantity_per_trade")
    public void setMinQuantityPerTrade(double minQuantityPerTrade) {
        this.minQuantityPerTrade = minQuantityPerTrade;
    }

    @JsonProperty(value="price_significant_digits")
    public void setPriceSignificantDigits(int priceSignificantDigits) {
        this.priceSignificantDigits = priceSignificantDigits;
    }

    public void setComponents(String[] components) {
        this.components = components;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Instrument)) {
            return false;
        }
        Instrument other = (Instrument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isTradable() != other.isTradable()) {
            return false;
        }
        if (Double.compare(this.getQuantityPrecision(), other.getQuantityPrecision()) != 0) {
            return false;
        }
        if (Double.compare(this.getMaxQuantityPerTrade(), other.getMaxQuantityPerTrade()) != 0) {
            return false;
        }
        if (Double.compare(this.getMinQuantityPerTrade(), other.getMinQuantityPerTrade()) != 0) {
            return false;
        }
        if (this.getPriceSignificantDigits() != other.getPriceSignificantDigits()) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
            return false;
        }
        String this$underlier = this.getUnderlier();
        String other$underlier = other.getUnderlier();
        if (this$underlier == null ? other$underlier != null : !this$underlier.equals(other$underlier)) {
            return false;
        }
        AssetClass this$type = this.getType();
        AssetClass other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        return Arrays.deepEquals(this.getComponents(), other.getComponents());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Instrument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTradable() ? 79 : 97);
        long $quantityPrecision = Double.doubleToLongBits(this.getQuantityPrecision());
        result = result * 59 + (int)($quantityPrecision >>> 32 ^ $quantityPrecision);
        long $maxQuantityPerTrade = Double.doubleToLongBits(this.getMaxQuantityPerTrade());
        result = result * 59 + (int)($maxQuantityPerTrade >>> 32 ^ $maxQuantityPerTrade);
        long $minQuantityPerTrade = Double.doubleToLongBits(this.getMinQuantityPerTrade());
        result = result * 59 + (int)($minQuantityPerTrade >>> 32 ^ $minQuantityPerTrade);
        result = result * 59 + this.getPriceSignificantDigits();
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        String $underlier = this.getUnderlier();
        result = result * 59 + ($underlier == null ? 43 : $underlier.hashCode());
        AssetClass $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getComponents());
        return result;
    }

    public String toString() {
        return "Instrument(symbol=" + this.getSymbol() + ", underlier=" + this.getUnderlier() + ", type=" + this.getType() + ", isTradable=" + this.isTradable() + ", quantityPrecision=" + this.getQuantityPrecision() + ", maxQuantityPerTrade=" + this.getMaxQuantityPerTrade() + ", minQuantityPerTrade=" + this.getMinQuantityPerTrade() + ", priceSignificantDigits=" + this.getPriceSignificantDigits() + ", components=" + Arrays.deepToString(this.getComponents()) + ")";
    }
}

