/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.b2c2.v1.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OrderQueryRequest {
    @Pattern(regexp="\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}", message="createdGte must be in the format YYYY-MM-DDTHH:MM:SS")
    @JsonProperty(value="created__gte")
    private @Pattern(regexp="\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}", message="createdGte must be in the format YYYY-MM-DDTHH:MM:SS") String createdGte;
    @Pattern(regexp="\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}", message="createdLt must be in the format YYYY-MM-DDTHH:MM:SS")
    @JsonProperty(value="created__lt")
    private @Pattern(regexp="\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}", message="createdLt must be in the format YYYY-MM-DDTHH:MM:SS") String createdLt;
    @JsonIgnore
    private String clientOrderId;
    @JsonIgnore
    private String orderId;
    private String instrument;
    @Min(value=1L, message="limit must be at least 1")
    @Max(value=1000L, message="limit must be at most 1000")
    private @Min(value=1L, message="limit must be at least 1") @Max(value=1000L, message="limit must be at most 1000") Integer limit;

    private static Integer $default$limit() {
        return 50;
    }

    public static OrderQueryRequestBuilder builder() {
        return new OrderQueryRequestBuilder();
    }

    public String getCreatedGte() {
        return this.createdGte;
    }

    public String getCreatedLt() {
        return this.createdLt;
    }

    public String getClientOrderId() {
        return this.clientOrderId;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getInstrument() {
        return this.instrument;
    }

    public Integer getLimit() {
        return this.limit;
    }

    @JsonProperty(value="created__gte")
    public void setCreatedGte(String createdGte) {
        this.createdGte = createdGte;
    }

    @JsonProperty(value="created__lt")
    public void setCreatedLt(String createdLt) {
        this.createdLt = createdLt;
    }

    @JsonIgnore
    public void setClientOrderId(String clientOrderId) {
        this.clientOrderId = clientOrderId;
    }

    @JsonIgnore
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public void setInstrument(String instrument) {
        this.instrument = instrument;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderQueryRequest)) {
            return false;
        }
        OrderQueryRequest other = (OrderQueryRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$createdGte = this.getCreatedGte();
        String other$createdGte = other.getCreatedGte();
        if (this$createdGte == null ? other$createdGte != null : !this$createdGte.equals(other$createdGte)) {
            return false;
        }
        String this$createdLt = this.getCreatedLt();
        String other$createdLt = other.getCreatedLt();
        if (this$createdLt == null ? other$createdLt != null : !this$createdLt.equals(other$createdLt)) {
            return false;
        }
        String this$clientOrderId = this.getClientOrderId();
        String other$clientOrderId = other.getClientOrderId();
        if (this$clientOrderId == null ? other$clientOrderId != null : !this$clientOrderId.equals(other$clientOrderId)) {
            return false;
        }
        String this$orderId = this.getOrderId();
        String other$orderId = other.getOrderId();
        if (this$orderId == null ? other$orderId != null : !this$orderId.equals(other$orderId)) {
            return false;
        }
        String this$instrument = this.getInstrument();
        String other$instrument = other.getInstrument();
        return !(this$instrument == null ? other$instrument != null : !this$instrument.equals(other$instrument));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderQueryRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $createdGte = this.getCreatedGte();
        result = result * 59 + ($createdGte == null ? 43 : $createdGte.hashCode());
        String $createdLt = this.getCreatedLt();
        result = result * 59 + ($createdLt == null ? 43 : $createdLt.hashCode());
        String $clientOrderId = this.getClientOrderId();
        result = result * 59 + ($clientOrderId == null ? 43 : $clientOrderId.hashCode());
        String $orderId = this.getOrderId();
        result = result * 59 + ($orderId == null ? 43 : $orderId.hashCode());
        String $instrument = this.getInstrument();
        result = result * 59 + ($instrument == null ? 43 : $instrument.hashCode());
        return result;
    }

    public String toString() {
        return "OrderQueryRequest(createdGte=" + this.getCreatedGte() + ", createdLt=" + this.getCreatedLt() + ", clientOrderId=" + this.getClientOrderId() + ", orderId=" + this.getOrderId() + ", instrument=" + this.getInstrument() + ", limit=" + this.getLimit() + ")";
    }

    public OrderQueryRequest() {
        this.limit = OrderQueryRequest.$default$limit();
    }

    public OrderQueryRequest(String createdGte, String createdLt, String clientOrderId, String orderId, String instrument, Integer limit) {
        this.createdGte = createdGte;
        this.createdLt = createdLt;
        this.clientOrderId = clientOrderId;
        this.orderId = orderId;
        this.instrument = instrument;
        this.limit = limit;
    }

    public static class OrderQueryRequestBuilder {
        private String createdGte;
        private String createdLt;
        private String clientOrderId;
        private String orderId;
        private String instrument;
        private boolean limit$set;
        private Integer limit$value;

        OrderQueryRequestBuilder() {
        }

        @JsonProperty(value="created__gte")
        public OrderQueryRequestBuilder createdGte(String createdGte) {
            this.createdGte = createdGte;
            return this;
        }

        @JsonProperty(value="created__lt")
        public OrderQueryRequestBuilder createdLt(String createdLt) {
            this.createdLt = createdLt;
            return this;
        }

        @JsonIgnore
        public OrderQueryRequestBuilder clientOrderId(String clientOrderId) {
            this.clientOrderId = clientOrderId;
            return this;
        }

        @JsonIgnore
        public OrderQueryRequestBuilder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public OrderQueryRequestBuilder instrument(String instrument) {
            this.instrument = instrument;
            return this;
        }

        public OrderQueryRequestBuilder limit(Integer limit) {
            this.limit$value = limit;
            this.limit$set = true;
            return this;
        }

        public OrderQueryRequest build() {
            Integer limit$value = this.limit$value;
            if (!this.limit$set) {
                limit$value = OrderQueryRequest.$default$limit();
            }
            return new OrderQueryRequest(this.createdGte, this.createdLt, this.clientOrderId, this.orderId, this.instrument, limit$value);
        }

        public String toString() {
            return "OrderQueryRequest.OrderQueryRequestBuilder(createdGte=" + this.createdGte + ", createdLt=" + this.createdLt + ", clientOrderId=" + this.clientOrderId + ", orderId=" + this.orderId + ", instrument=" + this.instrument + ", limit$value=" + this.limit$value + ")";
        }
    }
}

