/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.b2c2.v1.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.exchanges.b2c2.v1.domain.OrderType;
import estonlabs.cxtl.exchanges.b2c2.v1.domain.Side;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OrderRequest {
    @JsonProperty(value="client_order_id")
    private String clientOrderId;
    @NotBlank
    @Pattern(regexp="\\d+\\.\\d{1,4}", message="Quantity must be a valid number with up to 4 decimal places")
    private @NotBlank @Pattern(regexp="\\d+\\.\\d{1,4}", message="Quantity must be a valid number with up to 4 decimal places") String quantity;
    @NotBlank
    @Pattern(regexp="buy|sell", message="Side must be either 'buy' or 'sell'")
    private @NotBlank @Pattern(regexp="buy|sell", message="Side must be either 'buy' or 'sell'") String side;
    @NotBlank
    private String instrument;
    @NotBlank
    @JsonProperty(value="order_type")
    @Pattern(regexp="FOK|MKT", message="Order type must be either 'FOK' or 'MKT'")
    private @NotBlank @Pattern(regexp="FOK|MKT", message="Order type must be either 'FOK' or 'MKT'") String orderType;
    private String price;
    @JsonProperty(value="force_open")
    private Boolean forceOpen;
    @NotBlank
    @Pattern(regexp="\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{1,6}Z", message="Valid until must be in the format YYYY-MM-DDTHH:MM:SS.SSSSSSZ")
    @JsonProperty(value="valid_until")
    private @NotBlank @Pattern(regexp="\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{1,6}Z", message="Valid until must be in the format YYYY-MM-DDTHH:MM:SS.SSSSSSZ") String validUntil;
    @Pattern(regexp="([0-9]|1[0-9]|20)\\.\\d{1,2}", message="Acceptable slippage must be a number between 0 and 20 with up to 2 decimal places")
    @JsonProperty(value="acceptable_slippage_in_basis_points")
    private @Pattern(regexp="([0-9]|1[0-9]|20)\\.\\d{1,2}", message="Acceptable slippage must be a number between 0 and 20 with up to 2 decimal places") String acceptableSlippageInBasisPoints;
    @Size(max=50, message="Executing unit must be at most 50 characters long")
    @JsonProperty(value="executing_unit")
    private @Size(max=50, message="Executing unit must be at most 50 characters long") String executingUnit;

    public static Builder builder() {
        return new Builder();
    }

    public String getClientOrderId() {
        return this.clientOrderId;
    }

    public String getQuantity() {
        return this.quantity;
    }

    public String getSide() {
        return this.side;
    }

    public String getInstrument() {
        return this.instrument;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public String getPrice() {
        return this.price;
    }

    public Boolean getForceOpen() {
        return this.forceOpen;
    }

    public String getValidUntil() {
        return this.validUntil;
    }

    public String getAcceptableSlippageInBasisPoints() {
        return this.acceptableSlippageInBasisPoints;
    }

    public String getExecutingUnit() {
        return this.executingUnit;
    }

    @JsonProperty(value="client_order_id")
    public void setClientOrderId(String clientOrderId) {
        this.clientOrderId = clientOrderId;
    }

    public void setQuantity(String quantity) {
        this.quantity = quantity;
    }

    public void setSide(String side) {
        this.side = side;
    }

    public void setInstrument(String instrument) {
        this.instrument = instrument;
    }

    @JsonProperty(value="order_type")
    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    @JsonProperty(value="force_open")
    public void setForceOpen(Boolean forceOpen) {
        this.forceOpen = forceOpen;
    }

    @JsonProperty(value="valid_until")
    public void setValidUntil(String validUntil) {
        this.validUntil = validUntil;
    }

    @JsonProperty(value="acceptable_slippage_in_basis_points")
    public void setAcceptableSlippageInBasisPoints(String acceptableSlippageInBasisPoints) {
        this.acceptableSlippageInBasisPoints = acceptableSlippageInBasisPoints;
    }

    @JsonProperty(value="executing_unit")
    public void setExecutingUnit(String executingUnit) {
        this.executingUnit = executingUnit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderRequest)) {
            return false;
        }
        OrderRequest other = (OrderRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$forceOpen = this.getForceOpen();
        Boolean other$forceOpen = other.getForceOpen();
        if (this$forceOpen == null ? other$forceOpen != null : !((Object)this$forceOpen).equals(other$forceOpen)) {
            return false;
        }
        String this$clientOrderId = this.getClientOrderId();
        String other$clientOrderId = other.getClientOrderId();
        if (this$clientOrderId == null ? other$clientOrderId != null : !this$clientOrderId.equals(other$clientOrderId)) {
            return false;
        }
        String this$quantity = this.getQuantity();
        String other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !this$quantity.equals(other$quantity)) {
            return false;
        }
        String this$side = this.getSide();
        String other$side = other.getSide();
        if (this$side == null ? other$side != null : !this$side.equals(other$side)) {
            return false;
        }
        String this$instrument = this.getInstrument();
        String other$instrument = other.getInstrument();
        if (this$instrument == null ? other$instrument != null : !this$instrument.equals(other$instrument)) {
            return false;
        }
        String this$orderType = this.getOrderType();
        String other$orderType = other.getOrderType();
        if (this$orderType == null ? other$orderType != null : !this$orderType.equals(other$orderType)) {
            return false;
        }
        String this$price = this.getPrice();
        String other$price = other.getPrice();
        if (this$price == null ? other$price != null : !this$price.equals(other$price)) {
            return false;
        }
        String this$validUntil = this.getValidUntil();
        String other$validUntil = other.getValidUntil();
        if (this$validUntil == null ? other$validUntil != null : !this$validUntil.equals(other$validUntil)) {
            return false;
        }
        String this$acceptableSlippageInBasisPoints = this.getAcceptableSlippageInBasisPoints();
        String other$acceptableSlippageInBasisPoints = other.getAcceptableSlippageInBasisPoints();
        if (this$acceptableSlippageInBasisPoints == null ? other$acceptableSlippageInBasisPoints != null : !this$acceptableSlippageInBasisPoints.equals(other$acceptableSlippageInBasisPoints)) {
            return false;
        }
        String this$executingUnit = this.getExecutingUnit();
        String other$executingUnit = other.getExecutingUnit();
        return !(this$executingUnit == null ? other$executingUnit != null : !this$executingUnit.equals(other$executingUnit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $forceOpen = this.getForceOpen();
        result = result * 59 + ($forceOpen == null ? 43 : ((Object)$forceOpen).hashCode());
        String $clientOrderId = this.getClientOrderId();
        result = result * 59 + ($clientOrderId == null ? 43 : $clientOrderId.hashCode());
        String $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : $quantity.hashCode());
        String $side = this.getSide();
        result = result * 59 + ($side == null ? 43 : $side.hashCode());
        String $instrument = this.getInstrument();
        result = result * 59 + ($instrument == null ? 43 : $instrument.hashCode());
        String $orderType = this.getOrderType();
        result = result * 59 + ($orderType == null ? 43 : $orderType.hashCode());
        String $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : $price.hashCode());
        String $validUntil = this.getValidUntil();
        result = result * 59 + ($validUntil == null ? 43 : $validUntil.hashCode());
        String $acceptableSlippageInBasisPoints = this.getAcceptableSlippageInBasisPoints();
        result = result * 59 + ($acceptableSlippageInBasisPoints == null ? 43 : $acceptableSlippageInBasisPoints.hashCode());
        String $executingUnit = this.getExecutingUnit();
        result = result * 59 + ($executingUnit == null ? 43 : $executingUnit.hashCode());
        return result;
    }

    public String toString() {
        return "OrderRequest(clientOrderId=" + this.getClientOrderId() + ", quantity=" + this.getQuantity() + ", side=" + this.getSide() + ", instrument=" + this.getInstrument() + ", orderType=" + this.getOrderType() + ", price=" + this.getPrice() + ", forceOpen=" + this.getForceOpen() + ", validUntil=" + this.getValidUntil() + ", acceptableSlippageInBasisPoints=" + this.getAcceptableSlippageInBasisPoints() + ", executingUnit=" + this.getExecutingUnit() + ")";
    }

    public OrderRequest() {
    }

    public OrderRequest(String clientOrderId, String quantity, String side, String instrument, String orderType, String price, Boolean forceOpen, String validUntil, String acceptableSlippageInBasisPoints, String executingUnit) {
        this.clientOrderId = clientOrderId;
        this.quantity = quantity;
        this.side = side;
        this.instrument = instrument;
        this.orderType = orderType;
        this.price = price;
        this.forceOpen = forceOpen;
        this.validUntil = validUntil;
        this.acceptableSlippageInBasisPoints = acceptableSlippageInBasisPoints;
        this.executingUnit = executingUnit;
    }

    public static class Builder {
        private String clientOrderId;
        private BigDecimal quantity;
        private String side;
        private String instrument;
        private String orderType;
        private BigDecimal price;
        private Boolean forceOpen;
        private ZonedDateTime validUntil;
        private BigDecimal acceptableSlippageInBasisPoints;
        private String executingUnit;

        private Builder() {
        }

        public Builder withClientOrderId(String clientOrderId) {
            this.clientOrderId = clientOrderId;
            return this;
        }

        public Builder withQuantity(BigDecimal quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder withSide(Side side) {
            this.side = side.name().toLowerCase();
            return this;
        }

        public Builder withInstrument(String instrument) {
            this.instrument = instrument;
            return this;
        }

        public Builder withOrderType(OrderType orderType) {
            this.orderType = orderType.name();
            return this;
        }

        public Builder withPrice(BigDecimal price) {
            this.price = price;
            return this;
        }

        public Builder withForceOpen(Boolean forceOpen) {
            this.forceOpen = forceOpen;
            return this;
        }

        public Builder withValidUntil(ZonedDateTime validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public Builder withAcceptableSlippageInBasisPoints(BigDecimal acceptableSlippageInBasisPoints) {
            this.acceptableSlippageInBasisPoints = acceptableSlippageInBasisPoints;
            return this;
        }

        public Builder withExecutingUnit(String executingUnit) {
            this.executingUnit = executingUnit;
            return this;
        }

        public OrderRequest build() {
            OrderRequest orderRequest = new OrderRequest();
            orderRequest.clientOrderId = this.clientOrderId;
            orderRequest.quantity = this.quantity != null ? this.quantity.toPlainString() : null;
            orderRequest.side = this.side;
            orderRequest.instrument = this.instrument;
            orderRequest.orderType = this.orderType;
            orderRequest.price = this.price != null ? this.price.toPlainString() : null;
            orderRequest.forceOpen = this.forceOpen;
            orderRequest.validUntil = this.validUntil != null ? this.validUntil.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ")) : null;
            orderRequest.acceptableSlippageInBasisPoints = this.acceptableSlippageInBasisPoints != null ? this.acceptableSlippageInBasisPoints.toPlainString() : null;
            orderRequest.executingUnit = this.executingUnit;
            return orderRequest;
        }
    }
}

