/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.b2c2.v1.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import estonlabs.cxtl.exchanges.a.specification.domain.Ack;
import estonlabs.cxtl.exchanges.a.specification.domain.AckStatus;
import estonlabs.cxtl.exchanges.a.specification.domain.Order;
import estonlabs.cxtl.exchanges.a.specification.domain.SimpleOrderStatus;
import estonlabs.cxtl.exchanges.b2c2.v1.domain.ErrorResponse;
import estonlabs.cxtl.exchanges.b2c2.v1.domain.OrderType;
import estonlabs.cxtl.exchanges.b2c2.v1.domain.OrderTypeDeserializer;
import estonlabs.cxtl.exchanges.b2c2.v1.domain.Side;
import estonlabs.cxtl.exchanges.b2c2.v1.domain.SideDeserializer;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OrderResponse
extends ErrorResponse
implements Order,
Ack {
    @JsonProperty(value="order_id")
    private String orderId;
    @JsonProperty(value="client_order_id")
    private String clientOrderId;
    private Double quantity;
    @JsonDeserialize(using=SideDeserializer.class)
    private Side side;
    private String instrument;
    @JsonDeserialize(using=OrderTypeDeserializer.class)
    @JsonProperty(value="order_type")
    private OrderType orderType;
    private Double price;
    @JsonProperty(value="executed_price")
    private Double executedPrice;
    @JsonProperty(value="executing_unit")
    private String executingUnit;
    private List<Trade> trades;
    @JsonProperty(value="created")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
    private String created;

    @Override
    public String getSymbol() {
        return this.instrument;
    }

    @Override
    public double getCumQty() {
        if (this.executedPrice != null) {
            return this.quantity;
        }
        return 0.0;
    }

    @Override
    public Double getLastOrAvgPx() {
        return this.executedPrice;
    }

    @Override
    public SimpleOrderStatus getSimpleStatus() {
        if (this.executedPrice != null) {
            return SimpleOrderStatus.CLOSED;
        }
        return SimpleOrderStatus.OPEN;
    }

    @Override
    public String getClOrdId() {
        return this.clientOrderId;
    }

    @Override
    public AckStatus getAckStatus() {
        if (this.executedPrice != null) {
            return AckStatus.SUCCESS;
        }
        return AckStatus.PENDING;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderResponse)) {
            return false;
        }
        OrderResponse other = (OrderResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Double this$quantity = this.getQuantity();
        Double other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        Double this$price = this.getPrice();
        Double other$price = other.getPrice();
        if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
            return false;
        }
        Double this$executedPrice = this.getExecutedPrice();
        Double other$executedPrice = other.getExecutedPrice();
        if (this$executedPrice == null ? other$executedPrice != null : !((Object)this$executedPrice).equals(other$executedPrice)) {
            return false;
        }
        String this$orderId = this.getOrderId();
        String other$orderId = other.getOrderId();
        if (this$orderId == null ? other$orderId != null : !this$orderId.equals(other$orderId)) {
            return false;
        }
        String this$clientOrderId = this.getClientOrderId();
        String other$clientOrderId = other.getClientOrderId();
        if (this$clientOrderId == null ? other$clientOrderId != null : !this$clientOrderId.equals(other$clientOrderId)) {
            return false;
        }
        Side this$side = this.getSide();
        Side other$side = other.getSide();
        if (this$side == null ? other$side != null : !((Object)((Object)this$side)).equals((Object)other$side)) {
            return false;
        }
        String this$instrument = this.getInstrument();
        String other$instrument = other.getInstrument();
        if (this$instrument == null ? other$instrument != null : !this$instrument.equals(other$instrument)) {
            return false;
        }
        OrderType this$orderType = this.getOrderType();
        OrderType other$orderType = other.getOrderType();
        if (this$orderType == null ? other$orderType != null : !((Object)((Object)this$orderType)).equals((Object)other$orderType)) {
            return false;
        }
        String this$executingUnit = this.getExecutingUnit();
        String other$executingUnit = other.getExecutingUnit();
        if (this$executingUnit == null ? other$executingUnit != null : !this$executingUnit.equals(other$executingUnit)) {
            return false;
        }
        List<Trade> this$trades = this.getTrades();
        List<Trade> other$trades = other.getTrades();
        if (this$trades == null ? other$trades != null : !((Object)this$trades).equals(other$trades)) {
            return false;
        }
        String this$created = this.getCreated();
        String other$created = other.getCreated();
        return !(this$created == null ? other$created != null : !this$created.equals(other$created));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OrderResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Double $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        Double $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        Double $executedPrice = this.getExecutedPrice();
        result = result * 59 + ($executedPrice == null ? 43 : ((Object)$executedPrice).hashCode());
        String $orderId = this.getOrderId();
        result = result * 59 + ($orderId == null ? 43 : $orderId.hashCode());
        String $clientOrderId = this.getClientOrderId();
        result = result * 59 + ($clientOrderId == null ? 43 : $clientOrderId.hashCode());
        Side $side = this.getSide();
        result = result * 59 + ($side == null ? 43 : ((Object)((Object)$side)).hashCode());
        String $instrument = this.getInstrument();
        result = result * 59 + ($instrument == null ? 43 : $instrument.hashCode());
        OrderType $orderType = this.getOrderType();
        result = result * 59 + ($orderType == null ? 43 : ((Object)((Object)$orderType)).hashCode());
        String $executingUnit = this.getExecutingUnit();
        result = result * 59 + ($executingUnit == null ? 43 : $executingUnit.hashCode());
        List<Trade> $trades = this.getTrades();
        result = result * 59 + ($trades == null ? 43 : ((Object)$trades).hashCode());
        String $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : $created.hashCode());
        return result;
    }

    @Override
    public String getOrderId() {
        return this.orderId;
    }

    public String getClientOrderId() {
        return this.clientOrderId;
    }

    public Double getQuantity() {
        return this.quantity;
    }

    public Side getSide() {
        return this.side;
    }

    public String getInstrument() {
        return this.instrument;
    }

    public OrderType getOrderType() {
        return this.orderType;
    }

    public Double getPrice() {
        return this.price;
    }

    public Double getExecutedPrice() {
        return this.executedPrice;
    }

    public String getExecutingUnit() {
        return this.executingUnit;
    }

    public List<Trade> getTrades() {
        return this.trades;
    }

    public String getCreated() {
        return this.created;
    }

    @JsonProperty(value="order_id")
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    @JsonProperty(value="client_order_id")
    public void setClientOrderId(String clientOrderId) {
        this.clientOrderId = clientOrderId;
    }

    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    @JsonDeserialize(using=SideDeserializer.class)
    public void setSide(Side side) {
        this.side = side;
    }

    public void setInstrument(String instrument) {
        this.instrument = instrument;
    }

    @JsonDeserialize(using=OrderTypeDeserializer.class)
    @JsonProperty(value="order_type")
    public void setOrderType(OrderType orderType) {
        this.orderType = orderType;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    @JsonProperty(value="executed_price")
    public void setExecutedPrice(Double executedPrice) {
        this.executedPrice = executedPrice;
    }

    @JsonProperty(value="executing_unit")
    public void setExecutingUnit(String executingUnit) {
        this.executingUnit = executingUnit;
    }

    public void setTrades(List<Trade> trades) {
        this.trades = trades;
    }

    @JsonProperty(value="created")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
    public void setCreated(String created) {
        this.created = created;
    }

    @Override
    public String toString() {
        return "OrderResponse(orderId=" + this.getOrderId() + ", clientOrderId=" + this.getClientOrderId() + ", quantity=" + this.getQuantity() + ", side=" + this.getSide() + ", instrument=" + this.getInstrument() + ", orderType=" + this.getOrderType() + ", price=" + this.getPrice() + ", executedPrice=" + this.getExecutedPrice() + ", executingUnit=" + this.getExecutingUnit() + ", trades=" + this.getTrades() + ", created=" + this.getCreated() + ")";
    }

    public OrderResponse() {
    }

    public OrderResponse(String orderId, String clientOrderId, Double quantity, Side side, String instrument, OrderType orderType, Double price, Double executedPrice, String executingUnit, List<Trade> trades, String created) {
        this.orderId = orderId;
        this.clientOrderId = clientOrderId;
        this.quantity = quantity;
        this.side = side;
        this.instrument = instrument;
        this.orderType = orderType;
        this.price = price;
        this.executedPrice = executedPrice;
        this.executingUnit = executingUnit;
        this.trades = trades;
        this.created = created;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Trade {
        @JsonProperty(value="instrument")
        private String instrument;
        @JsonProperty(value="trade_id")
        private String tradeId;
        @JsonProperty(value="origin")
        private String origin;
        @JsonProperty(value="rfq_id")
        private String rfqId;
        @JsonProperty(value="created")
        @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
        private String created;
        @JsonProperty(value="price")
        private String price;
        @JsonProperty(value="quantity")
        private String quantity;
        @JsonProperty(value="order")
        private String order;
        @JsonProperty(value="side")
        private String side;
        @JsonProperty(value="executing_unit")
        private String executingUnit;
        @JsonProperty(value="cfd_contract")
        private String cfdContract;

        public String getInstrument() {
            return this.instrument;
        }

        public String getTradeId() {
            return this.tradeId;
        }

        public String getOrigin() {
            return this.origin;
        }

        public String getRfqId() {
            return this.rfqId;
        }

        public String getCreated() {
            return this.created;
        }

        public String getPrice() {
            return this.price;
        }

        public String getQuantity() {
            return this.quantity;
        }

        public String getOrder() {
            return this.order;
        }

        public String getSide() {
            return this.side;
        }

        public String getExecutingUnit() {
            return this.executingUnit;
        }

        public String getCfdContract() {
            return this.cfdContract;
        }

        @JsonProperty(value="instrument")
        public void setInstrument(String instrument) {
            this.instrument = instrument;
        }

        @JsonProperty(value="trade_id")
        public void setTradeId(String tradeId) {
            this.tradeId = tradeId;
        }

        @JsonProperty(value="origin")
        public void setOrigin(String origin) {
            this.origin = origin;
        }

        @JsonProperty(value="rfq_id")
        public void setRfqId(String rfqId) {
            this.rfqId = rfqId;
        }

        @JsonProperty(value="created")
        @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
        public void setCreated(String created) {
            this.created = created;
        }

        @JsonProperty(value="price")
        public void setPrice(String price) {
            this.price = price;
        }

        @JsonProperty(value="quantity")
        public void setQuantity(String quantity) {
            this.quantity = quantity;
        }

        @JsonProperty(value="order")
        public void setOrder(String order) {
            this.order = order;
        }

        @JsonProperty(value="side")
        public void setSide(String side) {
            this.side = side;
        }

        @JsonProperty(value="executing_unit")
        public void setExecutingUnit(String executingUnit) {
            this.executingUnit = executingUnit;
        }

        @JsonProperty(value="cfd_contract")
        public void setCfdContract(String cfdContract) {
            this.cfdContract = cfdContract;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Trade)) {
                return false;
            }
            Trade other = (Trade)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$instrument = this.getInstrument();
            String other$instrument = other.getInstrument();
            if (this$instrument == null ? other$instrument != null : !this$instrument.equals(other$instrument)) {
                return false;
            }
            String this$tradeId = this.getTradeId();
            String other$tradeId = other.getTradeId();
            if (this$tradeId == null ? other$tradeId != null : !this$tradeId.equals(other$tradeId)) {
                return false;
            }
            String this$origin = this.getOrigin();
            String other$origin = other.getOrigin();
            if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
                return false;
            }
            String this$rfqId = this.getRfqId();
            String other$rfqId = other.getRfqId();
            if (this$rfqId == null ? other$rfqId != null : !this$rfqId.equals(other$rfqId)) {
                return false;
            }
            String this$created = this.getCreated();
            String other$created = other.getCreated();
            if (this$created == null ? other$created != null : !this$created.equals(other$created)) {
                return false;
            }
            String this$price = this.getPrice();
            String other$price = other.getPrice();
            if (this$price == null ? other$price != null : !this$price.equals(other$price)) {
                return false;
            }
            String this$quantity = this.getQuantity();
            String other$quantity = other.getQuantity();
            if (this$quantity == null ? other$quantity != null : !this$quantity.equals(other$quantity)) {
                return false;
            }
            String this$order = this.getOrder();
            String other$order = other.getOrder();
            if (this$order == null ? other$order != null : !this$order.equals(other$order)) {
                return false;
            }
            String this$side = this.getSide();
            String other$side = other.getSide();
            if (this$side == null ? other$side != null : !this$side.equals(other$side)) {
                return false;
            }
            String this$executingUnit = this.getExecutingUnit();
            String other$executingUnit = other.getExecutingUnit();
            if (this$executingUnit == null ? other$executingUnit != null : !this$executingUnit.equals(other$executingUnit)) {
                return false;
            }
            String this$cfdContract = this.getCfdContract();
            String other$cfdContract = other.getCfdContract();
            return !(this$cfdContract == null ? other$cfdContract != null : !this$cfdContract.equals(other$cfdContract));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Trade;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $instrument = this.getInstrument();
            result = result * 59 + ($instrument == null ? 43 : $instrument.hashCode());
            String $tradeId = this.getTradeId();
            result = result * 59 + ($tradeId == null ? 43 : $tradeId.hashCode());
            String $origin = this.getOrigin();
            result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
            String $rfqId = this.getRfqId();
            result = result * 59 + ($rfqId == null ? 43 : $rfqId.hashCode());
            String $created = this.getCreated();
            result = result * 59 + ($created == null ? 43 : $created.hashCode());
            String $price = this.getPrice();
            result = result * 59 + ($price == null ? 43 : $price.hashCode());
            String $quantity = this.getQuantity();
            result = result * 59 + ($quantity == null ? 43 : $quantity.hashCode());
            String $order = this.getOrder();
            result = result * 59 + ($order == null ? 43 : $order.hashCode());
            String $side = this.getSide();
            result = result * 59 + ($side == null ? 43 : $side.hashCode());
            String $executingUnit = this.getExecutingUnit();
            result = result * 59 + ($executingUnit == null ? 43 : $executingUnit.hashCode());
            String $cfdContract = this.getCfdContract();
            result = result * 59 + ($cfdContract == null ? 43 : $cfdContract.hashCode());
            return result;
        }

        public String toString() {
            return "OrderResponse.Trade(instrument=" + this.getInstrument() + ", tradeId=" + this.getTradeId() + ", origin=" + this.getOrigin() + ", rfqId=" + this.getRfqId() + ", created=" + this.getCreated() + ", price=" + this.getPrice() + ", quantity=" + this.getQuantity() + ", order=" + this.getOrder() + ", side=" + this.getSide() + ", executingUnit=" + this.getExecutingUnit() + ", cfdContract=" + this.getCfdContract() + ")";
        }

        public Trade() {
        }

        public Trade(String instrument, String tradeId, String origin, String rfqId, String created, String price, String quantity, String order, String side, String executingUnit, String cfdContract) {
            this.instrument = instrument;
            this.tradeId = tradeId;
            this.origin = origin;
            this.rfqId = rfqId;
            this.created = created;
            this.price = price;
            this.quantity = quantity;
            this.order = order;
            this.side = side;
            this.executingUnit = executingUnit;
            this.cfdContract = cfdContract;
        }
    }
}

