/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.b2c2.v1.lib;

import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.common.exception.CxtlApiException;
import estonlabs.cxtl.common.exception.CxtlEventException;
import estonlabs.cxtl.common.exception.ErrorCode;
import estonlabs.cxtl.common.http.Event;
import estonlabs.cxtl.common.http.HeaderBuilder;
import estonlabs.cxtl.common.http.JsonRestClient;
import estonlabs.cxtl.common.http.MetricsLogger;
import estonlabs.cxtl.exchanges.a.specification.domain.Ack;
import estonlabs.cxtl.exchanges.a.specification.domain.AssetClass;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.a.specification.domain.Olhcv;
import estonlabs.cxtl.exchanges.a.specification.domain.Trade;
import estonlabs.cxtl.exchanges.a.specification.lib.Cex;
import estonlabs.cxtl.exchanges.a.specification.lib.ExchangeDataInterface;
import estonlabs.cxtl.exchanges.b2c2.v1.domain.CancelRequest;
import estonlabs.cxtl.exchanges.b2c2.v1.domain.ErrorResponse;
import estonlabs.cxtl.exchanges.b2c2.v1.domain.Instrument;
import estonlabs.cxtl.exchanges.b2c2.v1.domain.OrderQueryRequest;
import estonlabs.cxtl.exchanges.b2c2.v1.domain.OrderRequest;
import estonlabs.cxtl.exchanges.b2c2.v1.domain.OrderResponse;
import estonlabs.cxtl.exchanges.b2c2.v1.domain.RFQRequest;
import estonlabs.cxtl.exchanges.b2c2.v1.domain.RFQResponse;
import estonlabs.cxtl.exchanges.b2c2.v1.domain.UserAssets;
import java.net.Proxy;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class B2C2Cex
implements Cex<OrderRequest, CancelRequest, OrderQueryRequest>,
ExchangeDataInterface<Instrument, Object> {
    private final JsonRestClient client;
    private final MetricsLogger metricsLogger;

    public B2C2Cex(JsonRestClient restClient, MetricsLogger metricsLogger) {
        this.client = restClient;
        this.metricsLogger = metricsLogger;
    }

    private HeaderBuilder authorized(Credentials credentials) {
        return (builder, message) -> builder.addHeader("Authorization", "Token " + credentials.getApiKey());
    }

    @Override
    public Proxy getProxy() {
        return this.client.getProxy();
    }

    @Override
    public Mono<? extends List<? extends Olhcv>> getOlhcv(Object request) {
        return Mono.empty();
    }

    @Override
    public Mono<? extends List<? extends Trade>> getLatestPublicTrades(AssetClass assetClass, String symbol) {
        return Mono.empty();
    }

    private Mono<Map<AssetClass, List<Instrument>>> getInstrumentsByType(Credentials credentials) {
        return this.handleResponse(this.client.getMany(this.authorized(credentials), "/instruments", Instrument.class)).map(instruments -> instruments.stream().collect(Collectors.groupingBy(Instrument::getType)));
    }

    @Override
    public Mono<? extends Map<AssetClass, List<Instrument>>> getTickers(Credentials credentials) {
        return this.getInstrumentsByType(credentials);
    }

    public Mono<Map<AssetClass, List<Instrument>>> getInstruments(List<Credentials> credentials) {
        Flux<Mono> monos = Flux.fromIterable(credentials).map(this::getInstrumentsByType);
        return Flux.concat(monos).reduce((map1, map2) -> {
            map2.forEach((key, value) -> map1.merge(key, value, (list1, list2) -> {
                list1.addAll(list2);
                return list1;
            }));
            return map1;
        });
    }

    @Override
    public Mono<Map<AssetClass, List<Instrument>>> getTickers() {
        return Mono.error(new IllegalStateException("B2C2 requires credentials to get tickers"));
    }

    @Override
    public Exchange getExchange() {
        return Exchange.B2C2;
    }

    @Override
    public AssetClass[] getSupportedAssetClasses() {
        return new AssetClass[]{AssetClass.SPOT, AssetClass.CFD};
    }

    @Override
    public Mono<OrderResponse> placeOrder(Credentials credentials, OrderRequest order) {
        return this.handleErrorResponse(this.client.postAsJson(this.authorized(credentials), "/order/", order, OrderResponse.class));
    }

    @Override
    public Mono<? extends Ack> cancelOrder(Credentials credentials, CancelRequest request) {
        return Mono.error(new CxtlApiException("B2C2 doesn't support order cancellation", new UnsupportedOperationException()));
    }

    @Override
    public Mono<List<OrderResponse>> getOrders(Credentials credentials, OrderQueryRequest orderQueryRequest) {
        return this.handleResponse(this.client.getMany(this.authorized(credentials), "/order", orderQueryRequest, OrderResponse.class));
    }

    public Mono<UserAssets> getBalances(Credentials credentials) {
        return this.handleResponse(this.client.get(this.authorized(credentials), "/balance", UserAssets.class));
    }

    @Override
    public Mono<OrderResponse> getOrder(Credentials credentials, OrderQueryRequest orderQueryRequest) {
        String path = "/order";
        Mono<List<Object>> result = orderQueryRequest.getOrderId() != null ? this.handleResponse(this.client.getMany(this.authorized(credentials), path + "/" + orderQueryRequest.getOrderId(), OrderResponse.class)) : (orderQueryRequest.getClientOrderId() != null ? this.handleResponse(this.client.getMany(this.authorized(credentials), path + "/" + orderQueryRequest.getClientOrderId(), OrderResponse.class)) : this.handleResponse(this.client.getMany(this.authorized(credentials), path, orderQueryRequest, OrderResponse.class)));
        return result.map(l -> l == null || l.isEmpty() ? null : (OrderResponse)l.get(0));
    }

    public Mono<RFQResponse> rfq(Credentials credentials, RFQRequest rfqRequest) {
        return this.handleErrorResponse(this.client.postAsJson(this.authorized(credentials), "/request_for_quote/", rfqRequest, RFQResponse.class));
    }

    @NonNull
    private <T> Mono<T> onError(Throwable t) {
        if (t instanceof CxtlApiException) {
            CxtlApiException e = (CxtlApiException)t;
            return Mono.error(e);
        }
        if (t instanceof CxtlEventException) {
            CxtlApiException concatMsg;
            CxtlEventException e = (CxtlEventException)t;
            this.metricsLogger.finishedError(e.getEvent());
            ErrorResponse response = this.client.getCodec().quietFromJson(e.getEvent().getResponseJson(), ErrorResponse.class);
            if (response != null && (concatMsg = B2C2Cex.checkForErrors(response)) != null) {
                return Mono.error(concatMsg);
            }
        }
        return Mono.error(new CxtlApiException(t.getMessage(), "UNKNOWN", ErrorCode.UNKNOWN_ERROR));
    }

    @Nullable
    private static CxtlApiException checkForErrors(ErrorResponse response) {
        if (response.getErrors() != null && !response.getErrors().isEmpty()) {
            String concatMsg = response.getErrors().stream().map(e -> e.getMessage() + "(" + e.getField() + ")").collect(Collectors.joining());
            ErrorResponse.Error firstMessage = response.getErrors().get(0);
            return new CxtlApiException(concatMsg, Integer.toString(firstMessage.getCode()), B2C2Cex.errorCode(firstMessage.getCode(), firstMessage.getField()));
        }
        return null;
    }

    private static ErrorCode errorCode(int code, String field) {
        if (code == 1100 && Objects.equals(field, "quantity")) {
            return ErrorCode.INVALID_QTY;
        }
        return switch (code) {
            case 1000, 1100 -> ErrorCode.UNKNOWN_ERROR;
            case 1011, 1012, 1502 -> ErrorCode.INSUFFICIENT_BALANCE;
            case 1006, 1010, 1015, 1019, 1026, 1501 -> ErrorCode.INVALID_QTY;
            case 1005, 1009, 1600 -> ErrorCode.BAD_PX;
            case 1001, 1002, 1003, 1004, 1007, 1022, 1025, 1601 -> ErrorCode.INVALID_SYMBOL;
            case 1021, 1030, 1031 -> ErrorCode.UNKNOWN_ORDER;
            case 1101 -> ErrorCode.INVALID_ARGUMENT;
            default -> ErrorCode.UNKNOWN_ERROR;
        };
    }

    private <T extends ErrorResponse> Mono<T> handleErrorResponse(Mono<Event<T>> response) {
        return response.handle((e, sink2) -> {
            CxtlApiException concatMsg = B2C2Cex.checkForErrors((ErrorResponse)e.getResponse());
            if (concatMsg != null) {
                this.metricsLogger.finishedError((Event<?>)e);
                sink2.error(concatMsg);
                return;
            }
            this.metricsLogger.finishedSuccess((Event<?>)e);
            sink2.next((ErrorResponse)e.getResponse());
        }).onErrorResume(this::onError);
    }

    private <T> Mono<T> handleResponse(Mono<Event<T>> response) {
        return response.map(e -> {
            this.metricsLogger.finishedSuccess((Event<?>)e);
            return e.getResponse();
        }).onErrorResume(this::onError);
    }
}

