/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.b2c2.v1.lib;

import estonlabs.cxtl.common.AbstractExchangeFactory;
import estonlabs.cxtl.common.EnvironmentType;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.b2c2.v1.domain.CancelRequest;
import estonlabs.cxtl.exchanges.b2c2.v1.domain.Instrument;
import estonlabs.cxtl.exchanges.b2c2.v1.domain.OrderQueryRequest;
import estonlabs.cxtl.exchanges.b2c2.v1.domain.OrderRequest;
import estonlabs.cxtl.exchanges.b2c2.v1.lib.B2C2Cex;
import java.net.Proxy;
import java.net.URI;
import java.util.List;
import java.util.Map;

public class B2C2ExchangeFactory
extends AbstractExchangeFactory<OrderRequest, CancelRequest, OrderQueryRequest, Object, Instrument, B2C2Cex, B2C2ExchangeFactory> {
    public static final URI PROD = URI.create("https://api.b2c2.net");
    public static final URI UAT = URI.create("https://api.uat.b2c2.net");
    public static final URI UNIT_TEST = URI.create("http://localhost:8087/b2c2");
    private static final Map<EnvironmentType, List<URI>> ENVIRONMENTS = Map.of(EnvironmentType.PROD, List.of(PROD), EnvironmentType.TEST_NET, List.of(UAT), EnvironmentType.UNIT_TEST, List.of(UNIT_TEST));
    private final URI baseUri;

    public B2C2ExchangeFactory(URI baseUri) {
        super(Exchange.B2C2, ENVIRONMENTS);
        this.baseUri = baseUri;
    }

    @Override
    public B2C2Cex buildCex() {
        return new B2C2Cex(this.createJsonRestClient(this.baseUri), this.metricsLogger);
    }

    @Override
    public B2C2Cex buildCex(Proxy httpProxy) {
        return new B2C2Cex(this.createJsonRestClient(this.baseUri, httpProxy), this.metricsLogger);
    }

    @Override
    protected B2C2ExchangeFactory me() {
        return this;
    }

    @Override
    public B2C2Cex buildEdi() {
        return this.buildCex();
    }

    @Override
    public B2C2Cex buildEdi(Proxy httpProxy) {
        return this.buildCex(httpProxy);
    }
}

