/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.b2c2.v1.lib;

import estonlabs.cxtl.common.AbstractStreamFactory;
import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.common.codec.Codec;
import estonlabs.cxtl.common.codec.JacksonCodec;
import estonlabs.cxtl.common.stream.core.WebsocketConnection;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.b2c2.v1.domain.B2C2InboundContainer;
import estonlabs.cxtl.exchanges.b2c2.v1.domain.B2C2OutboundMessage;
import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public class B2C2StreamFactory
extends AbstractStreamFactory<B2C2OutboundMessage, B2C2InboundContainer, B2C2StreamFactory> {
    public static final URI UAT = URI.create("wss://socket.uat.b2c2.net/quotes");
    public static final URI PROD = URI.create("wss://socket.b2c2.net/quotes");
    private static final Codec<Object> CODEC = new JacksonCodec();
    private final URI baseUri;

    public B2C2StreamFactory(URI baseUri) {
        super(Exchange.B2C2, CODEC, B2C2InboundContainer.class);
        this.baseUri = baseUri;
        this.staleWindow(TimeUnit.SECONDS.toMillis(30L));
    }

    @Override
    protected B2C2StreamFactory me() {
        return this;
    }

    public WebsocketConnection<B2C2OutboundMessage, B2C2InboundContainer> createPrivateStream(@NonNull Credentials credentials) {
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
        return this.newPrivateWebsocket(this.baseUri, headers2 -> headers2.put("Authorization", List.of("Token " + credentials.getApiKey())));
    }
}

