/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.binance.fapi.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import estonlabs.cxtl.exchanges.a.specification.domain.AssetClass;
import estonlabs.cxtl.exchanges.binance.fapi.domain.SignedRequest;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OrderQuery
extends SignedRequest {
    @JsonIgnore
    @NonNull
    private AssetClass assetClass;
    private String symbol;
    private Long orderId;
    private String origClientOrderId;

    OrderQuery(@NonNull AssetClass assetClass, String symbol, Long orderId, String origClientOrderId) {
        if (assetClass == null) {
            throw new NullPointerException("assetClass is marked non-null but is null");
        }
        this.assetClass = assetClass;
        this.symbol = symbol;
        this.orderId = orderId;
        this.origClientOrderId = origClientOrderId;
    }

    public static OrderQueryBuilder builder() {
        return new OrderQueryBuilder();
    }

    @NonNull
    public AssetClass getAssetClass() {
        return this.assetClass;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Long getOrderId() {
        return this.orderId;
    }

    public String getOrigClientOrderId() {
        return this.origClientOrderId;
    }

    @JsonIgnore
    public void setAssetClass(@NonNull AssetClass assetClass) {
        if (assetClass == null) {
            throw new NullPointerException("assetClass is marked non-null but is null");
        }
        this.assetClass = assetClass;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public void setOrigClientOrderId(String origClientOrderId) {
        this.origClientOrderId = origClientOrderId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderQuery)) {
            return false;
        }
        OrderQuery other = (OrderQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$orderId = this.getOrderId();
        Long other$orderId = other.getOrderId();
        if (this$orderId == null ? other$orderId != null : !((Object)this$orderId).equals(other$orderId)) {
            return false;
        }
        AssetClass this$assetClass = this.getAssetClass();
        AssetClass other$assetClass = other.getAssetClass();
        if (this$assetClass == null ? other$assetClass != null : !((Object)((Object)this$assetClass)).equals((Object)other$assetClass)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
            return false;
        }
        String this$origClientOrderId = this.getOrigClientOrderId();
        String other$origClientOrderId = other.getOrigClientOrderId();
        return !(this$origClientOrderId == null ? other$origClientOrderId != null : !this$origClientOrderId.equals(other$origClientOrderId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OrderQuery;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $orderId = this.getOrderId();
        result = result * 59 + ($orderId == null ? 43 : ((Object)$orderId).hashCode());
        AssetClass $assetClass = this.getAssetClass();
        result = result * 59 + ($assetClass == null ? 43 : ((Object)((Object)$assetClass)).hashCode());
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        String $origClientOrderId = this.getOrigClientOrderId();
        result = result * 59 + ($origClientOrderId == null ? 43 : $origClientOrderId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "OrderQuery(assetClass=" + this.getAssetClass() + ", symbol=" + this.getSymbol() + ", orderId=" + this.getOrderId() + ", origClientOrderId=" + this.getOrigClientOrderId() + ")";
    }

    public static class OrderQueryBuilder {
        private AssetClass assetClass;
        private String symbol;
        private Long orderId;
        private String origClientOrderId;

        OrderQueryBuilder() {
        }

        @JsonIgnore
        public OrderQueryBuilder assetClass(@NonNull AssetClass assetClass) {
            if (assetClass == null) {
                throw new NullPointerException("assetClass is marked non-null but is null");
            }
            this.assetClass = assetClass;
            return this;
        }

        public OrderQueryBuilder symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        public OrderQueryBuilder orderId(Long orderId) {
            this.orderId = orderId;
            return this;
        }

        public OrderQueryBuilder origClientOrderId(String origClientOrderId) {
            this.origClientOrderId = origClientOrderId;
            return this;
        }

        public OrderQuery build() {
            return new OrderQuery(this.assetClass, this.symbol, this.orderId, this.origClientOrderId);
        }

        public String toString() {
            return "OrderQuery.OrderQueryBuilder(assetClass=" + this.assetClass + ", symbol=" + this.symbol + ", orderId=" + this.orderId + ", origClientOrderId=" + this.origClientOrderId + ")";
        }
    }
}

