/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.binance.fapi.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import estonlabs.cxtl.exchanges.a.specification.domain.AssetClass;
import estonlabs.cxtl.exchanges.binance.fapi.domain.SignedRequest;
import estonlabs.cxtl.exchanges.binance.fapi.domain.enums.OrderType;
import estonlabs.cxtl.exchanges.binance.fapi.domain.enums.PositionSide;
import estonlabs.cxtl.exchanges.binance.fapi.domain.enums.SelfTradePreventionMode;
import estonlabs.cxtl.exchanges.binance.fapi.domain.enums.Side;
import estonlabs.cxtl.exchanges.binance.fapi.domain.enums.TimeInForce;
import estonlabs.cxtl.exchanges.binance.fapi.domain.enums.WorkingType;
import java.math.BigDecimal;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OrderRequest
extends SignedRequest {
    @JsonIgnore
    @NonNull
    private AssetClass assetClass;
    private String symbol;
    private Side side;
    private PositionSide positionSide;
    private OrderType type;
    private TimeInForce timeInForce;
    private BigDecimal quantity;
    private String reduceOnly;
    private BigDecimal price;
    private String newClientOrderId;
    private BigDecimal stopPrice;
    private String closePosition;
    private BigDecimal activationPrice;
    private BigDecimal callbackRate;
    private WorkingType workingType;
    private String priceProtect;
    private SelfTradePreventionMode selfTradePreventionMode;
    private Long goodTillDate;

    OrderRequest(@NonNull AssetClass assetClass, String symbol, Side side, PositionSide positionSide, OrderType type, TimeInForce timeInForce, BigDecimal quantity, String reduceOnly, BigDecimal price, String newClientOrderId, BigDecimal stopPrice, String closePosition, BigDecimal activationPrice, BigDecimal callbackRate, WorkingType workingType, String priceProtect, SelfTradePreventionMode selfTradePreventionMode, Long goodTillDate) {
        if (assetClass == null) {
            throw new NullPointerException("assetClass is marked non-null but is null");
        }
        this.assetClass = assetClass;
        this.symbol = symbol;
        this.side = side;
        this.positionSide = positionSide;
        this.type = type;
        this.timeInForce = timeInForce;
        this.quantity = quantity;
        this.reduceOnly = reduceOnly;
        this.price = price;
        this.newClientOrderId = newClientOrderId;
        this.stopPrice = stopPrice;
        this.closePosition = closePosition;
        this.activationPrice = activationPrice;
        this.callbackRate = callbackRate;
        this.workingType = workingType;
        this.priceProtect = priceProtect;
        this.selfTradePreventionMode = selfTradePreventionMode;
        this.goodTillDate = goodTillDate;
    }

    public static OrderRequestBuilder builder() {
        return new OrderRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderRequest)) {
            return false;
        }
        OrderRequest other = (OrderRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$goodTillDate = this.getGoodTillDate();
        Long other$goodTillDate = other.getGoodTillDate();
        if (this$goodTillDate == null ? other$goodTillDate != null : !((Object)this$goodTillDate).equals(other$goodTillDate)) {
            return false;
        }
        AssetClass this$assetClass = this.getAssetClass();
        AssetClass other$assetClass = other.getAssetClass();
        if (this$assetClass == null ? other$assetClass != null : !((Object)((Object)this$assetClass)).equals((Object)other$assetClass)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
            return false;
        }
        Side this$side = this.getSide();
        Side other$side = other.getSide();
        if (this$side == null ? other$side != null : !((Object)((Object)this$side)).equals((Object)other$side)) {
            return false;
        }
        PositionSide this$positionSide = this.getPositionSide();
        PositionSide other$positionSide = other.getPositionSide();
        if (this$positionSide == null ? other$positionSide != null : !((Object)((Object)this$positionSide)).equals((Object)other$positionSide)) {
            return false;
        }
        OrderType this$type = this.getType();
        OrderType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        TimeInForce this$timeInForce = this.getTimeInForce();
        TimeInForce other$timeInForce = other.getTimeInForce();
        if (this$timeInForce == null ? other$timeInForce != null : !((Object)((Object)this$timeInForce)).equals((Object)other$timeInForce)) {
            return false;
        }
        BigDecimal this$quantity = this.getQuantity();
        BigDecimal other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        String this$reduceOnly = this.getReduceOnly();
        String other$reduceOnly = other.getReduceOnly();
        if (this$reduceOnly == null ? other$reduceOnly != null : !this$reduceOnly.equals(other$reduceOnly)) {
            return false;
        }
        BigDecimal this$price = this.getPrice();
        BigDecimal other$price = other.getPrice();
        if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
            return false;
        }
        String this$newClientOrderId = this.getNewClientOrderId();
        String other$newClientOrderId = other.getNewClientOrderId();
        if (this$newClientOrderId == null ? other$newClientOrderId != null : !this$newClientOrderId.equals(other$newClientOrderId)) {
            return false;
        }
        BigDecimal this$stopPrice = this.getStopPrice();
        BigDecimal other$stopPrice = other.getStopPrice();
        if (this$stopPrice == null ? other$stopPrice != null : !((Object)this$stopPrice).equals(other$stopPrice)) {
            return false;
        }
        String this$closePosition = this.getClosePosition();
        String other$closePosition = other.getClosePosition();
        if (this$closePosition == null ? other$closePosition != null : !this$closePosition.equals(other$closePosition)) {
            return false;
        }
        BigDecimal this$activationPrice = this.getActivationPrice();
        BigDecimal other$activationPrice = other.getActivationPrice();
        if (this$activationPrice == null ? other$activationPrice != null : !((Object)this$activationPrice).equals(other$activationPrice)) {
            return false;
        }
        BigDecimal this$callbackRate = this.getCallbackRate();
        BigDecimal other$callbackRate = other.getCallbackRate();
        if (this$callbackRate == null ? other$callbackRate != null : !((Object)this$callbackRate).equals(other$callbackRate)) {
            return false;
        }
        WorkingType this$workingType = this.getWorkingType();
        WorkingType other$workingType = other.getWorkingType();
        if (this$workingType == null ? other$workingType != null : !((Object)((Object)this$workingType)).equals((Object)other$workingType)) {
            return false;
        }
        String this$priceProtect = this.getPriceProtect();
        String other$priceProtect = other.getPriceProtect();
        if (this$priceProtect == null ? other$priceProtect != null : !this$priceProtect.equals(other$priceProtect)) {
            return false;
        }
        SelfTradePreventionMode this$selfTradePreventionMode = this.getSelfTradePreventionMode();
        SelfTradePreventionMode other$selfTradePreventionMode = other.getSelfTradePreventionMode();
        return !(this$selfTradePreventionMode == null ? other$selfTradePreventionMode != null : !((Object)((Object)this$selfTradePreventionMode)).equals((Object)other$selfTradePreventionMode));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OrderRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $goodTillDate = this.getGoodTillDate();
        result = result * 59 + ($goodTillDate == null ? 43 : ((Object)$goodTillDate).hashCode());
        AssetClass $assetClass = this.getAssetClass();
        result = result * 59 + ($assetClass == null ? 43 : ((Object)((Object)$assetClass)).hashCode());
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        Side $side = this.getSide();
        result = result * 59 + ($side == null ? 43 : ((Object)((Object)$side)).hashCode());
        PositionSide $positionSide = this.getPositionSide();
        result = result * 59 + ($positionSide == null ? 43 : ((Object)((Object)$positionSide)).hashCode());
        OrderType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        TimeInForce $timeInForce = this.getTimeInForce();
        result = result * 59 + ($timeInForce == null ? 43 : ((Object)((Object)$timeInForce)).hashCode());
        BigDecimal $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        String $reduceOnly = this.getReduceOnly();
        result = result * 59 + ($reduceOnly == null ? 43 : $reduceOnly.hashCode());
        BigDecimal $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        String $newClientOrderId = this.getNewClientOrderId();
        result = result * 59 + ($newClientOrderId == null ? 43 : $newClientOrderId.hashCode());
        BigDecimal $stopPrice = this.getStopPrice();
        result = result * 59 + ($stopPrice == null ? 43 : ((Object)$stopPrice).hashCode());
        String $closePosition = this.getClosePosition();
        result = result * 59 + ($closePosition == null ? 43 : $closePosition.hashCode());
        BigDecimal $activationPrice = this.getActivationPrice();
        result = result * 59 + ($activationPrice == null ? 43 : ((Object)$activationPrice).hashCode());
        BigDecimal $callbackRate = this.getCallbackRate();
        result = result * 59 + ($callbackRate == null ? 43 : ((Object)$callbackRate).hashCode());
        WorkingType $workingType = this.getWorkingType();
        result = result * 59 + ($workingType == null ? 43 : ((Object)((Object)$workingType)).hashCode());
        String $priceProtect = this.getPriceProtect();
        result = result * 59 + ($priceProtect == null ? 43 : $priceProtect.hashCode());
        SelfTradePreventionMode $selfTradePreventionMode = this.getSelfTradePreventionMode();
        result = result * 59 + ($selfTradePreventionMode == null ? 43 : ((Object)((Object)$selfTradePreventionMode)).hashCode());
        return result;
    }

    @NonNull
    public AssetClass getAssetClass() {
        return this.assetClass;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Side getSide() {
        return this.side;
    }

    public PositionSide getPositionSide() {
        return this.positionSide;
    }

    public OrderType getType() {
        return this.type;
    }

    public TimeInForce getTimeInForce() {
        return this.timeInForce;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public String getReduceOnly() {
        return this.reduceOnly;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public String getNewClientOrderId() {
        return this.newClientOrderId;
    }

    public BigDecimal getStopPrice() {
        return this.stopPrice;
    }

    public String getClosePosition() {
        return this.closePosition;
    }

    public BigDecimal getActivationPrice() {
        return this.activationPrice;
    }

    public BigDecimal getCallbackRate() {
        return this.callbackRate;
    }

    public WorkingType getWorkingType() {
        return this.workingType;
    }

    public String getPriceProtect() {
        return this.priceProtect;
    }

    public SelfTradePreventionMode getSelfTradePreventionMode() {
        return this.selfTradePreventionMode;
    }

    public Long getGoodTillDate() {
        return this.goodTillDate;
    }

    @JsonIgnore
    public void setAssetClass(@NonNull AssetClass assetClass) {
        if (assetClass == null) {
            throw new NullPointerException("assetClass is marked non-null but is null");
        }
        this.assetClass = assetClass;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setSide(Side side) {
        this.side = side;
    }

    public void setPositionSide(PositionSide positionSide) {
        this.positionSide = positionSide;
    }

    public void setType(OrderType type) {
        this.type = type;
    }

    public void setTimeInForce(TimeInForce timeInForce) {
        this.timeInForce = timeInForce;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public void setReduceOnly(String reduceOnly) {
        this.reduceOnly = reduceOnly;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public void setNewClientOrderId(String newClientOrderId) {
        this.newClientOrderId = newClientOrderId;
    }

    public void setStopPrice(BigDecimal stopPrice) {
        this.stopPrice = stopPrice;
    }

    public void setClosePosition(String closePosition) {
        this.closePosition = closePosition;
    }

    public void setActivationPrice(BigDecimal activationPrice) {
        this.activationPrice = activationPrice;
    }

    public void setCallbackRate(BigDecimal callbackRate) {
        this.callbackRate = callbackRate;
    }

    public void setWorkingType(WorkingType workingType) {
        this.workingType = workingType;
    }

    public void setPriceProtect(String priceProtect) {
        this.priceProtect = priceProtect;
    }

    public void setSelfTradePreventionMode(SelfTradePreventionMode selfTradePreventionMode) {
        this.selfTradePreventionMode = selfTradePreventionMode;
    }

    public void setGoodTillDate(Long goodTillDate) {
        this.goodTillDate = goodTillDate;
    }

    @Override
    public String toString() {
        return "OrderRequest(assetClass=" + this.getAssetClass() + ", symbol=" + this.getSymbol() + ", side=" + this.getSide() + ", positionSide=" + this.getPositionSide() + ", type=" + this.getType() + ", timeInForce=" + this.getTimeInForce() + ", quantity=" + this.getQuantity() + ", reduceOnly=" + this.getReduceOnly() + ", price=" + this.getPrice() + ", newClientOrderId=" + this.getNewClientOrderId() + ", stopPrice=" + this.getStopPrice() + ", closePosition=" + this.getClosePosition() + ", activationPrice=" + this.getActivationPrice() + ", callbackRate=" + this.getCallbackRate() + ", workingType=" + this.getWorkingType() + ", priceProtect=" + this.getPriceProtect() + ", selfTradePreventionMode=" + this.getSelfTradePreventionMode() + ", goodTillDate=" + this.getGoodTillDate() + ")";
    }

    public static class OrderRequestBuilder {
        private AssetClass assetClass;
        private String symbol;
        private Side side;
        private PositionSide positionSide;
        private OrderType type;
        private TimeInForce timeInForce;
        private BigDecimal quantity;
        private String reduceOnly;
        private BigDecimal price;
        private String newClientOrderId;
        private BigDecimal stopPrice;
        private String closePosition;
        private BigDecimal activationPrice;
        private BigDecimal callbackRate;
        private WorkingType workingType;
        private String priceProtect;
        private SelfTradePreventionMode selfTradePreventionMode;
        private Long goodTillDate;

        OrderRequestBuilder() {
        }

        @JsonIgnore
        public OrderRequestBuilder assetClass(@NonNull AssetClass assetClass) {
            if (assetClass == null) {
                throw new NullPointerException("assetClass is marked non-null but is null");
            }
            this.assetClass = assetClass;
            return this;
        }

        public OrderRequestBuilder symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        public OrderRequestBuilder side(Side side) {
            this.side = side;
            return this;
        }

        public OrderRequestBuilder positionSide(PositionSide positionSide) {
            this.positionSide = positionSide;
            return this;
        }

        public OrderRequestBuilder type(OrderType type) {
            this.type = type;
            return this;
        }

        public OrderRequestBuilder timeInForce(TimeInForce timeInForce) {
            this.timeInForce = timeInForce;
            return this;
        }

        public OrderRequestBuilder quantity(BigDecimal quantity) {
            this.quantity = quantity;
            return this;
        }

        public OrderRequestBuilder reduceOnly(String reduceOnly) {
            this.reduceOnly = reduceOnly;
            return this;
        }

        public OrderRequestBuilder price(BigDecimal price) {
            this.price = price;
            return this;
        }

        public OrderRequestBuilder newClientOrderId(String newClientOrderId) {
            this.newClientOrderId = newClientOrderId;
            return this;
        }

        public OrderRequestBuilder stopPrice(BigDecimal stopPrice) {
            this.stopPrice = stopPrice;
            return this;
        }

        public OrderRequestBuilder closePosition(String closePosition) {
            this.closePosition = closePosition;
            return this;
        }

        public OrderRequestBuilder activationPrice(BigDecimal activationPrice) {
            this.activationPrice = activationPrice;
            return this;
        }

        public OrderRequestBuilder callbackRate(BigDecimal callbackRate) {
            this.callbackRate = callbackRate;
            return this;
        }

        public OrderRequestBuilder workingType(WorkingType workingType) {
            this.workingType = workingType;
            return this;
        }

        public OrderRequestBuilder priceProtect(String priceProtect) {
            this.priceProtect = priceProtect;
            return this;
        }

        public OrderRequestBuilder selfTradePreventionMode(SelfTradePreventionMode selfTradePreventionMode) {
            this.selfTradePreventionMode = selfTradePreventionMode;
            return this;
        }

        public OrderRequestBuilder goodTillDate(Long goodTillDate) {
            this.goodTillDate = goodTillDate;
            return this;
        }

        public OrderRequest build() {
            return new OrderRequest(this.assetClass, this.symbol, this.side, this.positionSide, this.type, this.timeInForce, this.quantity, this.reduceOnly, this.price, this.newClientOrderId, this.stopPrice, this.closePosition, this.activationPrice, this.callbackRate, this.workingType, this.priceProtect, this.selfTradePreventionMode, this.goodTillDate);
        }

        public String toString() {
            return "OrderRequest.OrderRequestBuilder(assetClass=" + this.assetClass + ", symbol=" + this.symbol + ", side=" + this.side + ", positionSide=" + this.positionSide + ", type=" + this.type + ", timeInForce=" + this.timeInForce + ", quantity=" + this.quantity + ", reduceOnly=" + this.reduceOnly + ", price=" + this.price + ", newClientOrderId=" + this.newClientOrderId + ", stopPrice=" + this.stopPrice + ", closePosition=" + this.closePosition + ", activationPrice=" + this.activationPrice + ", callbackRate=" + this.callbackRate + ", workingType=" + this.workingType + ", priceProtect=" + this.priceProtect + ", selfTradePreventionMode=" + this.selfTradePreventionMode + ", goodTillDate=" + this.goodTillDate + ")";
        }
    }
}

