/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.binance.fapi.domain.stream;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import estonlabs.cxtl.common.stream.managed.OutboundMessage;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class BinanceOutboundMessage
implements OutboundMessage {
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger(0);
    @JsonIgnore
    @NonNull
    protected OutboundMessage.MessageType messageType;
    private int id;
    private String method;
    private List<Object> params;

    public BinanceOutboundMessage(@NonNull OutboundMessage.MessageType messageType) {
        if (messageType == null) {
            throw new NullPointerException("messageType is marked non-null but is null");
        }
        this.messageType = messageType;
        if (messageType == OutboundMessage.MessageType.SUBSCRIPTION) {
            this.method = "SUBSCRIBE";
        } else if (messageType == OutboundMessage.MessageType.UNSUBSCRIBE) {
            this.method = "UNSUBSCRIBE";
        }
        this.id = ID_GENERATOR.getAndIncrement();
    }

    public static BinanceOutboundMessage subscribe(String topic) {
        return BinanceOutboundMessage.request(OutboundMessage.MessageType.SUBSCRIPTION, List.of(topic));
    }

    public static BinanceOutboundMessage subscribe(Object ... topics) {
        return BinanceOutboundMessage.request(OutboundMessage.MessageType.SUBSCRIPTION, Arrays.stream(topics).toList());
    }

    public static BinanceOutboundMessage unsubscribe(String topic) {
        return BinanceOutboundMessage.request(OutboundMessage.MessageType.UNSUBSCRIBE, List.of(topic));
    }

    public static BinanceOutboundMessage request(OutboundMessage.MessageType type, String ... topics) {
        BinanceOutboundMessage request = new BinanceOutboundMessage(type);
        request.setParams(List.of(topics));
        return request;
    }

    public static BinanceOutboundMessage request(OutboundMessage.MessageType type, List<Object> topics) {
        BinanceOutboundMessage request = new BinanceOutboundMessage(type);
        request.setParams(topics);
        return request;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BinanceOutboundMessage)) {
            return false;
        }
        BinanceOutboundMessage other = (BinanceOutboundMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        OutboundMessage.MessageType this$messageType = this.getMessageType();
        OutboundMessage.MessageType other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !((Object)((Object)this$messageType)).equals((Object)other$messageType)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        List<Object> this$params = this.getParams();
        List<Object> other$params = other.getParams();
        return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BinanceOutboundMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        OutboundMessage.MessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : ((Object)((Object)$messageType)).hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        List<Object> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        return result;
    }

    @Override
    @NonNull
    public OutboundMessage.MessageType getMessageType() {
        return this.messageType;
    }

    public int getId() {
        return this.id;
    }

    public String getMethod() {
        return this.method;
    }

    public List<Object> getParams() {
        return this.params;
    }

    @JsonIgnore
    public void setMessageType(@NonNull OutboundMessage.MessageType messageType) {
        if (messageType == null) {
            throw new NullPointerException("messageType is marked non-null but is null");
        }
        this.messageType = messageType;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setParams(List<Object> params) {
        this.params = params;
    }

    public String toString() {
        return "BinanceOutboundMessage(super=" + super.toString() + ", messageType=" + this.getMessageType() + ", id=" + this.getId() + ", method=" + this.getMethod() + ", params=" + this.getParams() + ")";
    }
}

