/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.binance.fapi.domain.stream;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.common.stream.managed.AbstractInboundMessage;
import estonlabs.cxtl.common.stream.managed.InboundMessage;
import estonlabs.cxtl.common.stream.managed.MarketData;
import estonlabs.cxtl.exchanges.binance.fapi.domain.stream.BinanceInboundContainer;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class BookTickerStreamData
extends AbstractInboundMessage
implements BinanceInboundContainer,
MarketData {
    @JsonProperty(value="e")
    private String eventType;
    @JsonProperty(value="E")
    private Long timestamp;
    @JsonProperty(value="s")
    private String symbol;
    @JsonProperty(value="u")
    private Long seqNo;
    @JsonProperty(value="T")
    private Long transactionTime;
    @JsonProperty(value="b")
    private Double bid;
    @JsonProperty(value="B")
    private Double bidQty;
    @JsonProperty(value="a")
    private Double ask;
    @JsonProperty(value="A")
    private Double askQty;
    private boolean snapshot = true;

    public BookTickerStreamData() {
        this.messageType = InboundMessage.MessageType.DATA;
    }

    @Override
    @JsonIgnore
    public InboundMessage getData() {
        return this;
    }

    @Override
    public String getTopic() {
        return String.format("%s@bookTicker", this.symbol);
    }

    @Override
    public boolean hasData() {
        return this.symbol != null;
    }

    public String getEventType() {
        return this.eventType;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public Long getSeqNo() {
        return this.seqNo;
    }

    public Long getTransactionTime() {
        return this.transactionTime;
    }

    public Double getBid() {
        return this.bid;
    }

    public Double getBidQty() {
        return this.bidQty;
    }

    public Double getAsk() {
        return this.ask;
    }

    public Double getAskQty() {
        return this.askQty;
    }

    @Override
    public boolean isSnapshot() {
        return this.snapshot;
    }

    @JsonProperty(value="e")
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @JsonProperty(value="E")
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @JsonProperty(value="s")
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    @JsonProperty(value="u")
    public void setSeqNo(Long seqNo) {
        this.seqNo = seqNo;
    }

    @JsonProperty(value="T")
    public void setTransactionTime(Long transactionTime) {
        this.transactionTime = transactionTime;
    }

    @JsonProperty(value="b")
    public void setBid(Double bid) {
        this.bid = bid;
    }

    @JsonProperty(value="B")
    public void setBidQty(Double bidQty) {
        this.bidQty = bidQty;
    }

    @JsonProperty(value="a")
    public void setAsk(Double ask) {
        this.ask = ask;
    }

    @JsonProperty(value="A")
    public void setAskQty(Double askQty) {
        this.askQty = askQty;
    }

    public void setSnapshot(boolean snapshot) {
        this.snapshot = snapshot;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BookTickerStreamData)) {
            return false;
        }
        BookTickerStreamData other = (BookTickerStreamData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isSnapshot() != other.isSnapshot()) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Long this$seqNo = this.getSeqNo();
        Long other$seqNo = other.getSeqNo();
        if (this$seqNo == null ? other$seqNo != null : !((Object)this$seqNo).equals(other$seqNo)) {
            return false;
        }
        Long this$transactionTime = this.getTransactionTime();
        Long other$transactionTime = other.getTransactionTime();
        if (this$transactionTime == null ? other$transactionTime != null : !((Object)this$transactionTime).equals(other$transactionTime)) {
            return false;
        }
        Double this$bid = this.getBid();
        Double other$bid = other.getBid();
        if (this$bid == null ? other$bid != null : !((Object)this$bid).equals(other$bid)) {
            return false;
        }
        Double this$bidQty = this.getBidQty();
        Double other$bidQty = other.getBidQty();
        if (this$bidQty == null ? other$bidQty != null : !((Object)this$bidQty).equals(other$bidQty)) {
            return false;
        }
        Double this$ask = this.getAsk();
        Double other$ask = other.getAsk();
        if (this$ask == null ? other$ask != null : !((Object)this$ask).equals(other$ask)) {
            return false;
        }
        Double this$askQty = this.getAskQty();
        Double other$askQty = other.getAskQty();
        if (this$askQty == null ? other$askQty != null : !((Object)this$askQty).equals(other$askQty)) {
            return false;
        }
        String this$eventType = this.getEventType();
        String other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        return !(this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BookTickerStreamData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isSnapshot() ? 79 : 97);
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Long $seqNo = this.getSeqNo();
        result = result * 59 + ($seqNo == null ? 43 : ((Object)$seqNo).hashCode());
        Long $transactionTime = this.getTransactionTime();
        result = result * 59 + ($transactionTime == null ? 43 : ((Object)$transactionTime).hashCode());
        Double $bid = this.getBid();
        result = result * 59 + ($bid == null ? 43 : ((Object)$bid).hashCode());
        Double $bidQty = this.getBidQty();
        result = result * 59 + ($bidQty == null ? 43 : ((Object)$bidQty).hashCode());
        Double $ask = this.getAsk();
        result = result * 59 + ($ask == null ? 43 : ((Object)$ask).hashCode());
        Double $askQty = this.getAskQty();
        result = result * 59 + ($askQty == null ? 43 : ((Object)$askQty).hashCode());
        String $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "BookTickerStreamData(super=" + super.toString() + ", eventType=" + this.getEventType() + ", timestamp=" + this.getTimestamp() + ", symbol=" + this.getSymbol() + ", seqNo=" + this.getSeqNo() + ", transactionTime=" + this.getTransactionTime() + ", bid=" + this.getBid() + ", bidQty=" + this.getBidQty() + ", ask=" + this.getAsk() + ", askQty=" + this.getAskQty() + ", snapshot=" + this.isSnapshot() + ")";
    }
}

