/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.binance.fapi.domain.stream;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.common.stream.managed.AbstractInboundMessage;
import estonlabs.cxtl.common.stream.managed.InboundMessage;
import estonlabs.cxtl.common.stream.managed.MarketData;
import estonlabs.cxtl.exchanges.binance.fapi.domain.stream.BinanceInboundContainer;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OrderBookStreamData
extends AbstractInboundMessage
implements BinanceInboundContainer,
MarketData {
    @JsonProperty(value="b")
    private List<Double[]> bids;
    @JsonProperty(value="a")
    private List<Double[]> asks;
    @JsonProperty(value="e")
    private String eventType;
    @JsonProperty(value="E")
    private Long timestamp;
    @JsonProperty(value="s")
    private String symbol;
    @JsonProperty(value="U")
    private Long lastUpdateId;
    @JsonProperty(value="u")
    private Long seqNo;
    @JsonProperty(value="T")
    private Long transactionTime;
    @JsonProperty(value="pu")
    private Long previousUpdateId;
    private boolean snapshot = false;

    public OrderBookStreamData() {
        this.messageType = InboundMessage.MessageType.DATA;
    }

    @Override
    @JsonIgnore
    public InboundMessage getData() {
        return this;
    }

    @Override
    public String getTopic() {
        return String.format("%s@depth", this.symbol);
    }

    @Override
    public boolean hasData() {
        return this.bids != null || this.asks != null;
    }

    public List<Double[]> getBids() {
        return this.bids;
    }

    public List<Double[]> getAsks() {
        return this.asks;
    }

    public String getEventType() {
        return this.eventType;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Long getLastUpdateId() {
        return this.lastUpdateId;
    }

    @Override
    public Long getSeqNo() {
        return this.seqNo;
    }

    public Long getTransactionTime() {
        return this.transactionTime;
    }

    public Long getPreviousUpdateId() {
        return this.previousUpdateId;
    }

    @Override
    public boolean isSnapshot() {
        return this.snapshot;
    }

    @JsonProperty(value="b")
    public void setBids(List<Double[]> bids) {
        this.bids = bids;
    }

    @JsonProperty(value="a")
    public void setAsks(List<Double[]> asks) {
        this.asks = asks;
    }

    @JsonProperty(value="e")
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @JsonProperty(value="E")
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @JsonProperty(value="s")
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    @JsonProperty(value="U")
    public void setLastUpdateId(Long lastUpdateId) {
        this.lastUpdateId = lastUpdateId;
    }

    @JsonProperty(value="u")
    public void setSeqNo(Long seqNo) {
        this.seqNo = seqNo;
    }

    @JsonProperty(value="T")
    public void setTransactionTime(Long transactionTime) {
        this.transactionTime = transactionTime;
    }

    @JsonProperty(value="pu")
    public void setPreviousUpdateId(Long previousUpdateId) {
        this.previousUpdateId = previousUpdateId;
    }

    public void setSnapshot(boolean snapshot) {
        this.snapshot = snapshot;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderBookStreamData)) {
            return false;
        }
        OrderBookStreamData other = (OrderBookStreamData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isSnapshot() != other.isSnapshot()) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Long this$lastUpdateId = this.getLastUpdateId();
        Long other$lastUpdateId = other.getLastUpdateId();
        if (this$lastUpdateId == null ? other$lastUpdateId != null : !((Object)this$lastUpdateId).equals(other$lastUpdateId)) {
            return false;
        }
        Long this$seqNo = this.getSeqNo();
        Long other$seqNo = other.getSeqNo();
        if (this$seqNo == null ? other$seqNo != null : !((Object)this$seqNo).equals(other$seqNo)) {
            return false;
        }
        Long this$transactionTime = this.getTransactionTime();
        Long other$transactionTime = other.getTransactionTime();
        if (this$transactionTime == null ? other$transactionTime != null : !((Object)this$transactionTime).equals(other$transactionTime)) {
            return false;
        }
        Long this$previousUpdateId = this.getPreviousUpdateId();
        Long other$previousUpdateId = other.getPreviousUpdateId();
        if (this$previousUpdateId == null ? other$previousUpdateId != null : !((Object)this$previousUpdateId).equals(other$previousUpdateId)) {
            return false;
        }
        List<Double[]> this$bids = this.getBids();
        List<Double[]> other$bids = other.getBids();
        if (this$bids == null ? other$bids != null : !((Object)this$bids).equals(other$bids)) {
            return false;
        }
        List<Double[]> this$asks = this.getAsks();
        List<Double[]> other$asks = other.getAsks();
        if (this$asks == null ? other$asks != null : !((Object)this$asks).equals(other$asks)) {
            return false;
        }
        String this$eventType = this.getEventType();
        String other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        return !(this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OrderBookStreamData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isSnapshot() ? 79 : 97);
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Long $lastUpdateId = this.getLastUpdateId();
        result = result * 59 + ($lastUpdateId == null ? 43 : ((Object)$lastUpdateId).hashCode());
        Long $seqNo = this.getSeqNo();
        result = result * 59 + ($seqNo == null ? 43 : ((Object)$seqNo).hashCode());
        Long $transactionTime = this.getTransactionTime();
        result = result * 59 + ($transactionTime == null ? 43 : ((Object)$transactionTime).hashCode());
        Long $previousUpdateId = this.getPreviousUpdateId();
        result = result * 59 + ($previousUpdateId == null ? 43 : ((Object)$previousUpdateId).hashCode());
        List<Double[]> $bids = this.getBids();
        result = result * 59 + ($bids == null ? 43 : ((Object)$bids).hashCode());
        List<Double[]> $asks = this.getAsks();
        result = result * 59 + ($asks == null ? 43 : ((Object)$asks).hashCode());
        String $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "OrderBookStreamData(super=" + super.toString() + ", bids=" + this.getBids() + ", asks=" + this.getAsks() + ", eventType=" + this.getEventType() + ", timestamp=" + this.getTimestamp() + ", symbol=" + this.getSymbol() + ", lastUpdateId=" + this.getLastUpdateId() + ", seqNo=" + this.getSeqNo() + ", transactionTime=" + this.getTransactionTime() + ", previousUpdateId=" + this.getPreviousUpdateId() + ", snapshot=" + this.isSnapshot() + ")";
    }
}

