/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.binance.fapi.domain.stream;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.common.stream.managed.AbstractInboundMessage;
import estonlabs.cxtl.common.stream.managed.InboundMessage;
import estonlabs.cxtl.common.stream.managed.MarketData;
import estonlabs.cxtl.exchanges.binance.fapi.domain.stream.BinanceInboundContainer;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class TickerStreamData
extends AbstractInboundMessage
implements BinanceInboundContainer,
MarketData {
    @JsonProperty(value="b")
    private Double bidPrice;
    @JsonProperty(value="B")
    private Double bidQty;
    @JsonProperty(value="a")
    private Double askPrice;
    @JsonProperty(value="A")
    private Double askQty;
    @JsonProperty(value="u")
    private Long seqNo;
    @JsonProperty(value="s")
    private String symbol;
    private boolean snapshot = true;

    public TickerStreamData() {
        this.messageType = InboundMessage.MessageType.DATA;
    }

    @Override
    @JsonIgnore
    public InboundMessage getData() {
        return this;
    }

    @Override
    public String getTopic() {
        return String.format("%s@bookTicker", this.symbol);
    }

    @Override
    public Long getTimestamp() {
        return null;
    }

    @Override
    public boolean hasData() {
        return this.symbol != null;
    }

    public Double getBidPrice() {
        return this.bidPrice;
    }

    public Double getBidQty() {
        return this.bidQty;
    }

    public Double getAskPrice() {
        return this.askPrice;
    }

    public Double getAskQty() {
        return this.askQty;
    }

    @Override
    public Long getSeqNo() {
        return this.seqNo;
    }

    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public boolean isSnapshot() {
        return this.snapshot;
    }

    @JsonProperty(value="b")
    public void setBidPrice(Double bidPrice) {
        this.bidPrice = bidPrice;
    }

    @JsonProperty(value="B")
    public void setBidQty(Double bidQty) {
        this.bidQty = bidQty;
    }

    @JsonProperty(value="a")
    public void setAskPrice(Double askPrice) {
        this.askPrice = askPrice;
    }

    @JsonProperty(value="A")
    public void setAskQty(Double askQty) {
        this.askQty = askQty;
    }

    @JsonProperty(value="u")
    public void setSeqNo(Long seqNo) {
        this.seqNo = seqNo;
    }

    @JsonProperty(value="s")
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setSnapshot(boolean snapshot) {
        this.snapshot = snapshot;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TickerStreamData)) {
            return false;
        }
        TickerStreamData other = (TickerStreamData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isSnapshot() != other.isSnapshot()) {
            return false;
        }
        Double this$bidPrice = this.getBidPrice();
        Double other$bidPrice = other.getBidPrice();
        if (this$bidPrice == null ? other$bidPrice != null : !((Object)this$bidPrice).equals(other$bidPrice)) {
            return false;
        }
        Double this$bidQty = this.getBidQty();
        Double other$bidQty = other.getBidQty();
        if (this$bidQty == null ? other$bidQty != null : !((Object)this$bidQty).equals(other$bidQty)) {
            return false;
        }
        Double this$askPrice = this.getAskPrice();
        Double other$askPrice = other.getAskPrice();
        if (this$askPrice == null ? other$askPrice != null : !((Object)this$askPrice).equals(other$askPrice)) {
            return false;
        }
        Double this$askQty = this.getAskQty();
        Double other$askQty = other.getAskQty();
        if (this$askQty == null ? other$askQty != null : !((Object)this$askQty).equals(other$askQty)) {
            return false;
        }
        Long this$seqNo = this.getSeqNo();
        Long other$seqNo = other.getSeqNo();
        if (this$seqNo == null ? other$seqNo != null : !((Object)this$seqNo).equals(other$seqNo)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        return !(this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TickerStreamData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isSnapshot() ? 79 : 97);
        Double $bidPrice = this.getBidPrice();
        result = result * 59 + ($bidPrice == null ? 43 : ((Object)$bidPrice).hashCode());
        Double $bidQty = this.getBidQty();
        result = result * 59 + ($bidQty == null ? 43 : ((Object)$bidQty).hashCode());
        Double $askPrice = this.getAskPrice();
        result = result * 59 + ($askPrice == null ? 43 : ((Object)$askPrice).hashCode());
        Double $askQty = this.getAskQty();
        result = result * 59 + ($askQty == null ? 43 : ((Object)$askQty).hashCode());
        Long $seqNo = this.getSeqNo();
        result = result * 59 + ($seqNo == null ? 43 : ((Object)$seqNo).hashCode());
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "TickerStreamData(super=" + super.toString() + ", bidPrice=" + this.getBidPrice() + ", bidQty=" + this.getBidQty() + ", askPrice=" + this.getAskPrice() + ", askQty=" + this.getAskQty() + ", seqNo=" + this.getSeqNo() + ", symbol=" + this.getSymbol() + ", snapshot=" + this.isSnapshot() + ")";
    }
}

