/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.binance.general.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.exchanges.a.specification.domain.Ack;
import estonlabs.cxtl.exchanges.a.specification.domain.AckStatus;
import estonlabs.cxtl.exchanges.a.specification.domain.AssetClass;
import estonlabs.cxtl.exchanges.a.specification.domain.SimpleOrderStatus;
import estonlabs.cxtl.exchanges.binance.fapi.domain.Response;
import estonlabs.cxtl.exchanges.binance.fapi.domain.enums.OrderStatus;
import estonlabs.cxtl.exchanges.binance.fapi.domain.enums.OrderType;
import estonlabs.cxtl.exchanges.binance.fapi.domain.enums.PositionSide;
import estonlabs.cxtl.exchanges.binance.fapi.domain.enums.SelfTradePreventionMode;
import estonlabs.cxtl.exchanges.binance.fapi.domain.enums.Side;
import estonlabs.cxtl.exchanges.binance.fapi.domain.enums.TimeInForce;
import estonlabs.cxtl.exchanges.binance.fapi.domain.enums.WorkingType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class Order
extends Response
implements estonlabs.cxtl.exchanges.a.specification.domain.Order,
Ack {
    @JsonProperty(value="clientOrderId")
    private String clOrdId;
    @JsonProperty(value="executedQty")
    private double cumQty;
    private String cumQuote;
    private String orderId;
    private Double avgPrice;
    private Double origQty;
    private String price;
    private boolean reduceOnly;
    private Side side;
    private PositionSide positionSide;
    private OrderStatus status;
    private String stopPrice;
    private boolean closePosition;
    private String symbol;
    private TimeInForce timeInForce;
    private OrderType type;
    private OrderType origType;
    private String activatePrice;
    private String priceRate;
    private Long updateTime;
    private WorkingType workingType;
    private boolean priceProtect;
    private SelfTradePreventionMode selfTradePreventionMode;
    private Long goodTillDate;

    public abstract AssetClass getAssetClass();

    @Override
    public Double getLastOrAvgPx() {
        return this.avgPrice;
    }

    @Override
    public SimpleOrderStatus getSimpleStatus() {
        return this.status.getSimpleOrderStatus();
    }

    @Override
    public AckStatus getAckStatus() {
        return this.status == OrderStatus.REJECTED ? AckStatus.FAIL : AckStatus.SUCCESS;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Order)) {
            return false;
        }
        Order other = (Order)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (Double.compare(this.getCumQty(), other.getCumQty()) != 0) {
            return false;
        }
        if (this.isReduceOnly() != other.isReduceOnly()) {
            return false;
        }
        if (this.isClosePosition() != other.isClosePosition()) {
            return false;
        }
        if (this.isPriceProtect() != other.isPriceProtect()) {
            return false;
        }
        Double this$avgPrice = this.getAvgPrice();
        Double other$avgPrice = other.getAvgPrice();
        if (this$avgPrice == null ? other$avgPrice != null : !((Object)this$avgPrice).equals(other$avgPrice)) {
            return false;
        }
        Double this$origQty = this.getOrigQty();
        Double other$origQty = other.getOrigQty();
        if (this$origQty == null ? other$origQty != null : !((Object)this$origQty).equals(other$origQty)) {
            return false;
        }
        Long this$updateTime = this.getUpdateTime();
        Long other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        Long this$goodTillDate = this.getGoodTillDate();
        Long other$goodTillDate = other.getGoodTillDate();
        if (this$goodTillDate == null ? other$goodTillDate != null : !((Object)this$goodTillDate).equals(other$goodTillDate)) {
            return false;
        }
        String this$clOrdId = this.getClOrdId();
        String other$clOrdId = other.getClOrdId();
        if (this$clOrdId == null ? other$clOrdId != null : !this$clOrdId.equals(other$clOrdId)) {
            return false;
        }
        String this$cumQuote = this.getCumQuote();
        String other$cumQuote = other.getCumQuote();
        if (this$cumQuote == null ? other$cumQuote != null : !this$cumQuote.equals(other$cumQuote)) {
            return false;
        }
        String this$orderId = this.getOrderId();
        String other$orderId = other.getOrderId();
        if (this$orderId == null ? other$orderId != null : !this$orderId.equals(other$orderId)) {
            return false;
        }
        String this$price = this.getPrice();
        String other$price = other.getPrice();
        if (this$price == null ? other$price != null : !this$price.equals(other$price)) {
            return false;
        }
        Side this$side = this.getSide();
        Side other$side = other.getSide();
        if (this$side == null ? other$side != null : !((Object)((Object)this$side)).equals((Object)other$side)) {
            return false;
        }
        PositionSide this$positionSide = this.getPositionSide();
        PositionSide other$positionSide = other.getPositionSide();
        if (this$positionSide == null ? other$positionSide != null : !((Object)((Object)this$positionSide)).equals((Object)other$positionSide)) {
            return false;
        }
        OrderStatus this$status = this.getStatus();
        OrderStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$stopPrice = this.getStopPrice();
        String other$stopPrice = other.getStopPrice();
        if (this$stopPrice == null ? other$stopPrice != null : !this$stopPrice.equals(other$stopPrice)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
            return false;
        }
        TimeInForce this$timeInForce = this.getTimeInForce();
        TimeInForce other$timeInForce = other.getTimeInForce();
        if (this$timeInForce == null ? other$timeInForce != null : !((Object)((Object)this$timeInForce)).equals((Object)other$timeInForce)) {
            return false;
        }
        OrderType this$type = this.getType();
        OrderType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        OrderType this$origType = this.getOrigType();
        OrderType other$origType = other.getOrigType();
        if (this$origType == null ? other$origType != null : !((Object)((Object)this$origType)).equals((Object)other$origType)) {
            return false;
        }
        String this$activatePrice = this.getActivatePrice();
        String other$activatePrice = other.getActivatePrice();
        if (this$activatePrice == null ? other$activatePrice != null : !this$activatePrice.equals(other$activatePrice)) {
            return false;
        }
        String this$priceRate = this.getPriceRate();
        String other$priceRate = other.getPriceRate();
        if (this$priceRate == null ? other$priceRate != null : !this$priceRate.equals(other$priceRate)) {
            return false;
        }
        WorkingType this$workingType = this.getWorkingType();
        WorkingType other$workingType = other.getWorkingType();
        if (this$workingType == null ? other$workingType != null : !((Object)((Object)this$workingType)).equals((Object)other$workingType)) {
            return false;
        }
        SelfTradePreventionMode this$selfTradePreventionMode = this.getSelfTradePreventionMode();
        SelfTradePreventionMode other$selfTradePreventionMode = other.getSelfTradePreventionMode();
        return !(this$selfTradePreventionMode == null ? other$selfTradePreventionMode != null : !((Object)((Object)this$selfTradePreventionMode)).equals((Object)other$selfTradePreventionMode));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Order;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $cumQty = Double.doubleToLongBits(this.getCumQty());
        result = result * 59 + (int)($cumQty >>> 32 ^ $cumQty);
        result = result * 59 + (this.isReduceOnly() ? 79 : 97);
        result = result * 59 + (this.isClosePosition() ? 79 : 97);
        result = result * 59 + (this.isPriceProtect() ? 79 : 97);
        Double $avgPrice = this.getAvgPrice();
        result = result * 59 + ($avgPrice == null ? 43 : ((Object)$avgPrice).hashCode());
        Double $origQty = this.getOrigQty();
        result = result * 59 + ($origQty == null ? 43 : ((Object)$origQty).hashCode());
        Long $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        Long $goodTillDate = this.getGoodTillDate();
        result = result * 59 + ($goodTillDate == null ? 43 : ((Object)$goodTillDate).hashCode());
        String $clOrdId = this.getClOrdId();
        result = result * 59 + ($clOrdId == null ? 43 : $clOrdId.hashCode());
        String $cumQuote = this.getCumQuote();
        result = result * 59 + ($cumQuote == null ? 43 : $cumQuote.hashCode());
        String $orderId = this.getOrderId();
        result = result * 59 + ($orderId == null ? 43 : $orderId.hashCode());
        String $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : $price.hashCode());
        Side $side = this.getSide();
        result = result * 59 + ($side == null ? 43 : ((Object)((Object)$side)).hashCode());
        PositionSide $positionSide = this.getPositionSide();
        result = result * 59 + ($positionSide == null ? 43 : ((Object)((Object)$positionSide)).hashCode());
        OrderStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $stopPrice = this.getStopPrice();
        result = result * 59 + ($stopPrice == null ? 43 : $stopPrice.hashCode());
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        TimeInForce $timeInForce = this.getTimeInForce();
        result = result * 59 + ($timeInForce == null ? 43 : ((Object)((Object)$timeInForce)).hashCode());
        OrderType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        OrderType $origType = this.getOrigType();
        result = result * 59 + ($origType == null ? 43 : ((Object)((Object)$origType)).hashCode());
        String $activatePrice = this.getActivatePrice();
        result = result * 59 + ($activatePrice == null ? 43 : $activatePrice.hashCode());
        String $priceRate = this.getPriceRate();
        result = result * 59 + ($priceRate == null ? 43 : $priceRate.hashCode());
        WorkingType $workingType = this.getWorkingType();
        result = result * 59 + ($workingType == null ? 43 : ((Object)((Object)$workingType)).hashCode());
        SelfTradePreventionMode $selfTradePreventionMode = this.getSelfTradePreventionMode();
        result = result * 59 + ($selfTradePreventionMode == null ? 43 : ((Object)((Object)$selfTradePreventionMode)).hashCode());
        return result;
    }

    @Override
    public String getClOrdId() {
        return this.clOrdId;
    }

    @Override
    public double getCumQty() {
        return this.cumQty;
    }

    public String getCumQuote() {
        return this.cumQuote;
    }

    @Override
    public String getOrderId() {
        return this.orderId;
    }

    public Double getAvgPrice() {
        return this.avgPrice;
    }

    public Double getOrigQty() {
        return this.origQty;
    }

    public String getPrice() {
        return this.price;
    }

    public boolean isReduceOnly() {
        return this.reduceOnly;
    }

    public Side getSide() {
        return this.side;
    }

    public PositionSide getPositionSide() {
        return this.positionSide;
    }

    public OrderStatus getStatus() {
        return this.status;
    }

    public String getStopPrice() {
        return this.stopPrice;
    }

    public boolean isClosePosition() {
        return this.closePosition;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public TimeInForce getTimeInForce() {
        return this.timeInForce;
    }

    public OrderType getType() {
        return this.type;
    }

    public OrderType getOrigType() {
        return this.origType;
    }

    public String getActivatePrice() {
        return this.activatePrice;
    }

    public String getPriceRate() {
        return this.priceRate;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public WorkingType getWorkingType() {
        return this.workingType;
    }

    public boolean isPriceProtect() {
        return this.priceProtect;
    }

    public SelfTradePreventionMode getSelfTradePreventionMode() {
        return this.selfTradePreventionMode;
    }

    public Long getGoodTillDate() {
        return this.goodTillDate;
    }

    @JsonProperty(value="clientOrderId")
    public void setClOrdId(String clOrdId) {
        this.clOrdId = clOrdId;
    }

    @JsonProperty(value="executedQty")
    public void setCumQty(double cumQty) {
        this.cumQty = cumQty;
    }

    public void setCumQuote(String cumQuote) {
        this.cumQuote = cumQuote;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public void setAvgPrice(Double avgPrice) {
        this.avgPrice = avgPrice;
    }

    public void setOrigQty(Double origQty) {
        this.origQty = origQty;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public void setReduceOnly(boolean reduceOnly) {
        this.reduceOnly = reduceOnly;
    }

    public void setSide(Side side) {
        this.side = side;
    }

    public void setPositionSide(PositionSide positionSide) {
        this.positionSide = positionSide;
    }

    public void setStatus(OrderStatus status) {
        this.status = status;
    }

    public void setStopPrice(String stopPrice) {
        this.stopPrice = stopPrice;
    }

    public void setClosePosition(boolean closePosition) {
        this.closePosition = closePosition;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setTimeInForce(TimeInForce timeInForce) {
        this.timeInForce = timeInForce;
    }

    public void setType(OrderType type) {
        this.type = type;
    }

    public void setOrigType(OrderType origType) {
        this.origType = origType;
    }

    public void setActivatePrice(String activatePrice) {
        this.activatePrice = activatePrice;
    }

    public void setPriceRate(String priceRate) {
        this.priceRate = priceRate;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    public void setWorkingType(WorkingType workingType) {
        this.workingType = workingType;
    }

    public void setPriceProtect(boolean priceProtect) {
        this.priceProtect = priceProtect;
    }

    public void setSelfTradePreventionMode(SelfTradePreventionMode selfTradePreventionMode) {
        this.selfTradePreventionMode = selfTradePreventionMode;
    }

    public void setGoodTillDate(Long goodTillDate) {
        this.goodTillDate = goodTillDate;
    }

    @Override
    public String toString() {
        return "Order(clOrdId=" + this.getClOrdId() + ", cumQty=" + this.getCumQty() + ", cumQuote=" + this.getCumQuote() + ", orderId=" + this.getOrderId() + ", avgPrice=" + this.getAvgPrice() + ", origQty=" + this.getOrigQty() + ", price=" + this.getPrice() + ", reduceOnly=" + this.isReduceOnly() + ", side=" + this.getSide() + ", positionSide=" + this.getPositionSide() + ", status=" + this.getStatus() + ", stopPrice=" + this.getStopPrice() + ", closePosition=" + this.isClosePosition() + ", symbol=" + this.getSymbol() + ", timeInForce=" + this.getTimeInForce() + ", type=" + this.getType() + ", origType=" + this.getOrigType() + ", activatePrice=" + this.getActivatePrice() + ", priceRate=" + this.getPriceRate() + ", updateTime=" + this.getUpdateTime() + ", workingType=" + this.getWorkingType() + ", priceProtect=" + this.isPriceProtect() + ", selfTradePreventionMode=" + this.getSelfTradePreventionMode() + ", goodTillDate=" + this.getGoodTillDate() + ")";
    }
}

