/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.binance.lib;

import estonlabs.cxtl.common.util.HexUtil;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class BinanceAuthenticator {
    private static final String HMAC_SHA256 = "HmacSHA256";

    public static String getSignature(String data, String key) {
        byte[] hmacSha256;
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(), HMAC_SHA256);
            Mac mac = Mac.getInstance(HMAC_SHA256);
            mac.init(secretKeySpec);
            hmacSha256 = mac.doFinal(data.getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to calculate hmac-sha256", e);
        }
        return HexUtil.bytesToHex(hmacSha256);
    }
}

