/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.binance.lib;

import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.exchanges.a.specification.domain.Ack;
import estonlabs.cxtl.exchanges.a.specification.domain.AssetClass;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.a.specification.domain.Olhcv;
import estonlabs.cxtl.exchanges.a.specification.domain.Trade;
import estonlabs.cxtl.exchanges.a.specification.lib.Cex;
import estonlabs.cxtl.exchanges.a.specification.lib.ExchangeDataInterface;
import estonlabs.cxtl.exchanges.binance.fapi.domain.ExchangeInfo;
import estonlabs.cxtl.exchanges.binance.fapi.domain.ListenKey;
import estonlabs.cxtl.exchanges.binance.fapi.domain.OrderQuery;
import estonlabs.cxtl.exchanges.binance.fapi.domain.OrderRequest;
import estonlabs.cxtl.exchanges.binance.general.domain.Order;
import estonlabs.cxtl.exchanges.binance.lib.BinanceFuturesRestClient;
import java.net.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import reactor.core.publisher.Mono;

public class BinanceCex
implements Cex<OrderRequest, OrderQuery, OrderQuery>,
ExchangeDataInterface<ExchangeInfo.Symbol, Object> {
    protected static final String PERPETUAL = "PERPETUAL";
    protected static final String PENDING = "PENDING_TRADING";
    private final BinanceFuturesRestClient fapi;
    private final BinanceFuturesRestClient dapi;
    private Map<String, BinanceFuturesRestClient> mappings;

    public BinanceCex(BinanceFuturesRestClient fapi, BinanceFuturesRestClient dapi) {
        this.fapi = fapi;
        this.dapi = dapi;
    }

    @Override
    public Proxy getProxy() {
        return this.fapi.getProxy();
    }

    @Override
    public Mono<? extends List<? extends Trade>> getLatestPublicTrades(AssetClass assetClass, String symbol) {
        return switch (assetClass) {
            case AssetClass.PERP -> this.fapi.getLatestPublicTrades(symbol);
            case AssetClass.PERP_INVERSE, AssetClass.FUTURE -> this.dapi.getLatestPublicTrades(symbol);
            default -> throw new UnsupportedOperationException("Asset class not supported: " + assetClass);
        };
    }

    @Override
    public Mono<? extends List<? extends Olhcv>> getOlhcv(Object request) {
        return Mono.empty();
    }

    private BinanceFuturesRestClient getClient(String ticker) {
        if (this.mappings == null) {
            this.mappings = new ConcurrentHashMap<String, BinanceFuturesRestClient>();
            this.addMappings(this.fapi, this.mappings);
            this.addMappings(this.dapi, this.mappings);
        }
        return this.mappings.get(ticker);
    }

    private void addMappings(BinanceFuturesRestClient client, Map<String, BinanceFuturesRestClient> mappings) {
        List<ExchangeInfo.Symbol> tickers = client.getTickers().block();
        if (tickers == null) {
            return;
        }
        for (ExchangeInfo.Symbol symbol : tickers) {
            mappings.put(symbol.getSymbol(), client);
        }
    }

    private BinanceFuturesRestClient getClient(String ticker, AssetClass assetClass) {
        BinanceFuturesRestClient client;
        if (ticker != null && (client = this.getClient(ticker)) != null) {
            return client;
        }
        return switch (assetClass) {
            case AssetClass.PERP -> this.fapi;
            case AssetClass.PERP_INVERSE, AssetClass.FUTURE -> this.dapi;
            default -> throw new UnsupportedOperationException("Asset class not supported: " + assetClass);
        };
    }

    @Override
    public Mono<? extends Map<AssetClass, List<ExchangeInfo.Symbol>>> getTickers() {
        Mono<List<ExchangeInfo.Symbol>> fapiTickers = this.fapi.getTickers();
        Mono<Map> fapiPerp = fapiTickers.map(tickers -> Map.of(AssetClass.PERP, tickers.stream().filter(r -> BinanceCex.include(r, true)).toList()));
        Mono<Map> fapiFutures = fapiTickers.map(tickers -> Map.of(AssetClass.FUTURE, tickers.stream().filter(r -> BinanceCex.include(r, false)).toList()));
        Mono<List<ExchangeInfo.Symbol>> dapiTickers = this.dapi.getTickers();
        Mono<Map> dapiPerp = dapiTickers.map(tickers -> Map.of(AssetClass.PERP_INVERSE, tickers.stream().filter(r -> BinanceCex.include(r, true)).toList()));
        Mono<Map> dapiFutures = dapiTickers.map(tickers -> Map.of(AssetClass.FUTURE, tickers.stream().filter(r -> BinanceCex.include(r, false)).toList()));
        return Mono.zip(fapiPerp, dapiPerp, fapiFutures, dapiFutures).map(tuple -> {
            HashMap combinedMap = new HashMap();
            combinedMap.putAll((Map)tuple.getT1());
            combinedMap.putAll((Map)tuple.getT2());
            combinedMap.putAll((Map)tuple.getT3());
            combinedMap.putAll((Map)tuple.getT4());
            return combinedMap;
        });
    }

    private static boolean include(ExchangeInfo.Symbol r, boolean perp) {
        if (r == null) {
            return false;
        }
        String contractType = r.getContractType();
        String status = r.getStatus();
        if (contractType == null || status != null && status.contains(PENDING)) {
            return false;
        }
        return perp == contractType.contains(PERPETUAL);
    }

    @Override
    public Exchange getExchange() {
        return Exchange.BINANCE;
    }

    @Override
    public AssetClass[] getSupportedAssetClasses() {
        return new AssetClass[]{AssetClass.PERP, AssetClass.PERP_INVERSE, AssetClass.FUTURE};
    }

    @Override
    public Mono<? extends Order> placeOrder(Credentials credentials, OrderRequest order) {
        return this.getClient(order.getSymbol(), order.getAssetClass()).placeOrder(credentials, order);
    }

    @Override
    public Mono<? extends Ack> cancelOrder(Credentials credentials, OrderQuery request) {
        return this.getClient(request.getSymbol(), request.getAssetClass()).cancelOrder(credentials, request);
    }

    @Override
    public Mono<? extends List<? extends Order>> getOrders(Credentials credentials, OrderQuery orderQuery) {
        return this.getClient(orderQuery.getSymbol(), orderQuery.getAssetClass()).getOrders(credentials, orderQuery);
    }

    @Override
    public Mono<? extends Order> getOrder(Credentials credentials, OrderQuery orderQuery) {
        return this.getClient(orderQuery.getSymbol(), orderQuery.getAssetClass()).getOrder(credentials, orderQuery);
    }

    public Mono<ListenKey> createListenKey(Credentials credentials, AssetClass assetClass) {
        return switch (assetClass) {
            case AssetClass.PERP -> this.fapi.createListenKey(credentials);
            case AssetClass.PERP_INVERSE, AssetClass.FUTURE -> this.dapi.createListenKey(credentials);
            default -> throw new UnsupportedOperationException("Asset class not supported: " + assetClass);
        };
    }

    public Mono<ListenKey> refreshListenKey(Credentials credentials, AssetClass assetClass) {
        return switch (assetClass) {
            case AssetClass.PERP -> this.fapi.refreshListenKey(credentials);
            case AssetClass.PERP_INVERSE, AssetClass.FUTURE -> this.dapi.refreshListenKey(credentials);
            default -> throw new UnsupportedOperationException("Asset class not supported: " + assetClass);
        };
    }
}

