/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.binance.lib;

import estonlabs.cxtl.common.AbstractExchangeFactory;
import estonlabs.cxtl.common.EnvironmentType;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.binance.fapi.domain.ExchangeInfo;
import estonlabs.cxtl.exchanges.binance.fapi.domain.OrderQuery;
import estonlabs.cxtl.exchanges.binance.fapi.domain.OrderRequest;
import estonlabs.cxtl.exchanges.binance.lib.BinanceCex;
import estonlabs.cxtl.exchanges.binance.lib.BinanceFuturesRestClient;
import java.net.Proxy;
import java.net.URI;
import java.util.List;
import java.util.Map;

public class BinanceExchangeFactory
extends AbstractExchangeFactory<OrderRequest, OrderQuery, OrderQuery, Object, ExchangeInfo.Symbol, BinanceCex, BinanceExchangeFactory> {
    public static final URI PROD_FAPI = URI.create("https://fapi.binance.com");
    public static final URI PROD_DAPI = URI.create("https://dapi.binance.com");
    public static final URI TEST_NET = URI.create("https://testnet.binancefuture.com");
    public static final URI TEST_NET_SPOT = URI.create("https://testnet.binance.vision/api");
    private static final Map<EnvironmentType, List<URI>> ENVIRONMENTS = Map.of(EnvironmentType.PROD, List.of(PROD_FAPI, PROD_DAPI), EnvironmentType.TEST_NET, List.of(TEST_NET, TEST_NET_SPOT));
    private final URI fapiUri;
    private final URI dapiUri;

    public BinanceExchangeFactory(URI fapiUri, URI dapiUri) {
        super(Exchange.BINANCE, ENVIRONMENTS);
        this.fapiUri = fapiUri;
        this.dapiUri = dapiUri;
    }

    @Override
    public BinanceCex buildCex(Proxy httpProxy) {
        BinanceFuturesRestClient fapi = new BinanceFuturesRestClient(this.createJsonRestClient(this.fapiUri, httpProxy), this.metricsLogger, this.receiveWindow, BinanceFuturesRestClient.Type.FAPI);
        BinanceFuturesRestClient dapi = new BinanceFuturesRestClient(this.createJsonRestClient(this.dapiUri, httpProxy), this.metricsLogger, this.receiveWindow, BinanceFuturesRestClient.Type.DAPI);
        return new BinanceCex(fapi, dapi);
    }

    @Override
    public BinanceCex buildCex() {
        return this.buildCex(this.httpProxy);
    }

    @Override
    protected BinanceExchangeFactory me() {
        return this;
    }

    @Override
    public BinanceCex buildEdi() {
        return this.buildCex();
    }

    @Override
    public BinanceCex buildEdi(Proxy httpProxy) {
        return this.buildCex(httpProxy);
    }
}

