/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.binance.lib;

import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.common.codec.JacksonCodec;
import estonlabs.cxtl.common.exception.CxtlApiException;
import estonlabs.cxtl.common.exception.ErrorCode;
import estonlabs.cxtl.common.http.Event;
import estonlabs.cxtl.common.http.HeaderBuilder;
import estonlabs.cxtl.common.http.JsonRestClient;
import estonlabs.cxtl.common.http.MetricsLogger;
import estonlabs.cxtl.common.security.HmacUtils;
import estonlabs.cxtl.exchanges.a.specification.domain.AssetClass;
import estonlabs.cxtl.exchanges.binance.fapi.domain.ExchangeInfo;
import estonlabs.cxtl.exchanges.binance.fapi.domain.FutureOrder;
import estonlabs.cxtl.exchanges.binance.fapi.domain.ListenKey;
import estonlabs.cxtl.exchanges.binance.fapi.domain.OrderQuery;
import estonlabs.cxtl.exchanges.binance.fapi.domain.OrderRequest;
import estonlabs.cxtl.exchanges.binance.fapi.domain.PerpInverseOrder;
import estonlabs.cxtl.exchanges.binance.fapi.domain.PerpOrder;
import estonlabs.cxtl.exchanges.binance.fapi.domain.Response;
import estonlabs.cxtl.exchanges.binance.fapi.domain.SignedRequest;
import estonlabs.cxtl.exchanges.binance.fapi.domain.Symbol;
import estonlabs.cxtl.exchanges.binance.fapi.domain.TradeData;
import estonlabs.cxtl.exchanges.binance.fapi.domain.stream.OrderBookSnapshot;
import estonlabs.cxtl.exchanges.binance.general.domain.Order;
import java.net.Proxy;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Mono;

public class BinanceFuturesRestClient {
    private static final String CONTENT_TYPE = "application/x-www-form-urlencoded";
    private final JsonRestClient client;
    private final MetricsLogger metricsLogger;
    private final Long recvWindow;
    private final Type type;

    public BinanceFuturesRestClient(JsonRestClient client, MetricsLogger metricsLogger, Long recvWindow, Type type) {
        this.client = client;
        this.metricsLogger = metricsLogger;
        this.recvWindow = recvWindow;
        this.type = type;
    }

    public Proxy getProxy() {
        return this.client.getProxy();
    }

    private String url(String path) {
        return String.format(path, this.type.path);
    }

    public Mono<ListenKey> createListenKey(Credentials credentials) {
        return this.client.postEmpty(this.headers(credentials), this.url("%s/listenKey"), ListenKey.class).map(this::onSuccess);
    }

    public Mono<ListenKey> refreshListenKey(Credentials credentials) {
        return this.client.putEmpty(this.headers(credentials), this.url("%s/listenKey"), ListenKey.class).map(this::onSuccess);
    }

    public Mono<List<TradeData>> getLatestPublicTrades(String ticker) {
        Symbol symbol = Symbol.builder().symbol(ticker).build();
        return this.client.getMany(this.url("%s/trades"), symbol, TradeData.class).map(this::onSuccess);
    }

    public Mono<List<ExchangeInfo.Symbol>> getTickers() {
        return this.client.get(this.url("%s/exchangeInfo"), ExchangeInfo.class).map(this::onSuccess).map(ExchangeInfo::getSymbols);
    }

    public Mono<? extends Order> placeOrder(Credentials credentials, OrderRequest order) {
        return this.post(credentials, this.url("%s/order"), order, this.getType(order.getAssetClass()));
    }

    public Mono<? extends Order> cancelOrder(Credentials credentials, OrderQuery request) {
        return this.delete(credentials, this.url("%s/order"), request, this.getType(request.getAssetClass()));
    }

    public Mono<? extends List<? extends Order>> getOrders(Credentials credentials, OrderQuery orderQuery) {
        String path = this.orderQueryPath(orderQuery);
        return this.getMany(credentials, path, orderQuery, this.getType(orderQuery.getAssetClass()));
    }

    private Class<? extends Order> getType(AssetClass assetClass) {
        return switch (assetClass) {
            case AssetClass.PERP -> PerpOrder.class;
            case AssetClass.PERP_INVERSE -> PerpInverseOrder.class;
            case AssetClass.FUTURE -> FutureOrder.class;
            default -> throw new UnsupportedOperationException("Asset class not supported: " + assetClass);
        };
    }

    public Mono<? extends Order> getOrder(Credentials credentials, OrderQuery orderQuery) {
        String path = this.orderQueryPath(orderQuery);
        return this.get(credentials, path, orderQuery, this.getType(orderQuery.getAssetClass()));
    }

    @NotNull
    private String orderQueryPath(OrderQuery orderQuery) {
        if (orderQuery.getOrigClientOrderId() == null && orderQuery.getOrderId() == null) {
            return this.url("%s/openOrders");
        }
        return this.url("%s/order");
    }

    public Request.Builder addHeaders(Credentials credentials, Request.Builder builder) {
        return builder.addHeader("Content-Type", CONTENT_TYPE).addHeader("X-MBX-APIKEY", credentials.getApiKey());
    }

    public <IN extends SignedRequest, OUT extends Response> Mono<? extends OUT> get(Credentials credentials, String path, IN request, Class<OUT> type) {
        return this.client.get(this.headers(credentials), path, this.sign(credentials, request), type).flatMap(this::handleResponse);
    }

    public <IN extends SignedRequest, OUT extends Response> Mono<List<? extends OUT>> getMany(Credentials credentials, String path, IN request, Class<OUT> type) {
        return this.client.getMany(this.headers(credentials), path, this.sign(credentials, request), type).map(this::onSuccess);
    }

    public <IN extends SignedRequest, OUT extends Response> Mono<? extends OUT> delete(Credentials credentials, String path, IN request, Class<OUT> type) {
        return this.client.deleteAsParams(this.headers(credentials), path, this.sign(credentials, request), type).flatMap(this::handleResponse);
    }

    public <IN extends SignedRequest, OUT extends Response> Mono<? extends OUT> post(Credentials credentials, String path, IN request, Class<OUT> type) {
        return this.client.postAsParams(this.headers(credentials), path, this.sign(credentials, request), type).flatMap(this::handleResponse);
    }

    public Mono<OrderBookSnapshot> getOrderBook(String symbol, int limit) {
        String path = String.format("%s/v1/depth?symbol=%s&limit=%d", this.type.path, symbol, limit);
        return this.client.get(path, OrderBookSnapshot.class).map(this::onSuccess);
    }

    @NonNull
    private HeaderBuilder headers(Credentials credentials) {
        return (builder, json) -> this.addHeaders(credentials, builder);
    }

    private <IN extends SignedRequest> IN sign(Credentials credentials, IN request) {
        if (request == null) {
            return null;
        }
        request.setRecvWindow(this.recvWindow);
        Map<String, ?> map = this.client.getCodec().toMap(request);
        String strMessage = JacksonCodec.mapToStringBuilder(map, new StringBuilder()).toString();
        String signature = HmacUtils.sign(credentials, strMessage);
        request.setSignature(signature);
        return request;
    }

    private <OUT extends Response> Mono<OUT> handleResponse(Event<OUT> event) {
        Response response = (Response)event.getResponse();
        if (response.getCode() != null && response.getCode() != 0) {
            this.metricsLogger.finishedError(event);
            return Mono.error(new CxtlApiException(response.getMsg(), Integer.toString(response.getCode()), BinanceFuturesRestClient.errorCode(response.getCode())));
        }
        return Mono.just(response).doFinally(v -> this.metricsLogger.finishedSuccess(event));
    }

    private static ErrorCode errorCode(int code) {
        code = Math.abs(code);
        return switch (code) {
            case 2018, 2019 -> ErrorCode.INSUFFICIENT_BALANCE;
            case 4001, 4002, 4016 -> ErrorCode.BAD_PX;
            case 1111, 2024, 2027, 4003, 4004, 4005, 4164 -> ErrorCode.INVALID_QTY;
            case 1121, 1122, 1126 -> ErrorCode.INVALID_SYMBOL;
            case 2011, 2013, 4015 -> ErrorCode.UNKNOWN_ORDER;
            default -> ErrorCode.UNKNOWN_ERROR;
        };
    }

    private <I> I onSuccess(Event<I> e) {
        this.metricsLogger.finishedSuccess(e);
        return e.getResponse();
    }

    public static enum Type {
        SPOT("/api/v3"),
        FAPI("/fapi/v1"),
        DAPI("/dapi/v1");

        private final String path;

        private Type(String path) {
            this.path = path;
        }
    }
}

