/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.binance.lib;

import estonlabs.cxtl.common.EnvironmentType;
import estonlabs.cxtl.common.codec.JacksonCodec;
import estonlabs.cxtl.common.http.Event;
import estonlabs.cxtl.common.http.JsonRestClient;
import estonlabs.cxtl.common.http.MetricsLogger;
import estonlabs.cxtl.exchanges.a.specification.domain.AssetClass;
import estonlabs.cxtl.exchanges.binance.fapi.domain.stream.OrderBookSnapshot;
import java.net.URI;
import java.util.Hashtable;
import java.util.Map;
import reactor.core.publisher.Mono;

public class BinancePublicRestClient {
    private static final Map<EnvironmentType, Map<AssetClass, URI>> urls = Map.of(EnvironmentType.PROD, Map.of(AssetClass.PERP, URI.create("https://fapi.binance.com/fapi/v1"), AssetClass.PERP_INVERSE, URI.create("https://dapi.binance.com/dapi/v1"), AssetClass.SPOT, URI.create("https://api.binance.com/api/v3")), EnvironmentType.TEST_NET, Map.of(AssetClass.PERP, URI.create("https://testnet.binancefuture.com/fapi/v1"), AssetClass.PERP_INVERSE, URI.create("https://testnet.binancefuture.com/dapi/v1"), AssetClass.SPOT, URI.create("https://api.binance.com/api/v3")));
    private final Map<AssetClass, JsonRestClient> clients = new Hashtable<AssetClass, JsonRestClient>();
    private final MetricsLogger metricsLogger;
    private final EnvironmentType env;

    public BinancePublicRestClient(MetricsLogger metricsLogger, EnvironmentType env) {
        this.metricsLogger = metricsLogger;
        this.env = env;
    }

    public Mono<OrderBookSnapshot> getOrderBook(AssetClass assetClass, String symbol, int limit) {
        JsonRestClient client = this.clients.computeIfAbsent(assetClass, a -> new JsonRestClient(urls.get((Object)this.env).get((Object)assetClass), new JacksonCodec(), null));
        String path = String.format("/depth?symbol=%s&limit=%d", symbol, limit);
        return client.get(path, OrderBookSnapshot.class).map(this::onSuccess);
    }

    private <I> I onSuccess(Event<I> e) {
        this.metricsLogger.finishedSuccess(e);
        return e.getResponse();
    }
}

