/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.binance.lib;

import estonlabs.cxtl.common.AbstractStreamFactory;
import estonlabs.cxtl.common.EnvironmentType;
import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.common.codec.Codec;
import estonlabs.cxtl.common.codec.JacksonCodec;
import estonlabs.cxtl.common.stream.core.WebsocketConnection;
import estonlabs.cxtl.exchanges.a.specification.domain.AssetClass;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.binance.fapi.domain.ListenKey;
import estonlabs.cxtl.exchanges.binance.fapi.domain.stream.BinanceInboundContainer;
import estonlabs.cxtl.exchanges.binance.fapi.domain.stream.BinanceOutboundMessage;
import estonlabs.cxtl.exchanges.binance.lib.BinanceCex;
import java.net.URI;
import java.util.Map;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinanceStreamFactory
extends AbstractStreamFactory<BinanceOutboundMessage, BinanceInboundContainer, BinanceStreamFactory> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BinanceStreamFactory.class);
    private static final Map<EnvironmentType, Map<AssetClass, URI>> URLS = Map.of(EnvironmentType.PROD, Map.of(AssetClass.PERP, URI.create("wss://fstream.binance.com/ws"), AssetClass.PERP_INVERSE, URI.create("wss://dstream.binance.com/ws"), AssetClass.FUTURE, URI.create("wss://dstream.binance.com/ws"), AssetClass.SPOT, URI.create("wss://stream.binance.com/ws")), EnvironmentType.TEST_NET, Map.of(AssetClass.PERP, URI.create("wss://stream.binancefuture.com/ws"), AssetClass.PERP_INVERSE, URI.create("wss://dstream.binancefuture.com/ws"), AssetClass.FUTURE, URI.create("wss://dstream.binancefuture.com/ws"), AssetClass.SPOT, URI.create("wss://stream.binance.com/ws")));
    private static final Codec<Object> CODEC = new JacksonCodec();
    private final EnvironmentType env;
    private BinanceCex cex;

    public BinanceStreamFactory(EnvironmentType env) {
        super(Exchange.BINANCE, CODEC, BinanceInboundContainer.class);
        this.env = env;
    }

    public BinanceStreamFactory cex(BinanceCex cex) {
        this.cex = cex;
        return this;
    }

    public static BinanceStreamFactory prod() {
        return new BinanceStreamFactory(EnvironmentType.PROD);
    }

    @Override
    protected BinanceStreamFactory me() {
        return this;
    }

    public WebsocketConnection<BinanceOutboundMessage, BinanceInboundContainer> createPrivateStream(@NonNull Credentials credentials, @NonNull AssetClass assetClass) {
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
        if (assetClass == null) {
            throw new NullPointerException("assetClass is marked non-null but is null");
        }
        if (this.cex == null) {
            throw new IllegalStateException("A BinanceCex must be set to create a private websocket for Binance");
        }
        ListenKey listenKey = this.cex.createListenKey(credentials, assetClass).block();
        if (listenKey == null || listenKey.getListenKey() == null) {
            throw new IllegalStateException("Could not get a listen key for Binance");
        }
        this.ping(600000L, () -> this.cex.refreshListenKey(credentials, assetClass).subscribe(), false);
        String url = URLS.get((Object)this.env).get((Object)assetClass).toString() + "/" + listenKey.getListenKey();
        return this.newPrivateWebsocketWithProxy(URI.create(url), this.httpProxy, null);
    }

    public WebsocketConnection<BinanceOutboundMessage, BinanceInboundContainer> createPublicStream(AssetClass assetClass) {
        return this.newPublicWebsocket(URLS.get((Object)this.env).get((Object)assetClass), null);
    }
}

