/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.bullish.api.v2.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.common.stream.managed.AbstractInboundData;
import estonlabs.cxtl.exchanges.a.specification.domain.Order;
import estonlabs.cxtl.exchanges.a.specification.domain.SimpleOrderStatus;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.BullishOrderStatus;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.OrderType;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.Side;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.Tif;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class BullishOrder
extends AbstractInboundData
implements Order {
    @JsonProperty(value="clientOrderId")
    private String clOrdId;
    @JsonProperty(value="orderId")
    private String orderId;
    @JsonProperty(value="symbol")
    private String symbol;
    @JsonProperty(value="price")
    private Double price;
    @JsonProperty(value="averageFillPrice")
    private Double lastOrAvgPx;
    @JsonProperty(value="stopPrice")
    private Double stopPrice;
    @JsonProperty(value="allowBorrow")
    private boolean allowBorrow;
    @JsonProperty(value="quantity")
    private double quantity;
    @JsonProperty(value="quantityFilled")
    private double cumQty;
    @JsonProperty(value="baseFee")
    private double baseFee;
    @JsonProperty(value="quoteFee")
    private double quoteFee;
    @JsonProperty(value="borrowedBaseQuantity")
    private double borrowedBaseQuantity;
    @JsonProperty(value="borrowedQuoteQuantity")
    private double borrowedQuoteQuantity;
    @JsonProperty(value="isLiquidation")
    private boolean isLiquidation;
    @JsonProperty(value="side")
    private Side side;
    @JsonProperty(value="type")
    private OrderType type;
    @JsonProperty(value="timeInForce")
    private Tif timeInForce;
    @JsonProperty(value="status")
    private BullishOrderStatus status;
    @JsonProperty(value="statusReason")
    private String statusReason;
    @JsonProperty(value="statusReasonCode")
    private int statusReasonCode;
    @JsonProperty(value="createdAtDatetime")
    private String createdAtDatetime;
    @JsonProperty(value="createdAtTimestamp")
    private long createdAtTimestamp;

    @Override
    public SimpleOrderStatus getSimpleStatus() {
        return this.status.getSimpleOrderStatus();
    }

    @Override
    public String getClOrdId() {
        return this.clOrdId;
    }

    @Override
    public String getOrderId() {
        return this.orderId;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public Double getPrice() {
        return this.price;
    }

    @Override
    public Double getLastOrAvgPx() {
        return this.lastOrAvgPx;
    }

    public Double getStopPrice() {
        return this.stopPrice;
    }

    public boolean isAllowBorrow() {
        return this.allowBorrow;
    }

    public double getQuantity() {
        return this.quantity;
    }

    @Override
    public double getCumQty() {
        return this.cumQty;
    }

    public double getBaseFee() {
        return this.baseFee;
    }

    public double getQuoteFee() {
        return this.quoteFee;
    }

    public double getBorrowedBaseQuantity() {
        return this.borrowedBaseQuantity;
    }

    public double getBorrowedQuoteQuantity() {
        return this.borrowedQuoteQuantity;
    }

    public boolean isLiquidation() {
        return this.isLiquidation;
    }

    public Side getSide() {
        return this.side;
    }

    public OrderType getType() {
        return this.type;
    }

    public Tif getTimeInForce() {
        return this.timeInForce;
    }

    public BullishOrderStatus getStatus() {
        return this.status;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public int getStatusReasonCode() {
        return this.statusReasonCode;
    }

    public String getCreatedAtDatetime() {
        return this.createdAtDatetime;
    }

    public long getCreatedAtTimestamp() {
        return this.createdAtTimestamp;
    }

    @JsonProperty(value="clientOrderId")
    public void setClOrdId(String clOrdId) {
        this.clOrdId = clOrdId;
    }

    @JsonProperty(value="orderId")
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    @JsonProperty(value="symbol")
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    @JsonProperty(value="price")
    public void setPrice(Double price) {
        this.price = price;
    }

    @JsonProperty(value="averageFillPrice")
    public void setLastOrAvgPx(Double lastOrAvgPx) {
        this.lastOrAvgPx = lastOrAvgPx;
    }

    @JsonProperty(value="stopPrice")
    public void setStopPrice(Double stopPrice) {
        this.stopPrice = stopPrice;
    }

    @JsonProperty(value="allowBorrow")
    public void setAllowBorrow(boolean allowBorrow) {
        this.allowBorrow = allowBorrow;
    }

    @JsonProperty(value="quantity")
    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    @JsonProperty(value="quantityFilled")
    public void setCumQty(double cumQty) {
        this.cumQty = cumQty;
    }

    @JsonProperty(value="baseFee")
    public void setBaseFee(double baseFee) {
        this.baseFee = baseFee;
    }

    @JsonProperty(value="quoteFee")
    public void setQuoteFee(double quoteFee) {
        this.quoteFee = quoteFee;
    }

    @JsonProperty(value="borrowedBaseQuantity")
    public void setBorrowedBaseQuantity(double borrowedBaseQuantity) {
        this.borrowedBaseQuantity = borrowedBaseQuantity;
    }

    @JsonProperty(value="borrowedQuoteQuantity")
    public void setBorrowedQuoteQuantity(double borrowedQuoteQuantity) {
        this.borrowedQuoteQuantity = borrowedQuoteQuantity;
    }

    @JsonProperty(value="isLiquidation")
    public void setLiquidation(boolean isLiquidation) {
        this.isLiquidation = isLiquidation;
    }

    @JsonProperty(value="side")
    public void setSide(Side side) {
        this.side = side;
    }

    @JsonProperty(value="type")
    public void setType(OrderType type) {
        this.type = type;
    }

    @JsonProperty(value="timeInForce")
    public void setTimeInForce(Tif timeInForce) {
        this.timeInForce = timeInForce;
    }

    @JsonProperty(value="status")
    public void setStatus(BullishOrderStatus status) {
        this.status = status;
    }

    @JsonProperty(value="statusReason")
    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    @JsonProperty(value="statusReasonCode")
    public void setStatusReasonCode(int statusReasonCode) {
        this.statusReasonCode = statusReasonCode;
    }

    @JsonProperty(value="createdAtDatetime")
    public void setCreatedAtDatetime(String createdAtDatetime) {
        this.createdAtDatetime = createdAtDatetime;
    }

    @JsonProperty(value="createdAtTimestamp")
    public void setCreatedAtTimestamp(long createdAtTimestamp) {
        this.createdAtTimestamp = createdAtTimestamp;
    }

    @Override
    public String toString() {
        return "BullishOrder(clOrdId=" + this.getClOrdId() + ", orderId=" + this.getOrderId() + ", symbol=" + this.getSymbol() + ", price=" + this.getPrice() + ", lastOrAvgPx=" + this.getLastOrAvgPx() + ", stopPrice=" + this.getStopPrice() + ", allowBorrow=" + this.isAllowBorrow() + ", quantity=" + this.getQuantity() + ", cumQty=" + this.getCumQty() + ", baseFee=" + this.getBaseFee() + ", quoteFee=" + this.getQuoteFee() + ", borrowedBaseQuantity=" + this.getBorrowedBaseQuantity() + ", borrowedQuoteQuantity=" + this.getBorrowedQuoteQuantity() + ", isLiquidation=" + this.isLiquidation() + ", side=" + this.getSide() + ", type=" + this.getType() + ", timeInForce=" + this.getTimeInForce() + ", status=" + this.getStatus() + ", statusReason=" + this.getStatusReason() + ", statusReasonCode=" + this.getStatusReasonCode() + ", createdAtDatetime=" + this.getCreatedAtDatetime() + ", createdAtTimestamp=" + this.getCreatedAtTimestamp() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BullishOrder)) {
            return false;
        }
        BullishOrder other = (BullishOrder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isAllowBorrow() != other.isAllowBorrow()) {
            return false;
        }
        if (Double.compare(this.getQuantity(), other.getQuantity()) != 0) {
            return false;
        }
        if (Double.compare(this.getCumQty(), other.getCumQty()) != 0) {
            return false;
        }
        if (Double.compare(this.getBaseFee(), other.getBaseFee()) != 0) {
            return false;
        }
        if (Double.compare(this.getQuoteFee(), other.getQuoteFee()) != 0) {
            return false;
        }
        if (Double.compare(this.getBorrowedBaseQuantity(), other.getBorrowedBaseQuantity()) != 0) {
            return false;
        }
        if (Double.compare(this.getBorrowedQuoteQuantity(), other.getBorrowedQuoteQuantity()) != 0) {
            return false;
        }
        if (this.isLiquidation() != other.isLiquidation()) {
            return false;
        }
        if (this.getStatusReasonCode() != other.getStatusReasonCode()) {
            return false;
        }
        if (this.getCreatedAtTimestamp() != other.getCreatedAtTimestamp()) {
            return false;
        }
        Double this$price = this.getPrice();
        Double other$price = other.getPrice();
        if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
            return false;
        }
        Double this$lastOrAvgPx = this.getLastOrAvgPx();
        Double other$lastOrAvgPx = other.getLastOrAvgPx();
        if (this$lastOrAvgPx == null ? other$lastOrAvgPx != null : !((Object)this$lastOrAvgPx).equals(other$lastOrAvgPx)) {
            return false;
        }
        Double this$stopPrice = this.getStopPrice();
        Double other$stopPrice = other.getStopPrice();
        if (this$stopPrice == null ? other$stopPrice != null : !((Object)this$stopPrice).equals(other$stopPrice)) {
            return false;
        }
        String this$clOrdId = this.getClOrdId();
        String other$clOrdId = other.getClOrdId();
        if (this$clOrdId == null ? other$clOrdId != null : !this$clOrdId.equals(other$clOrdId)) {
            return false;
        }
        String this$orderId = this.getOrderId();
        String other$orderId = other.getOrderId();
        if (this$orderId == null ? other$orderId != null : !this$orderId.equals(other$orderId)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
            return false;
        }
        Side this$side = this.getSide();
        Side other$side = other.getSide();
        if (this$side == null ? other$side != null : !((Object)((Object)this$side)).equals((Object)other$side)) {
            return false;
        }
        OrderType this$type = this.getType();
        OrderType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Tif this$timeInForce = this.getTimeInForce();
        Tif other$timeInForce = other.getTimeInForce();
        if (this$timeInForce == null ? other$timeInForce != null : !((Object)((Object)this$timeInForce)).equals((Object)other$timeInForce)) {
            return false;
        }
        BullishOrderStatus this$status = this.getStatus();
        BullishOrderStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$statusReason = this.getStatusReason();
        String other$statusReason = other.getStatusReason();
        if (this$statusReason == null ? other$statusReason != null : !this$statusReason.equals(other$statusReason)) {
            return false;
        }
        String this$createdAtDatetime = this.getCreatedAtDatetime();
        String other$createdAtDatetime = other.getCreatedAtDatetime();
        return !(this$createdAtDatetime == null ? other$createdAtDatetime != null : !this$createdAtDatetime.equals(other$createdAtDatetime));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BullishOrder;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isAllowBorrow() ? 79 : 97);
        long $quantity = Double.doubleToLongBits(this.getQuantity());
        result = result * 59 + (int)($quantity >>> 32 ^ $quantity);
        long $cumQty = Double.doubleToLongBits(this.getCumQty());
        result = result * 59 + (int)($cumQty >>> 32 ^ $cumQty);
        long $baseFee = Double.doubleToLongBits(this.getBaseFee());
        result = result * 59 + (int)($baseFee >>> 32 ^ $baseFee);
        long $quoteFee = Double.doubleToLongBits(this.getQuoteFee());
        result = result * 59 + (int)($quoteFee >>> 32 ^ $quoteFee);
        long $borrowedBaseQuantity = Double.doubleToLongBits(this.getBorrowedBaseQuantity());
        result = result * 59 + (int)($borrowedBaseQuantity >>> 32 ^ $borrowedBaseQuantity);
        long $borrowedQuoteQuantity = Double.doubleToLongBits(this.getBorrowedQuoteQuantity());
        result = result * 59 + (int)($borrowedQuoteQuantity >>> 32 ^ $borrowedQuoteQuantity);
        result = result * 59 + (this.isLiquidation() ? 79 : 97);
        result = result * 59 + this.getStatusReasonCode();
        long $createdAtTimestamp = this.getCreatedAtTimestamp();
        result = result * 59 + (int)($createdAtTimestamp >>> 32 ^ $createdAtTimestamp);
        Double $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        Double $lastOrAvgPx = this.getLastOrAvgPx();
        result = result * 59 + ($lastOrAvgPx == null ? 43 : ((Object)$lastOrAvgPx).hashCode());
        Double $stopPrice = this.getStopPrice();
        result = result * 59 + ($stopPrice == null ? 43 : ((Object)$stopPrice).hashCode());
        String $clOrdId = this.getClOrdId();
        result = result * 59 + ($clOrdId == null ? 43 : $clOrdId.hashCode());
        String $orderId = this.getOrderId();
        result = result * 59 + ($orderId == null ? 43 : $orderId.hashCode());
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        Side $side = this.getSide();
        result = result * 59 + ($side == null ? 43 : ((Object)((Object)$side)).hashCode());
        OrderType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Tif $timeInForce = this.getTimeInForce();
        result = result * 59 + ($timeInForce == null ? 43 : ((Object)((Object)$timeInForce)).hashCode());
        BullishOrderStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $statusReason = this.getStatusReason();
        result = result * 59 + ($statusReason == null ? 43 : $statusReason.hashCode());
        String $createdAtDatetime = this.getCreatedAtDatetime();
        result = result * 59 + ($createdAtDatetime == null ? 43 : $createdAtDatetime.hashCode());
        return result;
    }
}

