/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.bullish.api.v2.domain;

import java.util.HashMap;
import java.util.Map;

public enum BullishOrderExecutionStatus {
    OK(1001, "Ok"),
    UNABLE_TO_PLACE_REQUEST(1002, "Unable to place request"),
    BAD_INCOMING_REQUEST(2001, "Bad incoming request"),
    INVALID_USER_CLIENT_ID(2002, "Invalid user's client id"),
    INVALID_HANDLE(2003, "Invalid handle"),
    INVALID_QUANTITY(2004, "Invalid quantity"),
    UNKNOWN_ERROR(2005, "Unknown error"),
    INVALID_ACCOUNT_TYPE(2006, "Invalid account type, account must be spot"),
    ACCOUNT_ALREADY_EXIST(2007, "Account already exist"),
    INVALID_SIDE(2008, "Invalid side, side must me from buy or sell"),
    INVALID_MARKET(2009, "Invalid market"),
    ACCOUNT_DOES_NOT_EXIST(2010, "Account doesn't exist"),
    ACCOUNT_TYPES_ARE_DIFFERENT(2011, "Account types are different"),
    INVALID_PRICE(2012, "Invalid price"),
    INVALID_ORDER_TYPE(2013, "Invalid order type, type must be from limit, market, stop-limit"),
    EXCEEDED_MAX_MARGIN_ORDERS(2015, "Exceeded maximum amount of allowed open margin orders"),
    UNKNOWN_REQUEST_TYPE(2016, "Unknown request type"),
    INVALID_ORDER_ID(2017, "Invalid order id"),
    UNKNOWN_TIME_IN_FORCE_OPTION(2018, "Unknown time in force option"),
    MARGIN_TRADING_NOT_ALLOWED(2020, "Margin trading is not allowed"),
    EXCEEDED_MAX_SPOT_ORDERS(2021, "Exceeded maximum amount of allowed open spot orders"),
    INVALID_REQUEST_ID(2029, "Invalid request id"),
    INVALID_NONCE(2035, "Invalid nonce"),
    INSUFFICIENT_BALANCE(3001, "Account doesn't have sufficient balance"),
    ORDER_NOT_FOUND(3002, "Order is not found"),
    BORROWING_UNAVAILABLE(3003, "Borrowing is unavailable"),
    DUPLICATED_ORDER_ID(3007, "Duplicated order id"),
    UNSOLICITED_CANCEL(3020, "Unsolicited cancel"),
    FORCED_CANCEL(3021, "Forced cancel"),
    DUPLICATED_ORDER_HANDLE(3023, "Duplicated order handle"),
    PRICE_OUT_OF_RANGE(3031, "Price is out of range"),
    ORDER_CLOSED_OR_REJECTED(3032, "Order is either closed or rejected"),
    OPEN(6001, "Open"),
    EXECUTED(6002, "Executed"),
    MATURED(6003, "Matured"),
    EXPIRED(6004, "Expired"),
    USER_CANCELLED(6005, "User cancelled"),
    SELF_CROSS_PREVENTION(6007, "Self cross prevention"),
    SELF_CROSS_PREVENTION_AMEND(6011, "Self cross prevention amend"),
    STOP_LIMIT_AMEND(6012, "Stop limit amend"),
    PARTIALLY_FILLED(6013, "Partially filled"),
    ACCEPTED(6014, "Accepted"),
    FILLED(6015, "Filled");

    private final int code;
    private final String description;
    private static final Map<Integer, BullishOrderExecutionStatus> intMappings;

    public static BullishOrderExecutionStatus getStatus(int code) {
        return intMappings.get(code);
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    private BullishOrderExecutionStatus(int code, String description) {
        this.code = code;
        this.description = description;
    }

    static {
        intMappings = new HashMap<Integer, BullishOrderExecutionStatus>();
        for (BullishOrderExecutionStatus s : BullishOrderExecutionStatus.values()) {
            intMappings.put(s.code, s);
        }
    }
}

