/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.bullish.api.v2.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.BullishOrderStatus;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.Side;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class BullishOrderQuery {
    private final String symbol;
    private final String clientOrderId;
    private final Side side;
    private final BullishOrderStatus status;
    private final String tradingAccount;

    public static BullishOrderQueryBuilder builder() {
        return new BullishOrderQueryBuilder();
    }

    public BullishOrderQuery(String symbol, String clientOrderId, Side side, BullishOrderStatus status, String tradingAccount) {
        this.symbol = symbol;
        this.clientOrderId = clientOrderId;
        this.side = side;
        this.status = status;
        this.tradingAccount = tradingAccount;
    }

    public String toString() {
        return "BullishOrderQuery(symbol=" + this.getSymbol() + ", clientOrderId=" + this.getClientOrderId() + ", side=" + this.getSide() + ", status=" + this.getStatus() + ", tradingAccount=" + this.getTradingAccount() + ")";
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getClientOrderId() {
        return this.clientOrderId;
    }

    public Side getSide() {
        return this.side;
    }

    public BullishOrderStatus getStatus() {
        return this.status;
    }

    public String getTradingAccount() {
        return this.tradingAccount;
    }

    public static class BullishOrderQueryBuilder {
        private String symbol;
        private String clientOrderId;
        private Side side;
        private BullishOrderStatus status;
        private String tradingAccount;

        BullishOrderQueryBuilder() {
        }

        public BullishOrderQueryBuilder symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        public BullishOrderQueryBuilder clientOrderId(String clientOrderId) {
            this.clientOrderId = clientOrderId;
            return this;
        }

        public BullishOrderQueryBuilder side(Side side) {
            this.side = side;
            return this;
        }

        public BullishOrderQueryBuilder status(BullishOrderStatus status) {
            this.status = status;
            return this;
        }

        public BullishOrderQueryBuilder tradingAccount(String tradingAccount) {
            this.tradingAccount = tradingAccount;
            return this;
        }

        public BullishOrderQuery build() {
            return new BullishOrderQuery(this.symbol, this.clientOrderId, this.side, this.status, this.tradingAccount);
        }

        public String toString() {
            return "BullishOrderQuery.BullishOrderQueryBuilder(symbol=" + this.symbol + ", clientOrderId=" + this.clientOrderId + ", side=" + this.side + ", status=" + this.status + ", tradingAccount=" + this.tradingAccount + ")";
        }
    }
}

