/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.bullish.api.v2.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"commandType", "orderId", "handle", "symbol", "tradingAccountId"})
public class CancelOrderRequest {
    private static final String CANCEL_ORDER = "V3CancelOrder";
    private static final String CANCEL_ORDER_V1 = "V1CancelOrder";
    private static final String CANCEL_ALL_ORDERS = "V1CancelAllOrders";
    private static final String CANCEL_ALL_FOR_SYMBOL = "V1CancelAllOrdersByMarket";
    @JsonProperty(value="commandType")
    private String commandType;
    @JsonProperty(value="orderId")
    private String orderId;
    @JsonProperty(value="clientOrderId")
    private String clientOrderId;
    @JsonProperty(value="symbol")
    private String symbol;
    @JsonProperty(value="tradingAccountId")
    private String tradingAccountId;

    public static CancelOrderRequest cancelByClOrdId(String symbol, String clientOrderId, String tradingAccountId) {
        return new CancelOrderRequest(CANCEL_ORDER, null, clientOrderId, symbol, tradingAccountId);
    }

    public static CancelOrderRequest cancelByOrderId(String symbol, String orderId, String tradingAccountId) {
        return new CancelOrderRequest(CANCEL_ORDER, orderId, null, symbol, tradingAccountId);
    }

    public static CancelOrderRequest cancelAll(String tradingAccountId) {
        return new CancelOrderRequest(CANCEL_ALL_ORDERS, null, null, null, tradingAccountId);
    }

    public static CancelOrderRequest cancelAllForSymbol(String symbol, String tradingAccountId) {
        return new CancelOrderRequest(CANCEL_ALL_FOR_SYMBOL, null, null, symbol, tradingAccountId);
    }

    public CancelOrderRequest(String commandType, String orderId, String clientOrderId, String symbol, String tradingAccountId) {
        this.commandType = commandType;
        this.orderId = orderId;
        this.clientOrderId = clientOrderId;
        this.symbol = symbol;
        this.tradingAccountId = tradingAccountId;
    }

    public String toString() {
        return "CancelOrderRequest(commandType=" + this.getCommandType() + ", orderId=" + this.getOrderId() + ", clientOrderId=" + this.getClientOrderId() + ", symbol=" + this.getSymbol() + ", tradingAccountId=" + this.getTradingAccountId() + ")";
    }

    public String getCommandType() {
        return this.commandType;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getClientOrderId() {
        return this.clientOrderId;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getTradingAccountId() {
        return this.tradingAccountId;
    }
}

