/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.bullish.api.v2.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.OrderType;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.Side;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.Tif;
import java.math.BigDecimal;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"symbol", "commandType", "type", "side", "quantity", "price", "stopPrice", "timeInForce", "allowBorrow", "clientOrderId", "tradingAccountId"})
public class CreateOrderRequest {
    @JsonIgnore
    private final long creationTime;
    @JsonProperty(value="commandType")
    private final String commandType;
    @JsonProperty(value="clientOrderId")
    private final String clientOrderId;
    @JsonProperty(value="symbol")
    private final String symbol;
    @JsonProperty(value="type")
    private OrderType type;
    @JsonProperty(value="side")
    private final Side side;
    @JsonProperty(value="price")
    private String price;
    @JsonProperty(value="stopPrice")
    private String stopPrice;
    @JsonProperty(value="quantity")
    private final String quantity;
    @JsonProperty(value="timeInForce")
    private Tif timeInForce;
    @JsonProperty(value="allowBorrow")
    private boolean allowBorrow;
    @JsonProperty(value="tradingAccountId")
    private String tradingAccountId;

    public CreateOrderRequest(long creationTime, String clientOrderId, String symbol, Side side, Tif timeInForce, Double price, double quantity, String tradingAccountId) {
        this.creationTime = creationTime;
        this.commandType = "V3CreateOrder";
        this.clientOrderId = clientOrderId;
        this.symbol = symbol;
        this.side = side;
        this.timeInForce = timeInForce;
        this.type = price == null ? OrderType.MARKET : OrderType.LIMIT;
        this.price = price == null ? null : this.getStringFromDouble(price);
        this.quantity = this.getStringFromDouble(quantity);
        this.tradingAccountId = tradingAccountId;
    }

    private String getStringFromDouble(double d) {
        return BigDecimal.valueOf(d).toPlainString();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getCommandType() {
        return this.commandType;
    }

    public String getClientOrderId() {
        return this.clientOrderId;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public OrderType getType() {
        return this.type;
    }

    public Side getSide() {
        return this.side;
    }

    public String getPrice() {
        return this.price;
    }

    public String getStopPrice() {
        return this.stopPrice;
    }

    public String getQuantity() {
        return this.quantity;
    }

    public Tif getTimeInForce() {
        return this.timeInForce;
    }

    public boolean isAllowBorrow() {
        return this.allowBorrow;
    }

    public String getTradingAccountId() {
        return this.tradingAccountId;
    }

    public String toString() {
        return "CreateOrderRequest(creationTime=" + this.getCreationTime() + ", commandType=" + this.getCommandType() + ", clientOrderId=" + this.getClientOrderId() + ", symbol=" + this.getSymbol() + ", type=" + this.getType() + ", side=" + this.getSide() + ", price=" + this.getPrice() + ", stopPrice=" + this.getStopPrice() + ", quantity=" + this.getQuantity() + ", timeInForce=" + this.getTimeInForce() + ", allowBorrow=" + this.isAllowBorrow() + ", tradingAccountId=" + this.getTradingAccountId() + ")";
    }
}

