/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.bullish.api.v2.domain.stream;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import estonlabs.cxtl.common.stream.managed.AbstractInboundData;
import estonlabs.cxtl.common.stream.managed.MarketData;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.BullishL1Data;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"type", "dataType", "data"})
public class BullishL1QuoteUpdate
extends AbstractInboundData
implements MarketData {
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="dataType")
    private String dataType;
    @JsonProperty(value="data")
    private BullishL1Data data;
    @JsonIgnore
    private final boolean snapshot = true;

    @Override
    @JsonIgnore
    public String getTopic() {
        return String.format("l1Orderbook:%s", this.data.getSymbol());
    }

    @Override
    public Long getSeqNo() {
        return this.data.getSequenceNumber();
    }

    @Override
    public Long getTimestamp() {
        return this.data.getTimestamp();
    }

    @Override
    public boolean hasData() {
        return this.data != null;
    }

    public String getType() {
        return this.type;
    }

    public String getDataType() {
        return this.dataType;
    }

    public BullishL1Data getData() {
        return this.data;
    }

    @Override
    public boolean isSnapshot() {
        return this.snapshot;
    }

    @Override
    public String toString() {
        return "BullishL1QuoteUpdate(type=" + this.getType() + ", dataType=" + this.getDataType() + ", data=" + this.getData() + ", snapshot=" + this.isSnapshot() + ")";
    }
}

