/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.bullish.api.v2.domain.stream;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.common.stream.managed.AbstractInboundData;
import estonlabs.cxtl.common.stream.managed.MarketData;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.stream.BullishQuote;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class BullishOrderBookUpdate
extends AbstractInboundData
implements MarketData {
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="dataType")
    private String dataType;
    @JsonProperty(value="data")
    private BullishQuote data;

    @Override
    public boolean isSnapshot() {
        return this.type.equals("snapshot");
    }

    @Override
    @JsonIgnore
    public String getTopic() {
        return String.format("l2Orderbook:%s", this.data.getSymbol());
    }

    @Override
    public Long getSeqNo() {
        return this.data.getSequenceNumberRange().get(this.data.getSequenceNumberRange().size() - 1);
    }

    @Override
    public Long getTimestamp() {
        return this.data.getTimestamp();
    }

    @Override
    public boolean hasData() {
        return this.data != null;
    }

    public String getType() {
        return this.type;
    }

    public String getDataType() {
        return this.dataType;
    }

    public BullishQuote getData() {
        return this.data;
    }

    @Override
    public String toString() {
        return "BullishOrderBookUpdate(type=" + this.getType() + ", dataType=" + this.getDataType() + ", data=" + this.getData() + ")";
    }
}

