/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.bullish.api.v2.domain.stream;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.common.stream.managed.OutboundMessage;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class BullishOutboundMessage<PARAMS>
implements OutboundMessage {
    private static AtomicLong IDS = new AtomicLong();
    @JsonProperty(value="jsonrpc")
    private final String jsonrpc = "2.0";
    @JsonProperty(value="type")
    private final String type = "command";
    @JsonProperty(value="method")
    @NonNull
    private String method;
    @JsonProperty(value="id")
    private final String id = Long.toString(IDS.incrementAndGet());

    public abstract PARAMS getParams();

    public String getJsonrpc() {
        return this.jsonrpc;
    }

    public String getType() {
        return this.type;
    }

    @NonNull
    public String getMethod() {
        return this.method;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "BullishOutboundMessage(jsonrpc=" + this.getJsonrpc() + ", type=" + this.getType() + ", method=" + this.getMethod() + ", id=" + this.getId() + ")";
    }

    public BullishOutboundMessage(@NonNull String method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        this.method = method;
    }

    public static enum MethodType {
        SUBSCRIBE("subscribe"),
        UNSUBSCRIBE("unsubscribe"),
        PING("keepalivePing");

        final String method;

        private MethodType(String method) {
            this.method = method;
        }
    }
}

