/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.bullish.api.v2.lib;

import estonlabs.cxtl.common.AbstractExchangeFactory;
import estonlabs.cxtl.common.EnvironmentType;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.BullishInstrument;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.BullishOrderQuery;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.CancelOrderRequest;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.CreateOrderRequest;
import estonlabs.cxtl.exchanges.bullish.api.v2.lib.BullishRestClient;
import java.net.Proxy;
import java.net.URI;
import java.util.List;
import java.util.Map;

public class BullishExchangeFactory
extends AbstractExchangeFactory<CreateOrderRequest, CancelOrderRequest, BullishOrderQuery, Object, BullishInstrument, BullishRestClient, BullishExchangeFactory> {
    public static final URI PROD = URI.create("https://api.exchange.bullish.com");
    public static final URI REGISTERED = URI.create("https://registered.api.exchange.bullish.com");
    public static final URI SECURITY_SANDBOX = URI.create("https://api.bugbounty.bullish.com");
    public static final URI TEST_NET = URI.create("https://api.simnext.bullish-test.com");
    private static final Map<EnvironmentType, List<URI>> ENVIRONMENTS = Map.of(EnvironmentType.PROD, List.of(PROD, REGISTERED), EnvironmentType.TEST_NET, List.of(TEST_NET, SECURITY_SANDBOX));
    private final URI baseUri;

    public BullishExchangeFactory(URI baseUri) {
        super(Exchange.BULLISH, ENVIRONMENTS);
        this.baseUri = baseUri;
    }

    @Override
    public BullishRestClient buildCex() {
        return new BullishRestClient(this.createJsonRestClient(this.baseUri), this.metricsLogger);
    }

    @Override
    public BullishRestClient buildCex(Proxy httpProxy) {
        return new BullishRestClient(this.createJsonRestClient(this.baseUri, httpProxy), this.metricsLogger);
    }

    @Override
    protected BullishExchangeFactory me() {
        return this;
    }

    @Override
    public BullishRestClient buildEdi() {
        return this.buildCex();
    }

    @Override
    public BullishRestClient buildEdi(Proxy httpProxy) {
        return this.buildCex(httpProxy);
    }
}

