/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.bullish.api.v2.lib;

import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.common.exception.CxtlApiException;
import estonlabs.cxtl.common.exception.CxtlEventException;
import estonlabs.cxtl.common.exception.ErrorCode;
import estonlabs.cxtl.common.http.Event;
import estonlabs.cxtl.common.http.Method;
import estonlabs.cxtl.common.http.MetricsLogger;
import estonlabs.cxtl.common.http.RestClient;
import estonlabs.cxtl.common.security.HmacUtils;
import estonlabs.cxtl.exchanges.a.specification.domain.AssetClass;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.a.specification.domain.Olhcv;
import estonlabs.cxtl.exchanges.a.specification.domain.Order;
import estonlabs.cxtl.exchanges.a.specification.lib.Cex;
import estonlabs.cxtl.exchanges.a.specification.lib.ExchangeDataInterface;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.BullishAck;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.BullishBalance;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.BullishInstrument;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.BullishOrder;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.BullishOrderQuery;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.BullishResponse;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.BullishTrade;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.BullishTradingAccount;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.CancelOrderRequest;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.CreateOrderRequest;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.auth.BullishLoginResponse;
import estonlabs.cxtl.exchanges.bullish.api.v2.lib.JwtTokenGenerator;
import estonlabs.cxtl.exchanges.bullish.api.v2.lib.NonceGenerator;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.NonNull;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class BullishRestClient
implements Cex<CreateOrderRequest, CancelOrderRequest, BullishOrderQuery>,
ExchangeDataInterface<BullishInstrument, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BullishRestClient.class);
    private static final String LOGIN_URL = "/trading-api/v1/users/hmac/login";
    private static final String COMMAND_URL_V2 = "/trading-api/v2/command";
    private static final String ORDERS_URL = "/trading-api/v2/orders";
    private static final String BALANCE_URL = "/trading-api/v1/accounts/asset";
    private static final String ACCOUNT_URL = "/trading-api/v1/accounts/trading-accounts";
    private static final String MARKETS_URL = "/trading-api/v1/markets";
    private final RestClient client;
    private final MetricsLogger metricsLogger;
    private final Map<Credentials, UserData> userData = new ConcurrentHashMap<Credentials, UserData>();

    public BullishRestClient(RestClient client, MetricsLogger metricsLogger) {
        this.client = client;
        this.metricsLogger = metricsLogger;
    }

    @Override
    public Proxy getProxy() {
        return this.client.getProxy();
    }

    @Override
    public Exchange getExchange() {
        return Exchange.BULLISH;
    }

    @Override
    public AssetClass[] getSupportedAssetClasses() {
        return new AssetClass[]{AssetClass.SPOT, AssetClass.PERP};
    }

    @Override
    @NotNull
    public Mono<BullishAck> placeOrder(@NotNull Credentials credentials, @NotNull CreateOrderRequest order) {
        return this.post(credentials, ORDERS_URL, order, BullishAck.class);
    }

    @Override
    @NotNull
    public Mono<BullishAck> cancelOrder(@NotNull Credentials credentials, @NotNull CancelOrderRequest request) {
        return this.post(credentials, COMMAND_URL_V2, request, BullishAck.class);
    }

    @Override
    public Mono<List<BullishOrder>> getOrders(Credentials credentials, BullishOrderQuery query) {
        return this.getUserData(credentials).flatMap(data -> this.getManyAuthorized((UserData)data, (Object)query, ORDERS_URL, (Class)BullishOrder.class));
    }

    @Override
    public Mono<? extends Order> getOrder(Credentials credentials, BullishOrderQuery orderQuery) {
        return this.getOrders(credentials, orderQuery).map(orders -> orders.isEmpty() ? null : (BullishOrder)orders.get(0));
    }

    @Override
    public Mono<Map<AssetClass, List<BullishInstrument>>> getTickers() {
        return this.client.getMany(MARKETS_URL, null, BullishInstrument.class).map(this::onSuccess).map(response -> response.stream().collect(Collectors.groupingBy(i -> i.getSymbol().contains("PERP") ? AssetClass.PERP : AssetClass.SPOT)));
    }

    @Override
    public Mono<List<BullishTrade>> getLatestPublicTrades(AssetClass assetClass, String symbol) {
        if (Arrays.stream(this.getSupportedAssetClasses()).noneMatch(ac -> ac == assetClass)) {
            return Mono.error(new CxtlApiException("Asset class not supported", "ASSET_CLASS_NOT_SUPPORTED", ErrorCode.INVALID_SYMBOL));
        }
        boolean isPerp = assetClass.isPerp();
        return this.getLatestPublicTrades(symbol).map(trades -> trades.stream().filter(t -> t.getSymbol().contains("PERP") == isPerp).collect(Collectors.toList()));
    }

    @NonNull
    private Mono<List<BullishTrade>> getLatestPublicTrades(String symbol) {
        String url = String.format("/trading-api/v1/markets/%s/trades", symbol);
        return this.client.getMany(url, null, BullishTrade.class).map(this::onSuccess).onErrorResume(this::onError);
    }

    @Override
    public Mono<? extends List<? extends Olhcv>> getOlhcv(Object request) {
        return Mono.empty();
    }

    public Mono<BullishLoginResponse> login(Credentials credentials) {
        ZonedDateTime utcNow = ZonedDateTime.now(ZoneOffset.UTC);
        long timestamp = utcNow.toInstant().toEpochMilli();
        String ts = String.valueOf(timestamp);
        String nonce = Long.toString(timestamp);
        String request = timestamp + nonce + Method.GET.name() + LOGIN_URL;
        String signature = HmacUtils.sign(credentials, request.getBytes(StandardCharsets.UTF_8));
        return this.client.get((builder, json) -> builder.addHeader("BX-PUBLIC-KEY", credentials.getApiKey()).addHeader("BX-NONCE", nonce).addHeader("BX-SIGNATURE", signature).addHeader("BX-TIMESTAMP", ts), LOGIN_URL, BullishLoginResponse.class).flatMap(this::handleResponse);
    }

    public Mono<List<BullishBalance>> getBalances(Credentials credentials) {
        return this.getUserData(credentials).flatMap(data -> this.getManyAuthorized((UserData)data, null, BALANCE_URL, (Class)BullishBalance.class));
    }

    public Mono<List<BullishTradingAccount>> getAccounts(Credentials credentials) {
        return this.getUserData(credentials).flatMap(data -> this.getManyAuthorized((UserData)data, null, ACCOUNT_URL, (Class)BullishTradingAccount.class));
    }

    private <IN, OUT> Mono<List<OUT>> getManyAuthorized(UserData userData, IN in, String url, Class<OUT> outType) {
        return this.client.getMany((builder, json) -> this.authorize(userData.token, builder), url, in, outType).map(this::onSuccess).onErrorResume(this::onError);
    }

    private <OUT> Mono<List<OUT>> onError(Throwable t) {
        if (t instanceof CxtlEventException) {
            CxtlEventException e = (CxtlEventException)t;
            this.metricsLogger.finishedError(e.getEvent());
            BullishResponse response = this.client.getCodec().quietFromJson(e.getEvent().getResponseJson(), BullishResponse.class);
            if (response != null) {
                return BullishRestClient.error(response.getMessage(), response);
            }
        }
        return BullishRestClient.error(t.getMessage(), null);
    }

    @NonNull
    private static <OUT> Mono<OUT> error(String message, BullishResponse response) {
        Integer errorCode = response == null ? null : response.getErrorCode();
        String msg = errorCode == null ? "UNKNOWN" : errorCode.toString();
        return Mono.error(new CxtlApiException(message, msg, BullishRestClient.errorCode(errorCode)));
    }

    public void forceResetNonce(Credentials credentials) {
        this.getUserData(credentials).doOnNext(m -> m.nonce.forceNonceReset()).subscribe();
    }

    public Mono<JwtTokenGenerator> initOrGet(Credentials credentials) {
        return this.getUserData(credentials).map(m -> m.token);
    }

    private Mono<UserData> getUserData(Credentials credentials) {
        UserData data = this.userData.get(credentials);
        if (data == null || data.token.isExpired()) {
            return this.login(credentials).map(t -> {
                JwtTokenGenerator tokenGen = new JwtTokenGenerator((BullishLoginResponse)t);
                UserData userData = new UserData(credentials, tokenGen);
                this.userData.put(credentials, userData);
                return userData;
            });
        }
        return Mono.just(data);
    }

    private <IN, OUT extends BullishResponse> Mono<OUT> post(UserData userData, String path, IN request, Class<OUT> type) {
        return this.client.postAsJson((builder, json) -> this.hmacSignAndAuthorize(userData.credentials, userData.token, userData.nonce, Method.POST, path, builder, json), path, request, type).flatMap(this::handleResponse);
    }

    private <IN, OUT extends BullishResponse> Mono<OUT> post(Credentials credentials, String path, IN request, Class<OUT> type) {
        return this.getUserData(credentials).flatMap(r -> this.post((UserData)r, path, request, type));
    }

    private <OUT extends BullishResponse> Mono<OUT> handleResponse(Event<OUT> event) {
        BullishResponse response = (BullishResponse)event.getResponse();
        if (response.hasError()) {
            this.metricsLogger.finishedError(event);
            return BullishRestClient.error(response.getMessage(), response);
        }
        return Mono.just((BullishResponse)this.onSuccess(event));
    }

    private <I> I onSuccess(Event<I> e) {
        this.metricsLogger.finishedSuccess(e);
        return e.getResponse();
    }

    public Request.Builder hmacSignAndAuthorize(Credentials credentials, JwtTokenGenerator token, NonceGenerator nonceGenerator, Method method, String path, Request.Builder builder, String message) {
        String nonce = nonceGenerator.next();
        String lastGeneratedMs = nonceGenerator.getLastGeneratedMs();
        String request = lastGeneratedMs + nonce + method.name() + path + message;
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        digest.update(request.getBytes(StandardCharsets.UTF_8), 0, request.length());
        String hexString = HmacUtils.bytesToHex(digest.digest());
        String signature = HmacUtils.sign(credentials, hexString);
        return this.addHeaders(token, builder, signature, lastGeneratedMs, nonce);
    }

    public Request.Builder authorize(JwtTokenGenerator token, Request.Builder builder) {
        return builder.addHeader("Content-type", "application/json").addHeader("Authorization", token.getBearerToken());
    }

    @NonNull
    private Request.Builder addHeaders(JwtTokenGenerator token, Request.Builder builder, String signature, String lastGeneratedMs, String nonce) {
        return this.authorize(token, builder).addHeader("BX-SIGNATURE", signature).addHeader("BX-TIMESTAMP", lastGeneratedMs).addHeader("BX-NONCE", nonce).addHeader("BX-NONCE-WINDOW-ENABLED", "true");
    }

    private static ErrorCode errorCode(Integer code) {
        if (code == null) {
            return ErrorCode.UNKNOWN_ERROR;
        }
        return switch (code) {
            case 2015, 3003 -> ErrorCode.INSUFFICIENT_BALANCE;
            case 18, 2012, 3031, 6018 -> ErrorCode.BAD_PX;
            case 13, 2004, 6019, 6023 -> ErrorCode.INVALID_QTY;
            case 1, 2009 -> ErrorCode.INVALID_SYMBOL;
            default -> ErrorCode.UNKNOWN_ERROR;
        };
    }

    private static final class UserData {
        final Credentials credentials;
        JwtTokenGenerator token;
        NonceGenerator nonce = new NonceGenerator();

        public UserData(Credentials credentials, JwtTokenGenerator token) {
            this.credentials = credentials;
            this.token = token;
        }
    }
}

