/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.bullish.api.v2.lib;

import estonlabs.cxtl.common.AbstractStreamFactory;
import estonlabs.cxtl.common.EnvironmentType;
import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.common.codec.Codec;
import estonlabs.cxtl.common.codec.JacksonCodec;
import estonlabs.cxtl.common.stream.core.WebsocketConnection;
import estonlabs.cxtl.common.stream.managed.OutboundMessage;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.stream.BullishInboundContainer;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.stream.BullishOutboundMessage;
import estonlabs.cxtl.exchanges.bullish.api.v2.domain.stream.NoParamsOutboundMessage;
import estonlabs.cxtl.exchanges.bullish.api.v2.lib.BullishRestClient;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;

public class BullishStreamFactory
extends AbstractStreamFactory<BullishOutboundMessage<?>, BullishInboundContainer, BullishStreamFactory> {
    private static final NoParamsOutboundMessage PING = new NoParamsOutboundMessage(BullishOutboundMessage.MethodType.PING, OutboundMessage.MessageType.PING);
    private static final Codec<Object> CODEC = new JacksonCodec();
    public static final URI PROD = URI.create("wss://api.exchange.bullish.com");
    public static final URI REGISTERED = URI.create("wss://registered.api.exchange.bullish.com");
    public static final URI SECURITY_SANDBOX = URI.create("wss://api.bugbounty.bullish.com");
    public static final URI TEST_NET = URI.create("wss://api.simnext.bullish-test.com");
    private static final Map<EnvironmentType, List<URI>> ENVIRONMENTS = Map.of(EnvironmentType.PROD, List.of(PROD, REGISTERED), EnvironmentType.TEST_NET, List.of(TEST_NET, SECURITY_SANDBOX));
    private BullishRestClient client;
    private URI baseUri;

    public BullishStreamFactory(URI baseUri) {
        super(Exchange.BULLISH, CODEC, BullishInboundContainer.class);
        this.ping(15000L, () -> PING);
        this.staleWindow(60000L);
        this.baseUri = baseUri;
    }

    public BullishStreamFactory() {
        this(PROD);
    }

    public static BullishStreamFactory create(URI uri) {
        return new BullishStreamFactory(uri);
    }

    public static BullishStreamFactory prod() {
        return new BullishStreamFactory();
    }

    @NonNull
    public BullishStreamFactory restClient(BullishRestClient client) {
        this.client = client;
        return this.me();
    }

    @Override
    protected BullishStreamFactory me() {
        return this;
    }

    public WebsocketConnection<BullishOutboundMessage<?>, BullishInboundContainer> createBboStream(@NonNull Credentials credentials) {
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
        return this.privateStream("market-data", credentials);
    }

    public WebsocketConnection<BullishOutboundMessage<?>, BullishInboundContainer> createBboStream() {
        return this.publicMarketData();
    }

    public WebsocketConnection<BullishOutboundMessage<?>, BullishInboundContainer> createOrderBookStream() {
        return this.publicMarketData();
    }

    public WebsocketConnection<BullishOutboundMessage<?>, BullishInboundContainer> createPublicTradesStream(String symbol) {
        String url = this.baseUri.toString() + "/trading-api/v1/market-data/trades/" + symbol;
        return this.newPublicWebsocket(URI.create(url), null);
    }

    public WebsocketConnection<BullishOutboundMessage<?>, BullishInboundContainer> createPrivateStream(@NonNull Credentials credentials) {
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
        return this.privateStream("private-data?tradingAccountId=" + credentials.getAccount(), credentials);
    }

    private WebsocketConnection<BullishOutboundMessage<?>, BullishInboundContainer> publicMarketData() {
        String url = this.baseUri.toString() + "/trading-api/v1/market-data/orderbook";
        return this.newPublicWebsocket(URI.create(url), null);
    }

    private WebsocketConnection<BullishOutboundMessage<?>, BullishInboundContainer> privateStream(String type, @NonNull Credentials credentials) {
        if (credentials == null) {
            throw new IllegalStateException("Credentials must be set to create a private websocket for Bullish");
        }
        if (this.client == null) {
            throw new IllegalStateException("A BullishRestClient must be set to create a private websocket for Bullish");
        }
        String url = this.baseUri.toString() + "/trading-api/v1/" + type;
        return this.newPrivateWebsocket(URI.create(url), headers2 -> {
            String jwtToken = Objects.requireNonNull(this.client.initOrGet(credentials).block()).getJwtToken();
            headers2.put("Cookie", List.of("JWT_COOKIE=" + jwtToken));
        });
    }
}

