/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.bullish.api.v2.lib;

import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonceGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonceGenerator.class);
    private AtomicLong series;
    private String lastGenerated;
    private String lastGeneratedMs;

    public NonceGenerator() {
        this.forceNonceReset();
    }

    public void forceNonceReset() {
        this.series = null;
        this.getSeries(true);
    }

    private AtomicLong getSeries(boolean force) {
        if (this.series == null || force) {
            Instant now = Instant.now();
            long nextNonce = now.getEpochSecond() * 1000000000L + (long)now.getNano();
            this.series = new AtomicLong(nextNonce / 1000L);
            this.series.incrementAndGet();
            LOGGER.debug("(Re)loaded nonce and chose nonce {}", (Object)this.series);
        }
        return this.series;
    }

    public String next() {
        this.lastGenerated = Long.toString(this.getSeries(false).getAndIncrement());
        this.lastGeneratedMs = Long.toString(Instant.now().toEpochMilli());
        return this.lastGenerated;
    }

    public String getLastGenerated() {
        return this.lastGenerated;
    }

    public String getLastGeneratedMs() {
        return this.lastGeneratedMs;
    }
}

