/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.bybit.api.v5.domain.request;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.types.Category;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.types.OrderFilter;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OrderQueryRequest {
    public static final int OPEN_ONLY = 0;
    public static final int ALL = 1;
    private Category category;
    private String symbol;
    private String baseCoin;
    private String settleCoin;
    private String orderId;
    private String orderLinkId;
    private OrderFilter orderFilter;
    private Integer openOnly;
    private Integer limit;
    private String cursor;

    OrderQueryRequest(Category category, String symbol, String baseCoin, String settleCoin, String orderId, String orderLinkId, OrderFilter orderFilter, Integer openOnly, Integer limit, String cursor) {
        this.category = category;
        this.symbol = symbol;
        this.baseCoin = baseCoin;
        this.settleCoin = settleCoin;
        this.orderId = orderId;
        this.orderLinkId = orderLinkId;
        this.orderFilter = orderFilter;
        this.openOnly = openOnly;
        this.limit = limit;
        this.cursor = cursor;
    }

    public static OrderQueryRequestBuilder builder() {
        return new OrderQueryRequestBuilder();
    }

    public Category getCategory() {
        return this.category;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getBaseCoin() {
        return this.baseCoin;
    }

    public String getSettleCoin() {
        return this.settleCoin;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getOrderLinkId() {
        return this.orderLinkId;
    }

    public OrderFilter getOrderFilter() {
        return this.orderFilter;
    }

    public Integer getOpenOnly() {
        return this.openOnly;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getCursor() {
        return this.cursor;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setBaseCoin(String baseCoin) {
        this.baseCoin = baseCoin;
    }

    public void setSettleCoin(String settleCoin) {
        this.settleCoin = settleCoin;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public void setOrderLinkId(String orderLinkId) {
        this.orderLinkId = orderLinkId;
    }

    public void setOrderFilter(OrderFilter orderFilter) {
        this.orderFilter = orderFilter;
    }

    public void setOpenOnly(Integer openOnly) {
        this.openOnly = openOnly;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderQueryRequest)) {
            return false;
        }
        OrderQueryRequest other = (OrderQueryRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$openOnly = this.getOpenOnly();
        Integer other$openOnly = other.getOpenOnly();
        if (this$openOnly == null ? other$openOnly != null : !((Object)this$openOnly).equals(other$openOnly)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Category this$category = this.getCategory();
        Category other$category = other.getCategory();
        if (this$category == null ? other$category != null : !((Object)((Object)this$category)).equals((Object)other$category)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
            return false;
        }
        String this$baseCoin = this.getBaseCoin();
        String other$baseCoin = other.getBaseCoin();
        if (this$baseCoin == null ? other$baseCoin != null : !this$baseCoin.equals(other$baseCoin)) {
            return false;
        }
        String this$settleCoin = this.getSettleCoin();
        String other$settleCoin = other.getSettleCoin();
        if (this$settleCoin == null ? other$settleCoin != null : !this$settleCoin.equals(other$settleCoin)) {
            return false;
        }
        String this$orderId = this.getOrderId();
        String other$orderId = other.getOrderId();
        if (this$orderId == null ? other$orderId != null : !this$orderId.equals(other$orderId)) {
            return false;
        }
        String this$orderLinkId = this.getOrderLinkId();
        String other$orderLinkId = other.getOrderLinkId();
        if (this$orderLinkId == null ? other$orderLinkId != null : !this$orderLinkId.equals(other$orderLinkId)) {
            return false;
        }
        OrderFilter this$orderFilter = this.getOrderFilter();
        OrderFilter other$orderFilter = other.getOrderFilter();
        if (this$orderFilter == null ? other$orderFilter != null : !((Object)((Object)this$orderFilter)).equals((Object)other$orderFilter)) {
            return false;
        }
        String this$cursor = this.getCursor();
        String other$cursor = other.getCursor();
        return !(this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderQueryRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $openOnly = this.getOpenOnly();
        result = result * 59 + ($openOnly == null ? 43 : ((Object)$openOnly).hashCode());
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Category $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : ((Object)((Object)$category)).hashCode());
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        String $baseCoin = this.getBaseCoin();
        result = result * 59 + ($baseCoin == null ? 43 : $baseCoin.hashCode());
        String $settleCoin = this.getSettleCoin();
        result = result * 59 + ($settleCoin == null ? 43 : $settleCoin.hashCode());
        String $orderId = this.getOrderId();
        result = result * 59 + ($orderId == null ? 43 : $orderId.hashCode());
        String $orderLinkId = this.getOrderLinkId();
        result = result * 59 + ($orderLinkId == null ? 43 : $orderLinkId.hashCode());
        OrderFilter $orderFilter = this.getOrderFilter();
        result = result * 59 + ($orderFilter == null ? 43 : ((Object)((Object)$orderFilter)).hashCode());
        String $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        return result;
    }

    public String toString() {
        return "OrderQueryRequest(category=" + this.getCategory() + ", symbol=" + this.getSymbol() + ", baseCoin=" + this.getBaseCoin() + ", settleCoin=" + this.getSettleCoin() + ", orderId=" + this.getOrderId() + ", orderLinkId=" + this.getOrderLinkId() + ", orderFilter=" + this.getOrderFilter() + ", openOnly=" + this.getOpenOnly() + ", limit=" + this.getLimit() + ", cursor=" + this.getCursor() + ")";
    }

    public static class OrderQueryRequestBuilder {
        private Category category;
        private String symbol;
        private String baseCoin;
        private String settleCoin;
        private String orderId;
        private String orderLinkId;
        private OrderFilter orderFilter;
        private Integer openOnly;
        private Integer limit;
        private String cursor;

        OrderQueryRequestBuilder() {
        }

        public OrderQueryRequestBuilder category(Category category) {
            this.category = category;
            return this;
        }

        public OrderQueryRequestBuilder symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        public OrderQueryRequestBuilder baseCoin(String baseCoin) {
            this.baseCoin = baseCoin;
            return this;
        }

        public OrderQueryRequestBuilder settleCoin(String settleCoin) {
            this.settleCoin = settleCoin;
            return this;
        }

        public OrderQueryRequestBuilder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public OrderQueryRequestBuilder orderLinkId(String orderLinkId) {
            this.orderLinkId = orderLinkId;
            return this;
        }

        public OrderQueryRequestBuilder orderFilter(OrderFilter orderFilter) {
            this.orderFilter = orderFilter;
            return this;
        }

        public OrderQueryRequestBuilder openOnly(Integer openOnly) {
            this.openOnly = openOnly;
            return this;
        }

        public OrderQueryRequestBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public OrderQueryRequestBuilder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public OrderQueryRequest build() {
            return new OrderQueryRequest(this.category, this.symbol, this.baseCoin, this.settleCoin, this.orderId, this.orderLinkId, this.orderFilter, this.openOnly, this.limit, this.cursor);
        }

        public String toString() {
            return "OrderQueryRequest.OrderQueryRequestBuilder(category=" + this.category + ", symbol=" + this.symbol + ", baseCoin=" + this.baseCoin + ", settleCoin=" + this.settleCoin + ", orderId=" + this.orderId + ", orderLinkId=" + this.orderLinkId + ", orderFilter=" + this.orderFilter + ", openOnly=" + this.openOnly + ", limit=" + this.limit + ", cursor=" + this.cursor + ")";
        }
    }
}

