/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.bybit.api.v5.domain.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import estonlabs.cxtl.exchanges.a.specification.domain.Order;
import estonlabs.cxtl.exchanges.a.specification.domain.SimpleOrderStatus;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.types.Category;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.types.CategoryDeserializer;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.types.OrderStatus;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.types.OrderStatusDeserializer;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.types.OrderType;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.types.OrderTypeDeserializer;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.types.Side;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.types.Tif;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class BybitOrder
implements Order {
    private String orderId;
    @JsonProperty(value="orderLinkId")
    private String clOrdId;
    private String blockTradeId;
    private String symbol;
    private Double price;
    private double qty;
    private Side side;
    private String isLeverage;
    private int positionIdx;
    @JsonDeserialize(using=OrderStatusDeserializer.class, contentAs=OrderStatus.class)
    private OrderStatus orderStatus;
    private String cancelType;
    private String rejectReason;
    private Double avgPrice;
    private Double leavesQty;
    private Double leavesValue;
    @JsonProperty(value="cumExecQty")
    private double cumQty;
    private Double cumExecValue;
    private Double cumExecFee;
    private Tif timeInForce;
    @JsonDeserialize(using=OrderTypeDeserializer.class, contentAs=OrderType.class)
    private OrderType orderType;
    private String stopOrderType;
    private String orderIv;
    private Double triggerPrice;
    private String takeProfit;
    private String stopLoss;
    private String tpslMode;
    private String tpLimitPrice;
    private String slLimitPrice;
    private String tpTriggerBy;
    private String slTriggerBy;
    private int triggerDirection;
    private String triggerBy;
    private String lastPriceOnCreated;
    private boolean reduceOnly;
    private boolean closeOnTrigger;
    private String placeType;
    private String smpType;
    private int smpGroup;
    private String smpOrderId;
    private long createdTime;
    private long updatedTime;
    @JsonDeserialize(using=CategoryDeserializer.class, contentAs=Category.class)
    private Category category;
    private String feeCurrency;

    @Override
    public Double getLastOrAvgPx() {
        return this.getAvgPrice();
    }

    @Override
    public SimpleOrderStatus getSimpleStatus() {
        return this.orderStatus.getSimpleOrderStatus();
    }

    @Override
    public String getOrderId() {
        return this.orderId;
    }

    @Override
    public String getClOrdId() {
        return this.clOrdId;
    }

    public String getBlockTradeId() {
        return this.blockTradeId;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public Double getPrice() {
        return this.price;
    }

    public double getQty() {
        return this.qty;
    }

    public Side getSide() {
        return this.side;
    }

    public String getIsLeverage() {
        return this.isLeverage;
    }

    public int getPositionIdx() {
        return this.positionIdx;
    }

    public OrderStatus getOrderStatus() {
        return this.orderStatus;
    }

    public String getCancelType() {
        return this.cancelType;
    }

    public String getRejectReason() {
        return this.rejectReason;
    }

    public Double getAvgPrice() {
        return this.avgPrice;
    }

    public Double getLeavesQty() {
        return this.leavesQty;
    }

    public Double getLeavesValue() {
        return this.leavesValue;
    }

    @Override
    public double getCumQty() {
        return this.cumQty;
    }

    public Double getCumExecValue() {
        return this.cumExecValue;
    }

    public Double getCumExecFee() {
        return this.cumExecFee;
    }

    public Tif getTimeInForce() {
        return this.timeInForce;
    }

    public OrderType getOrderType() {
        return this.orderType;
    }

    public String getStopOrderType() {
        return this.stopOrderType;
    }

    public String getOrderIv() {
        return this.orderIv;
    }

    public Double getTriggerPrice() {
        return this.triggerPrice;
    }

    public String getTakeProfit() {
        return this.takeProfit;
    }

    public String getStopLoss() {
        return this.stopLoss;
    }

    public String getTpslMode() {
        return this.tpslMode;
    }

    public String getTpLimitPrice() {
        return this.tpLimitPrice;
    }

    public String getSlLimitPrice() {
        return this.slLimitPrice;
    }

    public String getTpTriggerBy() {
        return this.tpTriggerBy;
    }

    public String getSlTriggerBy() {
        return this.slTriggerBy;
    }

    public int getTriggerDirection() {
        return this.triggerDirection;
    }

    public String getTriggerBy() {
        return this.triggerBy;
    }

    public String getLastPriceOnCreated() {
        return this.lastPriceOnCreated;
    }

    public boolean isReduceOnly() {
        return this.reduceOnly;
    }

    public boolean isCloseOnTrigger() {
        return this.closeOnTrigger;
    }

    public String getPlaceType() {
        return this.placeType;
    }

    public String getSmpType() {
        return this.smpType;
    }

    public int getSmpGroup() {
        return this.smpGroup;
    }

    public String getSmpOrderId() {
        return this.smpOrderId;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public long getUpdatedTime() {
        return this.updatedTime;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getFeeCurrency() {
        return this.feeCurrency;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    @JsonProperty(value="orderLinkId")
    public void setClOrdId(String clOrdId) {
        this.clOrdId = clOrdId;
    }

    public void setBlockTradeId(String blockTradeId) {
        this.blockTradeId = blockTradeId;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public void setQty(double qty) {
        this.qty = qty;
    }

    public void setSide(Side side) {
        this.side = side;
    }

    public void setIsLeverage(String isLeverage) {
        this.isLeverage = isLeverage;
    }

    public void setPositionIdx(int positionIdx) {
        this.positionIdx = positionIdx;
    }

    @JsonDeserialize(using=OrderStatusDeserializer.class, contentAs=OrderStatus.class)
    public void setOrderStatus(OrderStatus orderStatus) {
        this.orderStatus = orderStatus;
    }

    public void setCancelType(String cancelType) {
        this.cancelType = cancelType;
    }

    public void setRejectReason(String rejectReason) {
        this.rejectReason = rejectReason;
    }

    public void setAvgPrice(Double avgPrice) {
        this.avgPrice = avgPrice;
    }

    public void setLeavesQty(Double leavesQty) {
        this.leavesQty = leavesQty;
    }

    public void setLeavesValue(Double leavesValue) {
        this.leavesValue = leavesValue;
    }

    @JsonProperty(value="cumExecQty")
    public void setCumQty(double cumQty) {
        this.cumQty = cumQty;
    }

    public void setCumExecValue(Double cumExecValue) {
        this.cumExecValue = cumExecValue;
    }

    public void setCumExecFee(Double cumExecFee) {
        this.cumExecFee = cumExecFee;
    }

    public void setTimeInForce(Tif timeInForce) {
        this.timeInForce = timeInForce;
    }

    @JsonDeserialize(using=OrderTypeDeserializer.class, contentAs=OrderType.class)
    public void setOrderType(OrderType orderType) {
        this.orderType = orderType;
    }

    public void setStopOrderType(String stopOrderType) {
        this.stopOrderType = stopOrderType;
    }

    public void setOrderIv(String orderIv) {
        this.orderIv = orderIv;
    }

    public void setTriggerPrice(Double triggerPrice) {
        this.triggerPrice = triggerPrice;
    }

    public void setTakeProfit(String takeProfit) {
        this.takeProfit = takeProfit;
    }

    public void setStopLoss(String stopLoss) {
        this.stopLoss = stopLoss;
    }

    public void setTpslMode(String tpslMode) {
        this.tpslMode = tpslMode;
    }

    public void setTpLimitPrice(String tpLimitPrice) {
        this.tpLimitPrice = tpLimitPrice;
    }

    public void setSlLimitPrice(String slLimitPrice) {
        this.slLimitPrice = slLimitPrice;
    }

    public void setTpTriggerBy(String tpTriggerBy) {
        this.tpTriggerBy = tpTriggerBy;
    }

    public void setSlTriggerBy(String slTriggerBy) {
        this.slTriggerBy = slTriggerBy;
    }

    public void setTriggerDirection(int triggerDirection) {
        this.triggerDirection = triggerDirection;
    }

    public void setTriggerBy(String triggerBy) {
        this.triggerBy = triggerBy;
    }

    public void setLastPriceOnCreated(String lastPriceOnCreated) {
        this.lastPriceOnCreated = lastPriceOnCreated;
    }

    public void setReduceOnly(boolean reduceOnly) {
        this.reduceOnly = reduceOnly;
    }

    public void setCloseOnTrigger(boolean closeOnTrigger) {
        this.closeOnTrigger = closeOnTrigger;
    }

    public void setPlaceType(String placeType) {
        this.placeType = placeType;
    }

    public void setSmpType(String smpType) {
        this.smpType = smpType;
    }

    public void setSmpGroup(int smpGroup) {
        this.smpGroup = smpGroup;
    }

    public void setSmpOrderId(String smpOrderId) {
        this.smpOrderId = smpOrderId;
    }

    public void setCreatedTime(long createdTime) {
        this.createdTime = createdTime;
    }

    public void setUpdatedTime(long updatedTime) {
        this.updatedTime = updatedTime;
    }

    @JsonDeserialize(using=CategoryDeserializer.class, contentAs=Category.class)
    public void setCategory(Category category) {
        this.category = category;
    }

    public void setFeeCurrency(String feeCurrency) {
        this.feeCurrency = feeCurrency;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BybitOrder)) {
            return false;
        }
        BybitOrder other = (BybitOrder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getQty(), other.getQty()) != 0) {
            return false;
        }
        if (this.getPositionIdx() != other.getPositionIdx()) {
            return false;
        }
        if (Double.compare(this.getCumQty(), other.getCumQty()) != 0) {
            return false;
        }
        if (this.getTriggerDirection() != other.getTriggerDirection()) {
            return false;
        }
        if (this.isReduceOnly() != other.isReduceOnly()) {
            return false;
        }
        if (this.isCloseOnTrigger() != other.isCloseOnTrigger()) {
            return false;
        }
        if (this.getSmpGroup() != other.getSmpGroup()) {
            return false;
        }
        if (this.getCreatedTime() != other.getCreatedTime()) {
            return false;
        }
        if (this.getUpdatedTime() != other.getUpdatedTime()) {
            return false;
        }
        Double this$price = this.getPrice();
        Double other$price = other.getPrice();
        if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
            return false;
        }
        Double this$avgPrice = this.getAvgPrice();
        Double other$avgPrice = other.getAvgPrice();
        if (this$avgPrice == null ? other$avgPrice != null : !((Object)this$avgPrice).equals(other$avgPrice)) {
            return false;
        }
        Double this$leavesQty = this.getLeavesQty();
        Double other$leavesQty = other.getLeavesQty();
        if (this$leavesQty == null ? other$leavesQty != null : !((Object)this$leavesQty).equals(other$leavesQty)) {
            return false;
        }
        Double this$leavesValue = this.getLeavesValue();
        Double other$leavesValue = other.getLeavesValue();
        if (this$leavesValue == null ? other$leavesValue != null : !((Object)this$leavesValue).equals(other$leavesValue)) {
            return false;
        }
        Double this$cumExecValue = this.getCumExecValue();
        Double other$cumExecValue = other.getCumExecValue();
        if (this$cumExecValue == null ? other$cumExecValue != null : !((Object)this$cumExecValue).equals(other$cumExecValue)) {
            return false;
        }
        Double this$cumExecFee = this.getCumExecFee();
        Double other$cumExecFee = other.getCumExecFee();
        if (this$cumExecFee == null ? other$cumExecFee != null : !((Object)this$cumExecFee).equals(other$cumExecFee)) {
            return false;
        }
        Double this$triggerPrice = this.getTriggerPrice();
        Double other$triggerPrice = other.getTriggerPrice();
        if (this$triggerPrice == null ? other$triggerPrice != null : !((Object)this$triggerPrice).equals(other$triggerPrice)) {
            return false;
        }
        String this$orderId = this.getOrderId();
        String other$orderId = other.getOrderId();
        if (this$orderId == null ? other$orderId != null : !this$orderId.equals(other$orderId)) {
            return false;
        }
        String this$clOrdId = this.getClOrdId();
        String other$clOrdId = other.getClOrdId();
        if (this$clOrdId == null ? other$clOrdId != null : !this$clOrdId.equals(other$clOrdId)) {
            return false;
        }
        String this$blockTradeId = this.getBlockTradeId();
        String other$blockTradeId = other.getBlockTradeId();
        if (this$blockTradeId == null ? other$blockTradeId != null : !this$blockTradeId.equals(other$blockTradeId)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
            return false;
        }
        Side this$side = this.getSide();
        Side other$side = other.getSide();
        if (this$side == null ? other$side != null : !((Object)((Object)this$side)).equals((Object)other$side)) {
            return false;
        }
        String this$isLeverage = this.getIsLeverage();
        String other$isLeverage = other.getIsLeverage();
        if (this$isLeverage == null ? other$isLeverage != null : !this$isLeverage.equals(other$isLeverage)) {
            return false;
        }
        OrderStatus this$orderStatus = this.getOrderStatus();
        OrderStatus other$orderStatus = other.getOrderStatus();
        if (this$orderStatus == null ? other$orderStatus != null : !((Object)((Object)this$orderStatus)).equals((Object)other$orderStatus)) {
            return false;
        }
        String this$cancelType = this.getCancelType();
        String other$cancelType = other.getCancelType();
        if (this$cancelType == null ? other$cancelType != null : !this$cancelType.equals(other$cancelType)) {
            return false;
        }
        String this$rejectReason = this.getRejectReason();
        String other$rejectReason = other.getRejectReason();
        if (this$rejectReason == null ? other$rejectReason != null : !this$rejectReason.equals(other$rejectReason)) {
            return false;
        }
        Tif this$timeInForce = this.getTimeInForce();
        Tif other$timeInForce = other.getTimeInForce();
        if (this$timeInForce == null ? other$timeInForce != null : !((Object)((Object)this$timeInForce)).equals((Object)other$timeInForce)) {
            return false;
        }
        OrderType this$orderType = this.getOrderType();
        OrderType other$orderType = other.getOrderType();
        if (this$orderType == null ? other$orderType != null : !((Object)((Object)this$orderType)).equals((Object)other$orderType)) {
            return false;
        }
        String this$stopOrderType = this.getStopOrderType();
        String other$stopOrderType = other.getStopOrderType();
        if (this$stopOrderType == null ? other$stopOrderType != null : !this$stopOrderType.equals(other$stopOrderType)) {
            return false;
        }
        String this$orderIv = this.getOrderIv();
        String other$orderIv = other.getOrderIv();
        if (this$orderIv == null ? other$orderIv != null : !this$orderIv.equals(other$orderIv)) {
            return false;
        }
        String this$takeProfit = this.getTakeProfit();
        String other$takeProfit = other.getTakeProfit();
        if (this$takeProfit == null ? other$takeProfit != null : !this$takeProfit.equals(other$takeProfit)) {
            return false;
        }
        String this$stopLoss = this.getStopLoss();
        String other$stopLoss = other.getStopLoss();
        if (this$stopLoss == null ? other$stopLoss != null : !this$stopLoss.equals(other$stopLoss)) {
            return false;
        }
        String this$tpslMode = this.getTpslMode();
        String other$tpslMode = other.getTpslMode();
        if (this$tpslMode == null ? other$tpslMode != null : !this$tpslMode.equals(other$tpslMode)) {
            return false;
        }
        String this$tpLimitPrice = this.getTpLimitPrice();
        String other$tpLimitPrice = other.getTpLimitPrice();
        if (this$tpLimitPrice == null ? other$tpLimitPrice != null : !this$tpLimitPrice.equals(other$tpLimitPrice)) {
            return false;
        }
        String this$slLimitPrice = this.getSlLimitPrice();
        String other$slLimitPrice = other.getSlLimitPrice();
        if (this$slLimitPrice == null ? other$slLimitPrice != null : !this$slLimitPrice.equals(other$slLimitPrice)) {
            return false;
        }
        String this$tpTriggerBy = this.getTpTriggerBy();
        String other$tpTriggerBy = other.getTpTriggerBy();
        if (this$tpTriggerBy == null ? other$tpTriggerBy != null : !this$tpTriggerBy.equals(other$tpTriggerBy)) {
            return false;
        }
        String this$slTriggerBy = this.getSlTriggerBy();
        String other$slTriggerBy = other.getSlTriggerBy();
        if (this$slTriggerBy == null ? other$slTriggerBy != null : !this$slTriggerBy.equals(other$slTriggerBy)) {
            return false;
        }
        String this$triggerBy = this.getTriggerBy();
        String other$triggerBy = other.getTriggerBy();
        if (this$triggerBy == null ? other$triggerBy != null : !this$triggerBy.equals(other$triggerBy)) {
            return false;
        }
        String this$lastPriceOnCreated = this.getLastPriceOnCreated();
        String other$lastPriceOnCreated = other.getLastPriceOnCreated();
        if (this$lastPriceOnCreated == null ? other$lastPriceOnCreated != null : !this$lastPriceOnCreated.equals(other$lastPriceOnCreated)) {
            return false;
        }
        String this$placeType = this.getPlaceType();
        String other$placeType = other.getPlaceType();
        if (this$placeType == null ? other$placeType != null : !this$placeType.equals(other$placeType)) {
            return false;
        }
        String this$smpType = this.getSmpType();
        String other$smpType = other.getSmpType();
        if (this$smpType == null ? other$smpType != null : !this$smpType.equals(other$smpType)) {
            return false;
        }
        String this$smpOrderId = this.getSmpOrderId();
        String other$smpOrderId = other.getSmpOrderId();
        if (this$smpOrderId == null ? other$smpOrderId != null : !this$smpOrderId.equals(other$smpOrderId)) {
            return false;
        }
        Category this$category = this.getCategory();
        Category other$category = other.getCategory();
        if (this$category == null ? other$category != null : !((Object)((Object)this$category)).equals((Object)other$category)) {
            return false;
        }
        String this$feeCurrency = this.getFeeCurrency();
        String other$feeCurrency = other.getFeeCurrency();
        return !(this$feeCurrency == null ? other$feeCurrency != null : !this$feeCurrency.equals(other$feeCurrency));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BybitOrder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $qty = Double.doubleToLongBits(this.getQty());
        result = result * 59 + (int)($qty >>> 32 ^ $qty);
        result = result * 59 + this.getPositionIdx();
        long $cumQty = Double.doubleToLongBits(this.getCumQty());
        result = result * 59 + (int)($cumQty >>> 32 ^ $cumQty);
        result = result * 59 + this.getTriggerDirection();
        result = result * 59 + (this.isReduceOnly() ? 79 : 97);
        result = result * 59 + (this.isCloseOnTrigger() ? 79 : 97);
        result = result * 59 + this.getSmpGroup();
        long $createdTime = this.getCreatedTime();
        result = result * 59 + (int)($createdTime >>> 32 ^ $createdTime);
        long $updatedTime = this.getUpdatedTime();
        result = result * 59 + (int)($updatedTime >>> 32 ^ $updatedTime);
        Double $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        Double $avgPrice = this.getAvgPrice();
        result = result * 59 + ($avgPrice == null ? 43 : ((Object)$avgPrice).hashCode());
        Double $leavesQty = this.getLeavesQty();
        result = result * 59 + ($leavesQty == null ? 43 : ((Object)$leavesQty).hashCode());
        Double $leavesValue = this.getLeavesValue();
        result = result * 59 + ($leavesValue == null ? 43 : ((Object)$leavesValue).hashCode());
        Double $cumExecValue = this.getCumExecValue();
        result = result * 59 + ($cumExecValue == null ? 43 : ((Object)$cumExecValue).hashCode());
        Double $cumExecFee = this.getCumExecFee();
        result = result * 59 + ($cumExecFee == null ? 43 : ((Object)$cumExecFee).hashCode());
        Double $triggerPrice = this.getTriggerPrice();
        result = result * 59 + ($triggerPrice == null ? 43 : ((Object)$triggerPrice).hashCode());
        String $orderId = this.getOrderId();
        result = result * 59 + ($orderId == null ? 43 : $orderId.hashCode());
        String $clOrdId = this.getClOrdId();
        result = result * 59 + ($clOrdId == null ? 43 : $clOrdId.hashCode());
        String $blockTradeId = this.getBlockTradeId();
        result = result * 59 + ($blockTradeId == null ? 43 : $blockTradeId.hashCode());
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        Side $side = this.getSide();
        result = result * 59 + ($side == null ? 43 : ((Object)((Object)$side)).hashCode());
        String $isLeverage = this.getIsLeverage();
        result = result * 59 + ($isLeverage == null ? 43 : $isLeverage.hashCode());
        OrderStatus $orderStatus = this.getOrderStatus();
        result = result * 59 + ($orderStatus == null ? 43 : ((Object)((Object)$orderStatus)).hashCode());
        String $cancelType = this.getCancelType();
        result = result * 59 + ($cancelType == null ? 43 : $cancelType.hashCode());
        String $rejectReason = this.getRejectReason();
        result = result * 59 + ($rejectReason == null ? 43 : $rejectReason.hashCode());
        Tif $timeInForce = this.getTimeInForce();
        result = result * 59 + ($timeInForce == null ? 43 : ((Object)((Object)$timeInForce)).hashCode());
        OrderType $orderType = this.getOrderType();
        result = result * 59 + ($orderType == null ? 43 : ((Object)((Object)$orderType)).hashCode());
        String $stopOrderType = this.getStopOrderType();
        result = result * 59 + ($stopOrderType == null ? 43 : $stopOrderType.hashCode());
        String $orderIv = this.getOrderIv();
        result = result * 59 + ($orderIv == null ? 43 : $orderIv.hashCode());
        String $takeProfit = this.getTakeProfit();
        result = result * 59 + ($takeProfit == null ? 43 : $takeProfit.hashCode());
        String $stopLoss = this.getStopLoss();
        result = result * 59 + ($stopLoss == null ? 43 : $stopLoss.hashCode());
        String $tpslMode = this.getTpslMode();
        result = result * 59 + ($tpslMode == null ? 43 : $tpslMode.hashCode());
        String $tpLimitPrice = this.getTpLimitPrice();
        result = result * 59 + ($tpLimitPrice == null ? 43 : $tpLimitPrice.hashCode());
        String $slLimitPrice = this.getSlLimitPrice();
        result = result * 59 + ($slLimitPrice == null ? 43 : $slLimitPrice.hashCode());
        String $tpTriggerBy = this.getTpTriggerBy();
        result = result * 59 + ($tpTriggerBy == null ? 43 : $tpTriggerBy.hashCode());
        String $slTriggerBy = this.getSlTriggerBy();
        result = result * 59 + ($slTriggerBy == null ? 43 : $slTriggerBy.hashCode());
        String $triggerBy = this.getTriggerBy();
        result = result * 59 + ($triggerBy == null ? 43 : $triggerBy.hashCode());
        String $lastPriceOnCreated = this.getLastPriceOnCreated();
        result = result * 59 + ($lastPriceOnCreated == null ? 43 : $lastPriceOnCreated.hashCode());
        String $placeType = this.getPlaceType();
        result = result * 59 + ($placeType == null ? 43 : $placeType.hashCode());
        String $smpType = this.getSmpType();
        result = result * 59 + ($smpType == null ? 43 : $smpType.hashCode());
        String $smpOrderId = this.getSmpOrderId();
        result = result * 59 + ($smpOrderId == null ? 43 : $smpOrderId.hashCode());
        Category $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : ((Object)((Object)$category)).hashCode());
        String $feeCurrency = this.getFeeCurrency();
        result = result * 59 + ($feeCurrency == null ? 43 : $feeCurrency.hashCode());
        return result;
    }

    public String toString() {
        return "BybitOrder(orderId=" + this.getOrderId() + ", clOrdId=" + this.getClOrdId() + ", blockTradeId=" + this.getBlockTradeId() + ", symbol=" + this.getSymbol() + ", price=" + this.getPrice() + ", qty=" + this.getQty() + ", side=" + this.getSide() + ", isLeverage=" + this.getIsLeverage() + ", positionIdx=" + this.getPositionIdx() + ", orderStatus=" + this.getOrderStatus() + ", cancelType=" + this.getCancelType() + ", rejectReason=" + this.getRejectReason() + ", avgPrice=" + this.getAvgPrice() + ", leavesQty=" + this.getLeavesQty() + ", leavesValue=" + this.getLeavesValue() + ", cumQty=" + this.getCumQty() + ", cumExecValue=" + this.getCumExecValue() + ", cumExecFee=" + this.getCumExecFee() + ", timeInForce=" + this.getTimeInForce() + ", orderType=" + this.getOrderType() + ", stopOrderType=" + this.getStopOrderType() + ", orderIv=" + this.getOrderIv() + ", triggerPrice=" + this.getTriggerPrice() + ", takeProfit=" + this.getTakeProfit() + ", stopLoss=" + this.getStopLoss() + ", tpslMode=" + this.getTpslMode() + ", tpLimitPrice=" + this.getTpLimitPrice() + ", slLimitPrice=" + this.getSlLimitPrice() + ", tpTriggerBy=" + this.getTpTriggerBy() + ", slTriggerBy=" + this.getSlTriggerBy() + ", triggerDirection=" + this.getTriggerDirection() + ", triggerBy=" + this.getTriggerBy() + ", lastPriceOnCreated=" + this.getLastPriceOnCreated() + ", reduceOnly=" + this.isReduceOnly() + ", closeOnTrigger=" + this.isCloseOnTrigger() + ", placeType=" + this.getPlaceType() + ", smpType=" + this.getSmpType() + ", smpGroup=" + this.getSmpGroup() + ", smpOrderId=" + this.getSmpOrderId() + ", createdTime=" + this.getCreatedTime() + ", updatedTime=" + this.getUpdatedTime() + ", category=" + this.getCategory() + ", feeCurrency=" + this.getFeeCurrency() + ")";
    }
}

