/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.bybit.api.v5.domain.stream;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import estonlabs.cxtl.common.stream.managed.OutboundMessage;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ByBitOutboundMessage
implements OutboundMessage {
    @JsonIgnore
    @NonNull
    protected OutboundMessage.MessageType messageType;
    private String reqId;
    private String op;
    private List<Object> args;

    public ByBitOutboundMessage(@NonNull OutboundMessage.MessageType messageType) {
        if (messageType == null) {
            throw new NullPointerException("messageType is marked non-null but is null");
        }
        this.messageType = messageType;
        if (messageType == OutboundMessage.MessageType.LOGON) {
            this.op = "auth";
        } else if (messageType == OutboundMessage.MessageType.PING) {
            this.op = "ping";
        } else if (messageType == OutboundMessage.MessageType.SUBSCRIPTION) {
            this.op = "subscribe";
        } else if (messageType == OutboundMessage.MessageType.UNSUBSCRIBE) {
            this.op = "unsubscribe";
        }
    }

    public static ByBitOutboundMessage subscribe(String topic) {
        return ByBitOutboundMessage.request(OutboundMessage.MessageType.SUBSCRIPTION, List.of(topic));
    }

    public static ByBitOutboundMessage subscribe(Object ... topics) {
        return ByBitOutboundMessage.request(OutboundMessage.MessageType.SUBSCRIPTION, Arrays.stream(topics).toList());
    }

    public static ByBitOutboundMessage unsubscribe(String topic) {
        return ByBitOutboundMessage.request(OutboundMessage.MessageType.UNSUBSCRIBE, List.of(topic));
    }

    public static ByBitOutboundMessage request(OutboundMessage.MessageType type, String ... topics) {
        ByBitOutboundMessage request = new ByBitOutboundMessage(type);
        request.setArgs(List.of(topics));
        return request;
    }

    public static ByBitOutboundMessage request(OutboundMessage.MessageType type, List<Object> topics) {
        ByBitOutboundMessage request = new ByBitOutboundMessage(type);
        request.setArgs(topics);
        return request;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ByBitOutboundMessage)) {
            return false;
        }
        ByBitOutboundMessage other = (ByBitOutboundMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OutboundMessage.MessageType this$messageType = this.getMessageType();
        OutboundMessage.MessageType other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !((Object)((Object)this$messageType)).equals((Object)other$messageType)) {
            return false;
        }
        String this$reqId = this.getReqId();
        String other$reqId = other.getReqId();
        if (this$reqId == null ? other$reqId != null : !this$reqId.equals(other$reqId)) {
            return false;
        }
        String this$op = this.getOp();
        String other$op = other.getOp();
        if (this$op == null ? other$op != null : !this$op.equals(other$op)) {
            return false;
        }
        List<Object> this$args = this.getArgs();
        List<Object> other$args = other.getArgs();
        return !(this$args == null ? other$args != null : !((Object)this$args).equals(other$args));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ByBitOutboundMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OutboundMessage.MessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : ((Object)((Object)$messageType)).hashCode());
        String $reqId = this.getReqId();
        result = result * 59 + ($reqId == null ? 43 : $reqId.hashCode());
        String $op = this.getOp();
        result = result * 59 + ($op == null ? 43 : $op.hashCode());
        List<Object> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        return result;
    }

    @Override
    @NonNull
    public OutboundMessage.MessageType getMessageType() {
        return this.messageType;
    }

    public String getReqId() {
        return this.reqId;
    }

    public String getOp() {
        return this.op;
    }

    public List<Object> getArgs() {
        return this.args;
    }

    @JsonIgnore
    public void setMessageType(@NonNull OutboundMessage.MessageType messageType) {
        if (messageType == null) {
            throw new NullPointerException("messageType is marked non-null but is null");
        }
        this.messageType = messageType;
    }

    public void setReqId(String reqId) {
        this.reqId = reqId;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public void setArgs(List<Object> args2) {
        this.args = args2;
    }

    public String toString() {
        return "ByBitOutboundMessage(super=" + super.toString() + ", messageType=" + this.getMessageType() + ", reqId=" + this.getReqId() + ", op=" + this.getOp() + ", args=" + this.getArgs() + ")";
    }
}

