/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.bybit.api.v5.domain.stream;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.common.stream.managed.AbstractInboundMessage;
import estonlabs.cxtl.common.stream.managed.InboundMessage;
import estonlabs.cxtl.common.stream.managed.MarketData;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class MarketDataMessage
extends AbstractInboundMessage
implements MarketData {
    private String topic;
    private String type;
    private long ts;
    private Quote data;
    @JsonIgnore
    private final boolean isSnapshot;

    public MarketDataMessage(boolean isSnapshot) {
        super(InboundMessage.MessageType.DATA);
        this.isSnapshot = isSnapshot;
    }

    @Override
    @JsonIgnore
    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    @Override
    public boolean hasData() {
        return this.data != null;
    }

    @Override
    public Long getSeqNo() {
        return this.data.u;
    }

    @Override
    public Long getTimestamp() {
        return this.ts;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    public String getType() {
        return this.type;
    }

    public long getTs() {
        return this.ts;
    }

    public Quote getData() {
        return this.data;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setTs(long ts) {
        this.ts = ts;
    }

    public void setData(Quote data) {
        this.data = data;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MarketDataMessage)) {
            return false;
        }
        MarketDataMessage other = (MarketDataMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getTs() != other.getTs()) {
            return false;
        }
        if (this.isSnapshot() != other.isSnapshot()) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Quote this$data = this.getData();
        Quote other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MarketDataMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $ts = this.getTs();
        result = result * 59 + (int)($ts >>> 32 ^ $ts);
        result = result * 59 + (this.isSnapshot() ? 79 : 97);
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Quote $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MarketDataMessage(super=" + super.toString() + ", topic=" + this.getTopic() + ", type=" + this.getType() + ", ts=" + this.getTs() + ", data=" + this.getData() + ", isSnapshot=" + this.isSnapshot() + ")";
    }

    public static class Quote {
        @JsonProperty(value="s")
        private String s;
        @JsonProperty(value="b")
        private List<Double[]> bids;
        @JsonProperty(value="a")
        private List<Double[]> asks;
        @JsonProperty(value="u")
        private int u;
        @JsonProperty(value="seq")
        private long seq;

        public String getS() {
            return this.s;
        }

        public List<Double[]> getBids() {
            return this.bids;
        }

        public List<Double[]> getAsks() {
            return this.asks;
        }

        public int getU() {
            return this.u;
        }

        public long getSeq() {
            return this.seq;
        }

        @JsonProperty(value="s")
        public void setS(String s) {
            this.s = s;
        }

        @JsonProperty(value="b")
        public void setBids(List<Double[]> bids) {
            this.bids = bids;
        }

        @JsonProperty(value="a")
        public void setAsks(List<Double[]> asks) {
            this.asks = asks;
        }

        @JsonProperty(value="u")
        public void setU(int u) {
            this.u = u;
        }

        @JsonProperty(value="seq")
        public void setSeq(long seq) {
            this.seq = seq;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Quote)) {
                return false;
            }
            Quote other = (Quote)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getU() != other.getU()) {
                return false;
            }
            if (this.getSeq() != other.getSeq()) {
                return false;
            }
            String this$s = this.getS();
            String other$s = other.getS();
            if (this$s == null ? other$s != null : !this$s.equals(other$s)) {
                return false;
            }
            List<Double[]> this$bids = this.getBids();
            List<Double[]> other$bids = other.getBids();
            if (this$bids == null ? other$bids != null : !((Object)this$bids).equals(other$bids)) {
                return false;
            }
            List<Double[]> this$asks = this.getAsks();
            List<Double[]> other$asks = other.getAsks();
            return !(this$asks == null ? other$asks != null : !((Object)this$asks).equals(other$asks));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Quote;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getU();
            long $seq = this.getSeq();
            result = result * 59 + (int)($seq >>> 32 ^ $seq);
            String $s = this.getS();
            result = result * 59 + ($s == null ? 43 : $s.hashCode());
            List<Double[]> $bids = this.getBids();
            result = result * 59 + ($bids == null ? 43 : ((Object)$bids).hashCode());
            List<Double[]> $asks = this.getAsks();
            result = result * 59 + ($asks == null ? 43 : ((Object)$asks).hashCode());
            return result;
        }

        public String toString() {
            return "MarketDataMessage.Quote(s=" + this.getS() + ", bids=" + this.getBids() + ", asks=" + this.getAsks() + ", u=" + this.getU() + ", seq=" + this.getSeq() + ")";
        }

        public Quote() {
        }

        public Quote(String s, List<Double[]> bids, List<Double[]> asks, int u, long seq) {
            this.s = s;
            this.bids = bids;
            this.asks = asks;
            this.u = u;
            this.seq = seq;
        }
    }
}

