/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.bybit.api.v5.lib;

import estonlabs.cxtl.common.AbstractExchangeFactory;
import estonlabs.cxtl.common.EnvironmentType;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.request.CancelRequest;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.request.OrderQueryRequest;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.request.OrderRequest;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.response.Instrument;
import estonlabs.cxtl.exchanges.bybit.api.v5.lib.BybitRestClient;
import java.net.Proxy;
import java.net.URI;
import java.util.List;
import java.util.Map;

public class BybitExchangeFactory
extends AbstractExchangeFactory<OrderRequest, CancelRequest, OrderQueryRequest, Object, Instrument, BybitRestClient, BybitExchangeFactory> {
    public static final URI PROD = URI.create("https://api.bybit.com/v5");
    public static final URI TEST_NET = URI.create("https://api-testnet.bybit.com/v5");
    private static final Map<EnvironmentType, List<URI>> ENVIRONMENTS = Map.of(EnvironmentType.PROD, List.of(PROD), EnvironmentType.TEST_NET, List.of(TEST_NET));
    private final URI baseUri;

    public BybitExchangeFactory(URI baseUri) {
        super(Exchange.BYBIT, ENVIRONMENTS);
        this.baseUri = baseUri;
    }

    @Override
    public BybitRestClient buildCex() {
        return this.buildCex(this.httpProxy);
    }

    @Override
    public BybitRestClient buildCex(Proxy httpProxy) {
        return new BybitRestClient(this.createJsonRestClient(this.baseUri, httpProxy), this.metricsLogger, Long.toString(this.receiveWindow == null ? 5000L : this.receiveWindow), this.brokerId);
    }

    @Override
    protected BybitExchangeFactory me() {
        return this;
    }

    @Override
    public BybitRestClient buildEdi() {
        return this.buildCex();
    }

    @Override
    public BybitRestClient buildEdi(Proxy httpProxy) {
        return this.buildCex(httpProxy);
    }
}

