/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.bybit.api.v5.lib;

import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.common.exception.CxtlApiException;
import estonlabs.cxtl.common.exception.ErrorCode;
import estonlabs.cxtl.common.http.Event;
import estonlabs.cxtl.common.http.JsonRestClient;
import estonlabs.cxtl.common.http.MetricsLogger;
import estonlabs.cxtl.common.http.RestClient;
import estonlabs.cxtl.common.security.HmacUtils;
import estonlabs.cxtl.exchanges.a.specification.domain.AssetClass;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.a.specification.domain.Olhcv;
import estonlabs.cxtl.exchanges.a.specification.domain.Trade;
import estonlabs.cxtl.exchanges.a.specification.lib.Cex;
import estonlabs.cxtl.exchanges.a.specification.lib.ExchangeDataInterface;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.request.AssetInfoRequest;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.request.CancelRequest;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.request.OrderQueryRequest;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.request.OrderRequest;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.request.TickerRequest;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.request.TradeQueryRequest;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.response.AckResponse;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.response.ApiResponse;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.response.AssetInfo;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.response.AssetInfoResponse;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.response.BybitAck;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.response.BybitOrder;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.response.BybitTrade;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.response.Instrument;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.response.LatestTradesResponse;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.response.ListResponse;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.response.OrderList;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.response.OrderListResponse;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.response.TickerListResponse;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.types.Category;
import java.net.Proxy;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class BybitRestClient
implements Cex<OrderRequest, CancelRequest, OrderQueryRequest>,
ExchangeDataInterface<Instrument, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BybitRestClient.class);
    private final RestClientAdapter client;

    public BybitRestClient(JsonRestClient client, MetricsLogger metricsLogger, String receiveWindow, String brokerId) {
        this.client = new RestClientAdapter(client, metricsLogger, receiveWindow, brokerId);
    }

    @Override
    public Proxy getProxy() {
        return this.client.client.getProxy();
    }

    @Override
    public Exchange getExchange() {
        return Exchange.BYBIT;
    }

    @Override
    public Mono<? extends List<? extends Trade>> getLatestPublicTrades(AssetClass assetClass, String symbol) {
        return this.getLatestPublicTrades(assetClass, symbol, null);
    }

    public Mono<List<BybitTrade>> getLatestPublicTrades(AssetClass assetClass, String symbol, Integer limit) {
        TradeQueryRequest req = TradeQueryRequest.builder().symbol(symbol).category(Category.from(assetClass)).limit(limit).build();
        return this.client.get("/market/recent-trade", req, LatestTradesResponse.class).map(ListResponse::getList).switchIfEmpty(Mono.just(List.of()));
    }

    @Override
    public AssetClass[] getSupportedAssetClasses() {
        return new AssetClass[]{AssetClass.SPOT, AssetClass.PERP, AssetClass.PERP_INVERSE};
    }

    @Override
    public Mono<? extends List<? extends Olhcv>> getOlhcv(Object request) {
        return Mono.empty();
    }

    @Override
    public Mono<Map<AssetClass, List<Instrument>>> getTickers() {
        return Mono.zip(this.getTickers(AssetClass.SPOT), this.getTickers(AssetClass.PERP), this.getTickers(AssetClass.PERP_INVERSE)).map(tuple -> Map.of(AssetClass.SPOT, (List)tuple.getT1(), AssetClass.PERP, (List)tuple.getT2(), AssetClass.PERP_INVERSE, (List)tuple.getT3()));
    }

    public Mono<List<Instrument>> getTickers(AssetClass assetClass) {
        TickerRequest req = TickerRequest.builder().category(Category.from(assetClass)).build();
        return this.client.get("/market/instruments-info", req, TickerListResponse.class).map(ListResponse::getList).switchIfEmpty(Mono.just(List.of())).doOnError(e -> LOGGER.error("Failed to get tickers", (Throwable)e));
    }

    @Override
    @NotNull
    public Mono<BybitAck> placeOrder(@NotNull Credentials credentials, @NotNull OrderRequest order) {
        return this.client.post(credentials, "/order/create", order, AckResponse.class);
    }

    @Override
    @NotNull
    public Mono<BybitAck> cancelOrder(@NotNull Credentials credentials, @NotNull CancelRequest request) {
        return this.client.post(credentials, "/order/cancel", request, AckResponse.class);
    }

    @Override
    @NotNull
    public Mono<List<BybitOrder>> getOrders(@NotNull Credentials credentials, OrderQueryRequest orderQueryRequest) {
        return this.fetchOrders(credentials, orderQueryRequest).map(ListResponse::getList).switchIfEmpty(Mono.just(List.of()));
    }

    @Override
    public Mono<? extends BybitOrder> getOrder(Credentials credentials, OrderQueryRequest orderQuery) {
        return this.getOrders(credentials, orderQuery).map(orders -> orders.isEmpty() ? null : (BybitOrder)orders.get(0));
    }

    public Mono<OrderList> getRecentOrders(Credentials credentials, OrderQueryRequest query) {
        return this.fetchOrders(credentials, query, "/order/realtime").onErrorResume(e -> Mono.empty()).filter(l -> l != null && !l.getList().isEmpty()).switchIfEmpty(Mono.empty());
    }

    public Mono<OrderList> getHistoricalOrders(Credentials credentials, OrderQueryRequest query) {
        return this.fetchOrders(credentials, query, "/order/history");
    }

    public Mono<OrderList> fetchOrders(Credentials credentials, OrderQueryRequest query) {
        return this.getRecentOrders(credentials, query).switchIfEmpty(Mono.defer(() -> {
            if (query.getOpenOnly() != null && query.getOpenOnly().equals(0)) {
                return Mono.empty();
            }
            return this.getHistoricalOrders(credentials, query);
        }));
    }

    private Mono<OrderList> fetchOrders(Credentials credentials, OrderQueryRequest query, String path) {
        return this.client.get(credentials, path, query, OrderListResponse.class);
    }

    public Mono<AssetInfo> getAssets(Credentials credentials, AssetInfoRequest request) {
        return this.client.get(credentials, "/account/wallet-balance", request, AssetInfoResponse.class);
    }

    private static ErrorCode errorCode(int code) {
        return switch (code) {
            case 170131 -> ErrorCode.INSUFFICIENT_BALANCE;
            case 170132, 170133 -> ErrorCode.BAD_PX;
            case 170124, 170135, 170136, 170137, 170140 -> ErrorCode.INVALID_QTY;
            case 170121 -> ErrorCode.INVALID_SYMBOL;
            case 110001, 170213 -> ErrorCode.UNKNOWN_ORDER;
            default -> ErrorCode.UNKNOWN_ERROR;
        };
    }

    public static class RestClientAdapter {
        private final RestClient client;
        private final MetricsLogger metricsLogger;
        private final String receiveWindow;
        private final String brokerId;

        public RestClientAdapter(RestClient client, MetricsLogger metricsLogger, String receiveWindow, String brokerId) {
            this.client = client;
            this.metricsLogger = metricsLogger;
            this.receiveWindow = receiveWindow;
            this.brokerId = brokerId;
        }

        public <IN, OUT, RESPONSE extends ApiResponse<OUT>> Mono<OUT> get(String path, IN request, Class<RESPONSE> type) {
            return this.client.get(path, request, type).flatMap(this::handleResponse);
        }

        public <IN, OUT, RESPONSE extends ApiResponse<OUT>> Mono<OUT> get(Credentials credentials, String path, IN request, Class<RESPONSE> type) {
            return this.client.get((Request.Builder builder, String json) -> this.addHeaders(credentials, builder, json), path, request, type).flatMap(this::handleResponse);
        }

        public <IN, OUT, RESPONSE extends ApiResponse<OUT>> Mono<OUT> post(Credentials credentials, String path, IN request, Class<RESPONSE> type) {
            return this.client.postAsJson((builder, json) -> this.addHeaders(credentials, builder, json), path, request, type).flatMap(this::handleResponse);
        }

        private <IN, OUT, RESPONSE extends ApiResponse<OUT>> Mono<OUT> handleResponse(Event<RESPONSE> event) {
            ApiResponse response = (ApiResponse)event.getResponse();
            int retCode = response.getRetCode();
            if (retCode > 0) {
                this.metricsLogger.finishedError(event);
                return Mono.error(new CxtlApiException(response.getRetMsg(), Integer.toString(retCode), BybitRestClient.errorCode(retCode)));
            }
            return Mono.just(((ApiResponse)event.getResponse()).getResult()).doFinally(v -> this.metricsLogger.finishedSuccess(event));
        }

        public Request.Builder addHeaders(Credentials credentials, Request.Builder builder, String message) {
            long now = Instant.now().toEpochMilli();
            String signature = this.sign(credentials, message, now);
            if (this.brokerId != null) {
                builder.addHeader("Referer", this.brokerId);
            }
            builder.addHeader("X-BAPI-API-KEY", credentials.getApiKey()).addHeader("X-BAPI-SIGN", signature).addHeader("X-BAPI-SIGN-TYPE", "2").addHeader("X-BAPI-TIMESTAMP", Long.toString(now)).addHeader("Content-Type", "application/json");
            if (this.receiveWindow != null) {
                builder.addHeader("X-BAPI-RECV-WINDOW", this.receiveWindow);
            }
            return builder;
        }

        private String sign(Credentials credentials, String message, long timestamp) {
            String sb = timestamp + credentials.getApiKey() + this.receiveWindow + message;
            return HmacUtils.sign(credentials, sb);
        }
    }
}

