/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.bybit.api.v5.lib;

import estonlabs.cxtl.common.AbstractStreamFactory;
import estonlabs.cxtl.common.EnvironmentType;
import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.common.codec.Codec;
import estonlabs.cxtl.common.codec.JacksonCodec;
import estonlabs.cxtl.common.security.HmacUtils;
import estonlabs.cxtl.common.stream.core.WebsocketConnection;
import estonlabs.cxtl.common.stream.managed.OutboundMessage;
import estonlabs.cxtl.exchanges.a.specification.domain.AssetClass;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.stream.ByBitOutboundMessage;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.stream.BybitInboundContainer;
import estonlabs.cxtl.exchanges.bybit.api.v5.domain.types.Category;
import java.net.Proxy;
import java.net.URI;
import java.time.Instant;
import java.util.List;
import java.util.Map;

public class BybitStreamFactory
extends AbstractStreamFactory<ByBitOutboundMessage, BybitInboundContainer, BybitStreamFactory> {
    private static final ByBitOutboundMessage PING = new ByBitOutboundMessage(OutboundMessage.MessageType.PING);
    public static final URI PROD = URI.create("wss://stream.bybit.com/v5");
    public static final URI TEST_NET = URI.create("wss://stream-testnet.bybit.com/v5");
    public static final Map<EnvironmentType, List<URI>> ENVIRONMENTS = Map.of(EnvironmentType.PROD, List.of(PROD), EnvironmentType.TEST_NET, List.of(TEST_NET));
    private static final Codec<Object> CODEC = new JacksonCodec();
    private URI baseUri;

    public BybitStreamFactory() {
        this(PROD);
    }

    public BybitStreamFactory(URI baseUri) {
        super(Exchange.BYBIT, CODEC, BybitInboundContainer.class);
        this.baseUri = baseUri;
        this.ping(15000L, () -> PING);
    }

    public static BybitStreamFactory create(URI uri) {
        return new BybitStreamFactory(uri);
    }

    public static BybitStreamFactory prod() {
        return new BybitStreamFactory(PROD);
    }

    @Override
    protected BybitStreamFactory me() {
        return this;
    }

    public WebsocketConnection<ByBitOutboundMessage, BybitInboundContainer> createPrivateStream(Credentials credentials) {
        return this.createPrivateStream(credentials, this.httpProxy);
    }

    public WebsocketConnection<ByBitOutboundMessage, BybitInboundContainer> createPrivateStream(Credentials credentials, Proxy httpProxy) {
        if (credentials == null) {
            throw new IllegalStateException("Credentials must be set to create a private websocket for Bybit");
        }
        String url = this.baseUri.toString() + "/private";
        return this.newPrivateWebsocket(URI.create(url), null, httpProxy, session -> {
            session.enableLogin(() -> {
                long expires = Instant.now().toEpochMilli() + 10000L;
                String val2 = "GET/realtime" + expires;
                String signature = HmacUtils.sign(credentials, val2);
                ByBitOutboundMessage request = new ByBitOutboundMessage(OutboundMessage.MessageType.LOGON);
                request.setArgs(List.of(credentials.getApiKey(), Long.valueOf(expires), signature));
                return request;
            });
            return session;
        });
    }

    public WebsocketConnection<ByBitOutboundMessage, BybitInboundContainer> createPublicStream(AssetClass assetClass) {
        Category category = Category.from(assetClass);
        String url = this.baseUri.toString() + "/public/" + category;
        return this.newPublicWebsocket(URI.create(url), null);
    }
}

